/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.webservice;

import java.util.EventObject;
import org.opengis.webservice.WebService;
import org.opengis.webservice.WebServiceClient;
import org.opengis.webservice.WebServiceRequest;
import org.opengis.webservice.WebServiceResponse;

public final class WebServiceEvent
extends EventObject {
    public static final int REQUEST = 0;
    public static final int RESPONSE = 1;
    private final WebServiceClient client;
    private final WebServiceRequest request;
    private final WebServiceResponse response;
    private final String id;
    private final int type;
    private final String message;

    public WebServiceEvent(WebService webService, WebServiceRequest webServiceRequest, String string) {
        super(webService);
        this.client = null;
        this.request = webServiceRequest;
        this.response = null;
        this.id = webServiceRequest.getId();
        this.type = 0;
        this.message = string;
    }

    public WebServiceEvent(WebService webService, WebServiceRequest webServiceRequest, String string, WebServiceClient webServiceClient) {
        super(webService);
        this.client = webServiceClient;
        this.request = webServiceRequest;
        this.response = null;
        this.id = webServiceRequest.getId();
        this.type = 0;
        this.message = string;
    }

    public WebServiceEvent(WebService webService, WebServiceResponse webServiceResponse, String string) {
        super(webService);
        this.client = null;
        this.request = null;
        this.response = webServiceResponse;
        this.id = webServiceResponse.getRequest() != null ? webServiceResponse.getRequest().getId() : "";
        this.type = 1;
        this.message = string;
    }

    public String getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public WebServiceRequest getRequest() {
        return this.request;
    }

    public WebServiceResponse getResponse() {
        return this.response;
    }

    public WebService getEventSource() {
        return (WebService)super.getSource();
    }

    public WebServiceClient getDestination() {
        return this.client;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        String string = null;
        string = this.getClass().getName() + ":\n";
        string = string + "request = " + this.request + "\n";
        string = string + "response = " + this.response + "\n";
        string = string + "client = " + this.client + "\n";
        string = string + "type = " + this.type + "\n";
        string = string + "message = " + this.message + "\n";
        return string;
    }
}

