/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_salt;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KGroundwaterNaCl", author="Manfred Fink", description="Groundwater NaCl module with two different NaCl-Pools")
public class J2KGroundwaterNaCl
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual RG1 storage")
    public JAMSDouble actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual RG2 storage")
    public JAMSDouble actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG1 NaCl storage in kgNaCl")
    public JAMSDouble NaClActRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG2 NaCl storage in kgNaCl")
    public JAMSDouble NaClActRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="RG1 inflow")
    public JAMSDouble inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="RG2 inflow")
    public JAMSDouble inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="RG1 outflow")
    public JAMSDouble outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="RG2 outflow")
    public JAMSDouble outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG1 NaCl inflow in kgNaCl")
    public JAMSDouble NaCl_RG1_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG2 NaCl inflow in kgNaCl")
    public JAMSDouble NaCl_RG2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG1 NaCl outflow in kgNaCl")
    public JAMSDouble NaCl_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG2 NaCl outflow in kgNaCl")
    public JAMSDouble NaCl_RG2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="NaCl Percolation out of the soil profile in kgNaCl")
    public JAMSDouble PercoNaClabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU Concentration in mgNaCl/l for RG1")
    public JAMSDouble NaCl_concRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU Concentration in mgNaCl/l for RG2")
    public JAMSDouble NaCl_concRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG1 storage")
    public JAMSDouble maxRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG2 storage")
    public JAMSDouble maxRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="gwExcess")
    public JAMSDouble gwExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="gwExcess")
    public JAMSDouble NaClExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="portion of percolation to RG1 in l")
    public JAMSDouble pot_RG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="portion of percolation to RG2 in l")
    public JAMSDouble pot_RG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Relativ size of the groundwaterN damping tank RG1 0 - 10 to calibrate in -")
    public JAMSDouble NaCl_delay_RG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Relativ size of the groundwaterN damping tank RG2 0 - 10 to calibrate in -")
    public JAMSDouble NaCl_delay_RG2;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double runNaCl_RG1_out = 0.0;
        double runNaCl_RG2_out = 0.0;
        double RG1_out = this.outRG1.getValue();
        double RG2_out = this.outRG2.getValue();
        double ActRG1 = this.actRG1.getValue();
        double ActRG2 = this.actRG2.getValue();
        double MaxRG1 = this.maxRG1.getValue();
        double MaxRG2 = this.maxRG2.getValue();
        double rungwExcess = this.gwExcess.getValue();
        double runNaCl_RG1_in = this.NaCl_RG1_in.getValue();
        double runNaCl_RG2_in = this.NaCl_RG2_in.getValue();
        double runNaClActRG1 = this.NaClActRG1.getValue();
        double runNaClActRG2 = this.NaClActRG2.getValue();
        double runNaCl_concRG1 = 0.0;
        double runNaCl_concRG2 = 0.0;
        double runpot_RG1 = this.pot_RG1.getValue();
        double runpot_RG2 = this.pot_RG2.getValue();
        double percoNaCl = this.PercoNaClabs.getValue();
        double RGNretentinon = 1.0;
        double NaCl_Excess = this.NaClExcess.getValue();
        double partNaCl_Excess = 0.0;
        double partNaCl_RG1 = 0.0;
        double partNaCl_RG2 = 0.0;
        double percwatersum = runpot_RG1 + runpot_RG2 + rungwExcess;
        if (percwatersum > 0.0) {
            partNaCl_RG1 = runpot_RG1 / percwatersum * percoNaCl;
            partNaCl_RG2 = runpot_RG2 / percwatersum * percoNaCl;
            partNaCl_Excess = rungwExcess / percwatersum * percoNaCl;
        }
        double watersum_RG1 = ActRG1 + RG1_out + MaxRG1 * this.NaCl_delay_RG1.getValue();
        double watersum_RG2 = ActRG2 + RG2_out + MaxRG2 * this.NaCl_delay_RG2.getValue();
        NaCl_Excess += partNaCl_Excess;
        runNaClActRG1 = runNaClActRG1 + runNaCl_RG1_in + partNaCl_RG1;
        runNaClActRG2 = runNaClActRG2 + runNaCl_RG2_in + partNaCl_RG2;
        runNaCl_concRG1 = watersum_RG1 > 0.0 ? runNaClActRG1 * 1000000.0 / watersum_RG1 : 0.0;
        runNaCl_concRG2 = watersum_RG2 > 0.0 ? runNaClActRG2 * 1000000.0 / watersum_RG2 : 0.0;
        runNaCl_RG1_out = RG1_out * runNaCl_concRG1 / 1000000.0;
        runNaCl_RG2_out = RG2_out * runNaCl_concRG2 / 1000000.0;
        if (runNaCl_RG1_out > runNaClActRG1) {
            runNaCl_RG1_out = runNaClActRG1;
        }
        if (runNaCl_RG2_out > runNaClActRG2) {
            runNaCl_RG2_out = runNaClActRG2;
        }
        runNaClActRG1 -= runNaCl_RG1_out;
        runNaClActRG2 -= runNaCl_RG2_out;
        this.NaCl_RG1_in.setValue(0.0);
        this.NaCl_RG2_in.setValue(0.0);
        this.NaCl_RG1_out.setValue(runNaCl_RG1_out);
        this.NaCl_RG2_out.setValue(runNaCl_RG2_out);
        this.NaClActRG1.setValue(runNaClActRG1);
        this.NaClActRG2.setValue(runNaClActRG2);
        this.NaCl_concRG1.setValue(runNaCl_concRG1);
        this.NaCl_concRG2.setValue(runNaCl_concRG2);
        this.NaClExcess.setValue(NaCl_Excess);
    }

    public void cleanup() {
    }
}

