/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="j2kETP_E_TP", author="Manfred Fink", description="Module for the calculation of seperate evaportion and transpiratoin from the actual evapotranspiration very simple Method in SWAT")
public class j2kETP_E_TP
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="number of layers in soil profile in [-]")
    public JAMSDouble Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of state variables LAI ")
    public JAMSDouble LAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU actual Evapotranspiration in mm")
    public JAMSDoubleArray actETP_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU actual Evapotranspiration in mm")
    public JAMSDouble aETP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU actual Evaporation in mm")
    public JAMSDouble aEP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU actual Transpiration in mm")
    public JAMSDouble aTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU potential Evapotranspiration in mm")
    public JAMSDouble pETP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU potential Evaporation in mm")
    public JAMSDouble pEP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU potential Transpiration in mm")
    public JAMSDouble pTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" actual evaporation in mm")
    public JAMSDoubleArray aEP_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" actual evaporation in mm")
    public JAMSDoubleArray aTP_h = new JAMSDoubleArray();

    public void init() {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int layer = (int)this.Layer.getValue();
        double runpETP = this.pETP.getValue();
        double runaETP = this.aETP.getValue();
        double aTransp = 0.0;
        double aEvap = 0.0;
        double pTransp = 0.0;
        double pEvap = 0.0;
        double runLAI = this.LAI.getValue();
        double[] actet_h = new double[layer];
        double[] acttran_h = new double[layer];
        if (runLAI <= 3.0) {
            aTransp = runaETP * runLAI / 3.0;
            pTransp = runpETP * runLAI / 3.0;
        } else if (runLAI > 3.0) {
            aTransp = runaETP;
            pTransp = runpETP;
        }
        aEvap = runaETP - aTransp;
        pEvap = runpETP - pTransp;
        this.aEP.setValue(aEvap);
        this.aTP.setValue(aTransp);
        this.pEP.setValue(pEvap);
        this.pTP.setValue(pTransp);
        for (int i = 0; i < layer; ++i) {
            double actTran = 0.0;
            double actETP = this.actETP_h.getValue()[i];
            if (runLAI <= 3.0) {
                actTran = actETP * runLAI / 3.0;
            } else if (runLAI > 3.0) {
                actTran = actETP;
            }
            acttran_h[i] = actTran;
            actet_h[i] = actETP - actTran;
        }
        this.aTP_h.setValue(acttran_h);
        this.aEP_h.setValue(actet_h);
    }

    public void cleanup() {
    }
}

