/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.init;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="j2kTemp_avg_sumlayer", author="Manfred Fink", description="Module for the calculation of long yearly average temperature and temperature sum and assingment of intitial temperatures of soil layers and soilsuface")
public class j2kTemp_avg_sumlayer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Daily mean temperature in \u00c2\u00b0C")
    public JAMSDouble tmeanpre;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="mean temperature of the simulation period in \u00c2\u00b0C")
    public JAMSDouble tmeanavg;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="average yearly temperature sum of the simulation period in \u00c2\u00b0C")
    public JAMSDouble tmeansum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="number of current days")
    public JAMSDouble I;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="soil temperature in layerdepth in \u00c2\u00b0C")
    public JAMSDoubleArray Soil_Temp_Layer = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C *  Output soil surface temperature")
    public JAMSDouble Surfacetemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="number of layers in soil profile in [-]")
    public JAMSDouble Layer;

    public void init() {
        this.tmeanavg.setValue(0.0);
        this.tmeansum.setValue(0.0);
        this.I.setValue(0.0);
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double tempmean = this.tmeanpre.getValue();
        double tempmeanavg = this.tmeanavg.getValue();
        double tempmeansum = this.tmeansum.getValue();
        double ii = this.I.getValue();
        int layer = (int)this.Layer.getValue();
        double[] Soil_Temp_Layervals = new double[layer];
        tempmeanavg = (tempmeanavg * ((ii += 1.0) - 1.0) + tempmean) / ii;
        tempmeansum = (tempmeansum * ((ii - 1.0) / 365.25) + tempmean) / (ii / 365.25);
        this.tmeanavg.setValue(tempmeanavg);
        this.tmeansum.setValue(tempmeansum);
        for (int j = 0; j < layer; ++j) {
            Soil_Temp_Layervals[j] = tempmeanavg;
        }
        this.Soil_Temp_Layer.setValue(Soil_Temp_Layervals);
        this.Surfacetemp.setValue(tempmeanavg);
        this.I.setValue(ii);
    }

    public void cleanup() {
    }
}

