/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.crop;

import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSModel;
import org.unijena.jams.model.JAMSVarDescription;

public class StandardLMArableParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Arable crop rotation parameter file name")
    public JAMSString laFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityCollection croprot = new JAMSEntityCollection();
        croprot.setEntities(J2KFunctions.readParas((String)(this.dirName.getValue() + "/" + this.laFileName.getValue()), (JAMSModel)this.getModel()));
        HashMap<Double, JAMSEntity> ctMap = new HashMap<Double, JAMSEntity>();
        for (JAMSEntity ct : croprot.getEntities()) {
            ctMap.put(ct.getDouble("ID"), ct);
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            JAMSEntity ct;
            ct = (JAMSEntity)ctMap.get(e.getDouble("croprotID"));
            e.setObject("croprot", (Object)ct);
            Object[] attrs = ct.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                e.setDouble((String)attrs[i], ct.getDouble((String)attrs[i]));
            }
        }
    }
}

