/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSEntityEnumerator;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KNSoil", author="Manfred Fink", description="Calculates Nitrogen transformation Processes in Soil. Method after SWAT2000")
public class J2KNSoil_SWIM
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU attribute name area in m\u00c2\u00b2")
    public JAMSString aNameArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="in mm depth of soil layer")
    public JAMSString aNamelayerdepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="in mm depth of soil profile")
    public JAMSString aNametotaldepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="in kg/dm\u00c2\u00b3 soil bulk density")
    public JAMSDouble aNamesoil_bulk_density;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="actual LPS in portion of sto_LPS soil water content")
    public JAMSString aNamesat_LPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="actual MPS in portion of sto_MPS soil water content")
    public JAMSString aNamesat_MPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum MPS  in l soil water content")
    public JAMSString aNamestohru_MPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum LPS  in l soil water content")
    public JAMSString aNamestohru_LPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum FPS  in l soil water content")
    public JAMSString aNamestohru_FPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="soil temperature in layerdepth in \u00c2\u00b0C")
    public JAMSString aNameSoil_Temp_Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" in - Leaf area index")
    public JAMSString aNameLAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" in % organic Carbon in soil")
    public JAMSDouble aNameC_org;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" NO3-Pool in kgN/ha")
    public JAMSString aNameNO3_Pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" NH4-Pool in kgN/ha")
    public JAMSString aNameNH4_Pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" N-Organic Pool with reactive organic matter in kgN/ha")
    public JAMSString aNameN_activ_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" N-Organic Pool with stable organic matter in kgN/ha")
    public JAMSString aNameN_stabel_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Residue in Layer in kgN/ha")
    public JAMSString aNameResidue_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" N-Organic fresh Pool from Residue in kgN/ha")
    public JAMSString aNameN_residue_pool_fresh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" actual evaporation in mm")
    public JAMSString aNameaEvap;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" surface runoff in l")
    public JAMSString aNameRD1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" interflow in l")
    public JAMSString aNameRD2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" percolation in l")
    public JAMSString aNameD_perco;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" plantuptake rate in kgN/ha")
    public JAMSString aNamePlantupN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" nitrification rate from  NO3_Pool in kgN/ha")
    public JAMSString aNameNitri_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" denitrification rate from  NO3_Pool in kgN/ha")
    public JAMSString aNameDenit_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Nitrate in surface runoff in  in kgN/ha")
    public JAMSString aNameSurfaceN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Nitrate in interflow in  in kgN/ha")
    public JAMSString aNameInterflowN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Nitrate in percolation in  in kgN/ha")
    public JAMSString aNamePercoN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Nitrate in surface runoff in  in kgN")
    public JAMSString aNameSurfaceNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Nitrate in interflow in  in kgN")
    public JAMSString aNameInterflowNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Nitrate in percolation in  in kgN")
    public JAMSString aNamePercoNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Nitrate in surface runoff added to HRU layer in in kgN")
    public JAMSString aNameSurfaceN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Nitrate in interflow in added to HRU layer in kgN")
    public JAMSString aNameInterflowN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" Nitrate in percolation in added to HRU layer in kgN")
    public JAMSString aNamePercoN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" rate constant between N_activ_pool and N_stabel_pool = 0.00001")
    public JAMSDouble aNameBeta_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" rate factor between N_activ_pool and NO3_Pool to be calibrated 0.001 - 0.003")
    public JAMSDouble aNameBeta_min;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" rate factor between Residue_pool and NO3_Pool to be calibrated 0.1 - 0.02")
    public JAMSDouble aNameBeta_rsd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" percolation coefitient to calibrate = 0.2")
    public JAMSDouble aNameBeta_NO3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" net precipitation in mm")
    public JAMSString aNameNetPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" actual Transpiration in mm")
    public JAMSString aNameaTransp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    private double gamma_temp;
    private double gamma_water;
    private double area;
    private double Soil_Temp_Layer;
    private double layerdepth;
    private double soil_bulk_density;
    private double sto_MPS;
    private double sto_LPS;
    private double sto_FPS;
    private double act_LPS;
    private double act_MPS;
    private double netPrecip;
    private double LAI;
    private double C_org;
    private double C_org_kg_ha = 0.0;
    private double NO3_Pool;
    private double N_activ_pool;
    private double N_stabel_pool;
    private double N_residue_pool_fresh;
    private double Residue_pool;
    private double aEvap;
    private double RD1_out_mm;
    private double RD2_out_mm;
    private double d_perco_mm;
    private int layer;
    private double volati_trans;
    private double NH4inp;
    private double plantupN;
    private double denit_trans;
    private double surfaceN;
    private double interflowN;
    private double percoN;
    private double surfaceNabs;
    private double interflowNabs;
    private double percoNabs;
    private double surfaceN_in;
    private double interflowN_in;
    private double percoN_in;
    private double Beta_trans;
    private double Beta_min;
    private double Beta_rsd;
    private double Beta_NO3;
    private double aTransp;
    private boolean precalc_nit_vol;
    private double theta_nit = 0.05;
    private double fr_actN = 0.02;
    private double N_nit_vol = 0.0;
    private double frac_nitr = 0.0;
    private double frac_vol = 0.0;
    private double Hum_trans;
    private double Hum_act_min;
    private double delta_ntr = 0.0;
    private double concN_mobile = 0.0;
    private int datumjul = 0;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityEnumerator eEnum = this.hrus.getEntityEnumerator();
        JAMSEntity[] entities = this.hrus.getEntityArray();
        for (int i = 0; i < entities.length; ++i) {
            double orgNhum = 0.0;
            this.C_org = this.aNameC_org.getValue();
            this.soil_bulk_density = this.aNamesoil_bulk_density.getValue();
            this.layerdepth = entities[i].getDouble(this.aNamelayerdepth.getValue()) * 100.0;
            this.Residue_pool = 10.0;
            this.NO3_Pool = 7.0 * Math.exp(-this.layerdepth / 1000.0) * this.soil_bulk_density * this.layerdepth / 100.0;
            orgNhum = 10000.0 * this.C_org / 14.0;
            this.N_activ_pool = orgNhum * this.fr_actN * this.soil_bulk_density * this.layerdepth / 100.0;
            this.N_stabel_pool = orgNhum * (1.0 - this.fr_actN) * this.soil_bulk_density * this.layerdepth / 100.0;
            this.N_residue_pool_fresh = 0.0015 * this.Residue_pool;
            entities[i].setDouble(this.aNameNO3_Pool.getValue(), this.NO3_Pool);
            entities[i].setDouble(this.aNameN_activ_pool.getValue(), this.N_activ_pool);
            entities[i].setDouble(this.aNameN_stabel_pool.getValue(), this.N_stabel_pool);
            entities[i].setDouble(this.aNameResidue_pool.getValue(), this.Residue_pool);
            entities[i].setDouble(this.aNameN_residue_pool_fresh.getValue(), this.N_residue_pool_fresh);
            entities[i].setDouble(this.aNamePlantupN.getValue(), 0.0);
            entities[i].setDouble(this.aNameSurfaceN_in.getValue(), 0.0);
            entities[i].setDouble(this.aNameInterflowN_in.getValue(), 0.0);
            entities[i].setDouble(this.aNamePercoN_in.getValue(), 0.0);
            entities[i].setDouble(this.aNameSurfaceNabs.getValue(), 0.0);
            entities[i].setDouble(this.aNameInterflowNabs.getValue(), 0.0);
            entities[i].setDouble(this.aNamePercoNabs.getValue(), 0.0);
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int i = 1;
        this.gamma_temp = 0.0;
        this.gamma_water = 0.0;
        this.area = this.entity.getDouble(this.aNameArea.getValue());
        this.Soil_Temp_Layer = this.entity.getDouble(this.aNameSoil_Temp_Layer.getValue());
        this.layerdepth = this.entity.getDouble(this.aNamelayerdepth.getValue()) * 100.0;
        this.sto_MPS = this.entity.getDouble(this.aNamestohru_MPS.getValue()) / this.area;
        this.sto_LPS = this.entity.getDouble(this.aNamestohru_LPS.getValue()) / this.area;
        this.sto_FPS = this.sto_MPS * 0.3;
        this.act_LPS = this.entity.getDouble(this.aNamesat_LPS.getValue()) * this.sto_LPS;
        this.act_MPS = this.entity.getDouble(this.aNamesat_MPS.getValue()) * this.sto_MPS;
        this.netPrecip = this.entity.getDouble(this.aNameNetPrecip.getValue());
        this.LAI = this.entity.getDouble(this.aNameLAI.getValue());
        this.C_org = this.aNameC_org.getValue();
        this.C_org_kg_ha = this.C_org * 10000.0 * (this.layerdepth / 1000.0) / 66.66666666666667 * 1000.0;
        this.NO3_Pool = this.entity.getDouble(this.aNameNO3_Pool.getValue());
        this.N_activ_pool = this.entity.getDouble(this.aNameN_activ_pool.getValue());
        this.N_stabel_pool = this.entity.getDouble(this.aNameN_stabel_pool.getValue());
        this.N_residue_pool_fresh = this.entity.getDouble(this.aNameN_residue_pool_fresh.getValue());
        this.Residue_pool = this.entity.getDouble(this.aNameResidue_pool.getValue());
        this.aEvap = this.entity.getDouble(this.aNameaEvap.getValue());
        this.RD1_out_mm = this.entity.getDouble(this.aNameRD1_out.getValue()) / this.area;
        this.RD2_out_mm = this.entity.getDouble(this.aNameRD2_out.getValue()) / this.area;
        this.d_perco_mm = this.entity.getDouble(this.aNameD_perco.getValue()) / this.area;
        this.layer = 1;
        this.plantupN = this.entity.getDouble(this.aNamePlantupN.getValue());
        this.denit_trans = 0.0;
        this.surfaceN = 0.0;
        this.interflowN = 0.0;
        this.percoN = 0.0;
        this.surfaceN_in = this.entity.getDouble(this.aNameSurfaceN_in.getValue()) * 10000.0 / this.area;
        this.interflowN_in = this.entity.getDouble(this.aNameInterflowN_in.getValue()) * 10000.0 / this.area;
        this.percoN_in = this.entity.getDouble(this.aNamePercoN_in.getValue()) * 10000.0 / this.area;
        this.Beta_trans = this.aNameBeta_trans.getValue();
        this.Beta_min = this.aNameBeta_min.getValue();
        this.Beta_rsd = this.aNameBeta_rsd.getValue();
        this.Beta_NO3 = this.aNameBeta_NO3.getValue();
        this.aTransp = this.entity.getDouble(this.aNameaTransp.getValue());
        this.datumjul = this.time.get(6);
        this.gamma_temp = this.Soil_Temp_Layer / (this.Soil_Temp_Layer + Math.exp(6.82 - 0.232 * this.Soil_Temp_Layer));
        if (this.gamma_temp < 0.0) {
            this.gamma_temp = 0.0;
        }
        this.gamma_water = (this.act_LPS + this.act_MPS + this.sto_FPS) / (this.sto_LPS + this.sto_MPS + this.sto_FPS);
        if (this.datumjul == 100 || this.datumjul == 180) {
            this.Residue_pool += 2000.0;
            this.N_residue_pool_fresh = 0.0015 * this.Residue_pool;
        }
        if (this.aTransp > 0.0) {
            this.plantupN = this.aTransp / this.area * 0.3;
        }
        this.Hum_trans = this.calc_Hum_trans();
        this.Hum_act_min = this.calc_Hum_act_min();
        this.N_stabel_pool += this.Hum_trans;
        if (this.N_stabel_pool < 0.0) {
            this.N_stabel_pool = 0.0;
        }
        this.N_activ_pool -= this.Hum_trans;
        if (this.N_activ_pool < 0.0) {
            this.N_activ_pool = 0.0;
        }
        if (this.layer < 3) {
            this.delta_ntr = this.calc_Res_N_trans();
            this.Residue_pool -= this.delta_ntr * this.Residue_pool;
            if (this.Residue_pool < 0.0) {
                this.Residue_pool = 0.0;
            }
            this.N_activ_pool += 0.2 * (this.delta_ntr * this.N_residue_pool_fresh);
            if (this.N_activ_pool < 0.0) {
                this.N_activ_pool = 0.0;
            }
            this.NO3_Pool = this.NO3_Pool + this.Hum_act_min + this.interflowN_in + this.surfaceN_in + 0.8 * (this.delta_ntr * this.N_residue_pool_fresh);
            if (this.NO3_Pool > this.plantupN) {
                this.NO3_Pool -= this.plantupN;
            } else if (this.NO3_Pool <= this.plantupN) {
                this.plantupN = this.NO3_Pool;
                this.NO3_Pool = 0.0;
            }
            this.denit_trans = this.calc_denitrification();
            this.NO3_Pool -= this.denit_trans;
            if (this.NO3_Pool < 0.0) {
                this.NO3_Pool = 0.0;
            }
            this.N_residue_pool_fresh -= this.delta_ntr * this.N_residue_pool_fresh;
            if (this.N_residue_pool_fresh < 0.0) {
                this.N_residue_pool_fresh = 0.0;
            }
        } else if (this.layer >= 3) {
            this.NO3_Pool = this.NO3_Pool + this.interflowN_in + this.percoN_in;
            if (this.NO3_Pool > this.plantupN) {
                this.NO3_Pool -= this.plantupN;
            } else {
                this.plantupN = this.NO3_Pool;
                this.NO3_Pool = 0.0;
            }
            this.denit_trans = this.calc_denitrification();
            this.NO3_Pool -= this.denit_trans;
            if (this.NO3_Pool < 0.0) {
                this.NO3_Pool = 0.0;
            }
        }
        this.concN_mobile = this.calc_concN_mobile();
        this.surfaceN = this.calc_surfaceN();
        this.NO3_Pool -= this.surfaceN;
        this.interflowN = this.calc_interflowN();
        this.NO3_Pool -= this.interflowN;
        this.percoN = this.calc_percoN();
        this.NO3_Pool -= this.percoN;
        this.NO3_Pool = this.NO3_Pool > 0.0 ? this.NO3_Pool : 0.0;
        if (this.datumjul == i) {
            System.out.println("NO3_Pool = " + this.NO3_Pool + "datejul  =  " + ++i);
        }
        this.entity.setDouble(this.aNameNO3_Pool.getValue(), this.NO3_Pool);
        this.entity.setDouble(this.aNameN_activ_pool.getValue(), this.N_activ_pool);
        this.entity.setDouble(this.aNameN_stabel_pool.getValue(), this.N_stabel_pool);
        this.entity.setDouble(this.aNameN_residue_pool_fresh.getValue(), this.N_residue_pool_fresh);
        this.entity.setDouble(this.aNameResidue_pool.getValue(), this.Residue_pool);
        this.entity.setDouble(this.aNameDenit_trans.getValue(), this.denit_trans);
        this.entity.setDouble(this.aNameSurfaceN.getValue(), this.surfaceN);
        this.surfaceNabs = this.surfaceN * this.area / 10000.0;
        this.entity.setDouble(this.aNameSurfaceNabs.getValue(), this.surfaceNabs);
        this.entity.setDouble(this.aNameInterflowN.getValue(), this.interflowN);
        this.interflowNabs = this.interflowN * this.area / 10000.0;
        this.entity.setDouble(this.aNameInterflowNabs.getValue(), this.interflowNabs);
        this.entity.setDouble(this.aNamePercoN.getValue(), this.percoN);
        this.percoNabs = this.percoN * this.area / 10000.0;
        this.entity.setDouble(this.aNamePercoN.getValue(), this.percoNabs);
        this.entity.setDouble(this.aNamePlantupN.getValue(), this.plantupN);
    }

    private double calc_Hum_trans() {
        double N_Hum_trans = 0.0;
        N_Hum_trans = this.Beta_trans * (this.N_activ_pool / this.fr_actN - this.N_stabel_pool);
        return N_Hum_trans;
    }

    private double calc_Hum_act_min() {
        double N_Hum_act_min = 0.0;
        N_Hum_act_min = this.Beta_min * Math.sqrt(this.gamma_temp * this.gamma_water) * this.N_activ_pool;
        return N_Hum_act_min;
    }

    private double calc_Res_N_trans() {
        double epsilon_C_N = 0.0;
        double gamma_ntr = 0.0;
        if (this.N_residue_pool_fresh == 0.0 && this.NO3_Pool == 0.0) {
            this.delta_ntr = 0.0;
        } else {
            epsilon_C_N = this.Residue_pool * 0.58 / (this.N_residue_pool_fresh + this.NO3_Pool);
            gamma_ntr = Math.min(1.0, Math.exp(-0.693 * ((epsilon_C_N - 25.0) / 25.0)));
            this.delta_ntr = this.Beta_rsd * gamma_ntr * Math.sqrt(this.gamma_temp * this.gamma_water);
        }
        return this.delta_ntr;
    }

    private double calc_denitrification() {
        double denit_trans = 0.0;
        double gamma_tempcarb = 0.0;
        double gamma_waterdenit = 0.0;
        double cnd = -1.0E-5;
        if (this.gamma_water > 0.9) {
            gamma_waterdenit = 0.06 * Math.exp(3.0 * (this.act_LPS + this.act_MPS + this.sto_FPS) / (this.sto_LPS + this.sto_MPS + this.sto_FPS));
            gamma_tempcarb = 1.0 - Math.exp(cnd * this.Soil_Temp_Layer * this.C_org_kg_ha);
            denit_trans = this.NO3_Pool * gamma_tempcarb * gamma_waterdenit;
        } else if (this.gamma_water <= 0.9) {
            denit_trans = 0.0;
        }
        return denit_trans;
    }

    private double calc_concN_mobile() {
        double concN_mobile = 0.0;
        double WTOT = 0.0;
        double NFL = 0.0;
        if (this.layer == 1) {
            WTOT = this.RD1_out_mm + this.RD2_out_mm + this.d_perco_mm;
        } else if (this.layer > 1) {
            WTOT = this.RD2_out_mm + this.d_perco_mm;
        }
        NFL = this.NO3_Pool * (1.0 - Math.exp(-WTOT / (this.sto_LPS + this.sto_MPS)));
        concN_mobile = WTOT == 0.0 ? 0.0 : NFL / WTOT;
        return concN_mobile;
    }

    private double calc_surfaceN() {
        double surfaceN = 0.0;
        if (this.layer == 1) {
            surfaceN = this.Beta_NO3 * this.RD1_out_mm * this.concN_mobile;
            surfaceN = Math.min(surfaceN, this.NO3_Pool);
        } else if (this.layer > 1) {
            surfaceN = 0.0;
        }
        return surfaceN;
    }

    private double calc_interflowN() {
        double interflowN = 0.0;
        if (this.layer == 1) {
            interflowN = (1.0 - this.Beta_NO3) * this.RD2_out_mm * this.concN_mobile;
            interflowN = Math.min(interflowN, this.NO3_Pool);
        } else if (this.layer > 1) {
            interflowN = this.RD2_out_mm * this.concN_mobile;
            interflowN = Math.min(interflowN, this.NO3_Pool);
        }
        return interflowN;
    }

    private double calc_percoN() {
        double percoN = 0.0;
        percoN = this.d_perco_mm * this.concN_mobile;
        percoN = Math.min(percoN, this.NO3_Pool);
        return percoN;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

