/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KNRoutinglayer", author="Peter Krause & Manfred Fink", description="Passes the N output of the entities as N input to the respective reach or unit")
public class J2KNRoutinglayer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of reach objects")
    public JAMSEntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RD1 N inflow in kgN")
    public JAMSDouble SurfaceN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RD2 N inflow in kgN")
    public JAMSDoubleArray InterflowN_in = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG1 N inflow in kgN")
    public JAMSDouble N_RG1_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG2 N inflow in kgN")
    public JAMSDouble N_RG2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RD1 N outflow in kgN")
    public JAMSDouble SurfaceNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RD2 N outflow in kgN")
    public JAMSDoubleArray InterflowNabs = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG1 N outflow in kgN")
    public JAMSDouble N_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG2 N outflow in kgN")
    public JAMSDouble N_RG2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="gwExcess")
    public JAMSDouble NExcess;
    double[][] fracOut;
    double[] percNOut;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        JAMSEntity toPoly = (JAMSEntity)entity.getObject("to_poly");
        JAMSEntity toReach = (JAMSEntity)entity.getObject("to_reach");
        double NRD1out = this.SurfaceNabs.getValue();
        double[] NRD2out_h = this.InterflowNabs.getValue();
        double NRG1out = this.N_RG1_out.getValue();
        double NRG2out = this.N_RG2_out.getValue();
        double reachNRD2in = 0.0;
        if (toPoly != null) {
            double[] srcDepth = ((JAMSDoubleArray)entity.getObject("depth_h")).getValue();
            double[] recDepth = ((JAMSDoubleArray)toPoly.getObject("depth_h")).getValue();
            int srcHors = srcDepth.length;
            int recHors = recDepth.length;
            double[] NRD2in_h = new double[recHors];
            double NRD1in = toPoly.getDouble("SurfaceN_in");
            double[] rdArN = ((JAMSDoubleArray)toPoly.getObject("InterflowN_in")).getValue();
            double NRG1in = toPoly.getDouble("N_RG1_in");
            double NRG2in = toPoly.getDouble("N_RG2_in");
            for (int j = 0; j < recHors; ++j) {
                NRD2in_h[j] = rdArN[j];
                for (int i = 0; i < srcHors; ++i) {
                    NRD2in_h[j] = NRD2in_h[j] + NRD2out_h[i] / (double)recHors;
                }
            }
            for (int i = 0; i < srcHors; ++i) {
                NRD2out_h[i] = 0.0;
            }
            int n = recHors - 1;
            NRD2in_h[n] = NRD2in_h[n] + this.NExcess.getValue();
            double RD1in = toPoly.getDouble("inRD1");
            double RG2in = toPoly.getDouble("inRG2");
            NRD1in += NRD1out;
            NRG1in += NRG1out;
            NRG2in += NRG2out;
            NRD1out = 0.0;
            NRG1out = 0.0;
            NRG2out = 0.0;
            this.SurfaceNabs.setValue(0.0);
            this.InterflowNabs.setValue(NRD2out_h);
            this.N_RG1_out.setValue(0.0);
            this.N_RG2_out.setValue(0.0);
            this.NExcess.setValue(0.0);
            JAMSDoubleArray rdAN = (JAMSDoubleArray)toPoly.getObject("InterflowN_in");
            rdAN.setValue(NRD2in_h);
            toPoly.setDouble("SurfaceN_in", NRD1in);
            toPoly.setObject("InterflowN_in", (Object)rdAN);
            toPoly.setDouble("N_RG1_in", NRG1in);
            toPoly.setDouble("N_RG2_in", NRG2in);
        } else if (toReach != null) {
            double NRD1in = toReach.getDouble("SurfaceN_in");
            reachNRD2in = toReach.getDouble("InterflowN_sum");
            double NRG1in = toReach.getDouble("N_RG1_in");
            double NRG2in = toReach.getDouble("N_RG2_in");
            for (int h = 0; h < NRD2out_h.length; ++h) {
                reachNRD2in += NRD2out_h[h];
                NRD2out_h[h] = 0.0;
            }
            NRD1in += NRD1out;
            reachNRD2in += this.NExcess.getValue();
            NRG1in += NRG1out;
            NRG2in += NRG2out;
            NRD1out = 0.0;
            NRG1out = 0.0;
            NRG2out = 0.0;
            this.NExcess.setValue(0.0);
            this.SurfaceNabs.setValue(0.0);
            toReach.setDouble("SurfaceN_in", NRD1in);
            this.InterflowNabs.setValue(NRD2out_h);
            toReach.setDouble("InterflowN_sum", reachNRD2in);
            this.N_RG1_out.setValue(NRG1out);
            toReach.setDouble("N_RG1_in", NRG1in);
            this.N_RG2_out.setValue(NRG2out);
            toReach.setDouble("N_RG2_in", NRG2in);
        } else {
            System.out.println("Current entity ID: " + entity.getDouble("ID") + " has no receiver.");
        }
    }

    public void cleanup() {
    }
}

