/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSEntityEnumerator;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KGroundwaterN_lumped", author="Manfred Fink", description="Groundwater N module")
public class J2KGroundwaterN_lumped
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="attribute area")
    public JAMSString aNameArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="actual RG1 storage")
    public JAMSString aNameActRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="actual RG2 storage")
    public JAMSString aNameActRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="actual RG N storage in kgN")
    public JAMSString aNameNActRG;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG1 inflow")
    public JAMSString aNameInRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG2 inflow")
    public JAMSString aNameInRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG1 outflow")
    public JAMSString aNameOutRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG2 outflow")
    public JAMSString aNameOutRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG1 N inflow in kgN")
    public JAMSString aNameN_RG1_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG2 N inflow in kgN")
    public JAMSString aNameN_RG2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG1 N outflow in kgN")
    public JAMSString aNameN_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG2 N outflow in kgN")
    public JAMSString aNameN_RG2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="N Percolation out of the soil profile in kgN")
    public JAMSString aNamePercoNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU Concentration in mgN/l for RG1")
    public JAMSString aNameN_concRG;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum RG1 storage")
    public JAMSString aNameMaxRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum RG2 storage")
    public JAMSString aNameMaxRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="N Grounwater buffer storage in kgN")
    public JAMSString aNameNGWbuffer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Relativ size of the groundwaterN damping tank 0 - 10 to calibrate in -")
    public JAMSDouble N_delay;
    double N_RG1_in = 0.0;
    double N_RG2_in = 0.0;
    double N_RG1_out = 0.0;
    double N_RG2_out = 0.0;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityEnumerator eEnum = this.hrus.getEntityEnumerator();
        JAMSEntity[] entities = this.hrus.getEntityArray();
        for (int i = 0; i < entities.length; ++i) {
            entities[i].setDouble(this.aNameN_RG1_in.getValue(), 0.0);
            entities[i].setDouble(this.aNameN_RG2_in.getValue(), 0.0);
            entities[i].setDouble(this.aNameN_concRG.getValue(), 3.8);
            double iN_concRG = entities[i].getDouble(this.aNameN_concRG.getValue());
            double iActRG1 = entities[i].getDouble(this.aNameActRG1.getValue());
            double iActRG2 = entities[i].getDouble(this.aNameActRG2.getValue());
            double iNActRG = (entities[i].getDouble(this.aNameMaxRG1.getValue()) + entities[i].getDouble(this.aNameMaxRG2.getValue())) * iN_concRG / 1000000.0 * this.N_delay.getValue();
            entities[i].setDouble(this.aNameNActRG.getValue(), iNActRG);
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double RG1_out = this.entity.getDouble(this.aNameOutRG1.getValue());
        double RG2_out = this.entity.getDouble(this.aNameOutRG2.getValue());
        double ActRG1 = this.entity.getDouble(this.aNameActRG1.getValue());
        double MaxRG1 = this.entity.getDouble(this.aNameMaxRG1.getValue());
        double MaxRG2 = this.entity.getDouble(this.aNameMaxRG2.getValue());
        double ActRG2 = this.entity.getDouble(this.aNameActRG2.getValue());
        double N_RG1_in = this.entity.getDouble(this.aNameN_RG1_in.getValue());
        double N_RG2_in = this.entity.getDouble(this.aNameN_RG2_in.getValue());
        double NActRG = this.entity.getDouble(this.aNameNActRG.getValue());
        double N_concRG = this.entity.getDouble(this.aNameN_concRG.getValue());
        double percoN = this.entity.getDouble(this.aNamePercoNabs.getValue());
        double RGNretentinon = 1.0;
        NActRG = N_RG1_in + N_RG2_in + percoN + NActRG;
        double watersum = ActRG1 + ActRG2 + RG1_out + RG2_out + (MaxRG1 + MaxRG2) * this.N_delay.getValue();
        N_concRG = watersum > 0.0 ? NActRG * 1000000.0 / watersum : 0.0;
        this.N_RG1_out = RG1_out * N_concRG / 1000000.0;
        this.N_RG2_out = RG2_out * N_concRG / 1000000.0;
        if (this.N_RG1_out + this.N_RG2_out > NActRG) {
            double rg1part = this.N_RG1_out / (this.N_RG1_out + this.N_RG2_out);
            double rg2part = this.N_RG2_out / (this.N_RG1_out + this.N_RG2_out);
            this.N_RG1_out = rg1part * NActRG;
            this.N_RG2_out = rg2part * NActRG;
        }
        this.entity.setDouble(this.aNameN_RG1_in.getValue(), N_RG1_in);
        this.entity.setDouble(this.aNameN_RG2_in.getValue(), N_RG2_in);
        this.entity.setDouble(this.aNameN_RG1_out.getValue(), this.N_RG1_out);
        this.entity.setDouble(this.aNameN_RG2_out.getValue(), this.N_RG2_out);
        this.entity.setDouble(this.aNameNActRG.getValue(), NActRG -= this.N_RG1_out + this.N_RG2_out);
        this.entity.setDouble(this.aNameN_concRG.getValue(), N_concRG);
    }

    public void cleanup() {
    }
}

