/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;
import org.geotools.filter.Filter;

public class JDBCFeatureStore
extends JDBCFeatureSource
implements FeatureStore {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    protected Transaction transaction = Transaction.AUTO_COMMIT;

    public JDBCFeatureStore(JDBC1DataStore jdbcDataStore, FeatureType featureType) {
        super(jdbcDataStore, featureType);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    protected InProcessLockingManager getInProcessLockingManager() {
        LockingManager lockingManager = this.getJDBCDataStore().getLockingManager();
        if (lockingManager instanceof InProcessLockingManager) {
            return (InProcessLockingManager)lockingManager;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set fids(Filter filter) throws NoSuchElementException, IOException, IllegalAttributeException {
        HashSet<String> fids = new HashSet<String>();
        String typeName = this.getSchema().getTypeName();
        DefaultQuery query = new DefaultQuery(typeName, filter, Integer.MAX_VALUE, Query.ALL_NAMES, "fids");
        FeatureReader reader = this.getJDBCDataStore().getFeatureReader(query, this.getTransaction());
        try {
            while (reader.hasNext()) {
                fids.add(reader.next().getID());
            }
        }
        finally {
            reader.close();
        }
        return fids;
    }

    protected void assertFilter(Filter filter) throws IOException {
        if (this.getInProcessLockingManager() == null) {
            return;
        }
        Set set = null;
        try {
            set = this.fids(filter);
        }
        catch (NoSuchElementException huh) {
            throw new FeatureLockException("Could not verify filter:", huh);
        }
        catch (IllegalAttributeException eh) {
            throw new FeatureLockException("Could not verify filter:", eh);
        }
        this.assertFids(set);
    }

    protected void assertFids(Set fids) throws FeatureLockException {
        InProcessLockingManager lockingManager = this.getInProcessLockingManager();
        if (lockingManager == null) {
            return;
        }
        Transaction t = this.getTransaction();
        String typeName = this.getSchema().getTypeName();
        Iterator i = fids.iterator();
        while (i.hasNext()) {
            String fid = (String)i.next();
            lockingManager.assertAccess(typeName, fid, this.transaction);
        }
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new AttributeType[]{type}, new Object[]{value}, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter) throws IOException {
        String typeName = this.getSchema().getTypeName();
        if (this.getTransaction() == Transaction.AUTO_COMMIT) {
            DefaultTransaction atomic = new DefaultTransaction();
            try {
                FeatureWriter writer = this.getDataStore().getFeatureWriter(typeName, filter, (Transaction)atomic);
                this.modifyFeatures(type, value, writer);
                atomic.commit();
            }
            catch (Throwable t) {
                atomic.rollback();
            }
            finally {
                atomic.close();
            }
        } else {
            FeatureWriter writer = this.getDataStore().getFeatureWriter(typeName, filter, this.getTransaction());
            this.modifyFeatures(type, value, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyFeatures(AttributeType[] type, Object[] value, FeatureWriter writer) throws DataSourceException, IOException {
        try {
            while (writer.hasNext()) {
                Feature feature = writer.next();
                for (int i = 0; i < type.length; ++i) {
                    try {
                        feature.setAttribute(type[i].getName(), value[i]);
                        continue;
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Could not update feature " + feature.getID() + " with " + type[i].getName() + "=" + value[i], (Throwable)e);
                    }
                }
                writer.write();
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set addFeatures(FeatureReader reader) throws IOException {
        HashSet<String> addedFids = new HashSet<String>();
        String typeName = this.getSchema().getTypeName();
        Feature feature = null;
        FeatureWriter writer = this.getDataStore().getFeatureWriterAppend(typeName, this.getTransaction());
        try {
            while (reader.hasNext()) {
                try {
                    feature = reader.next();
                }
                catch (Exception e) {
                    throw new DataSourceException("Could not add Features, problem with provided reader", (Throwable)e);
                }
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes(null));
                }
                catch (IllegalAttributeException writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), (Throwable)writeProblem);
                }
                writer.write();
                addedFids.add(newFeature.getID());
            }
        }
        finally {
            reader.close();
            writer.close();
        }
        return addedFids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set addFeatures(FeatureCollection collection) throws IOException {
        HashSet<String> addedFids = new HashSet<String>();
        String typeName = this.getSchema().getTypeName();
        Feature feature = null;
        FeatureWriter writer = this.getDataStore().getFeatureWriterAppend(typeName, this.getTransaction());
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                try {
                    feature = (Feature)iterator.next();
                }
                catch (Exception e) {
                    throw new DataSourceException("Could not add Features, problem with provided reader", (Throwable)e);
                }
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes(null));
                }
                catch (IllegalAttributeException writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), (Throwable)writeProblem);
                }
                writer.write();
                addedFids.add(newFeature.getID());
            }
        }
        finally {
            collection.close(iterator);
            writer.close();
        }
        return addedFids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatures(Filter filter) throws IOException {
        String typeName = this.getSchema().getTypeName();
        FeatureWriter writer = this.getDataStore().getFeatureWriter(typeName, filter, this.getTransaction());
        try {
            while (writer.hasNext()) {
                Feature feature = writer.next();
                writer.remove();
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeatures(FeatureReader reader) throws IOException {
        String typeName = this.getSchema().getTypeName();
        FeatureWriter writer = this.getDataStore().getFeatureWriter(typeName, this.getTransaction());
        try {
            Feature feature;
            while (writer.hasNext()) {
                feature = writer.next();
                LOGGER.finer("removing feature " + feature);
                writer.remove();
            }
            while (reader.hasNext()) {
                try {
                    feature = reader.next();
                }
                catch (Exception readProblem) {
                    throw new DataSourceException("Could not add Features, problem with provided reader", (Throwable)readProblem);
                }
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes(null));
                }
                catch (IllegalAttributeException writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), (Throwable)writeProblem);
                }
                LOGGER.finer("writing feature " + newFeature);
                writer.write();
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    public void setTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null, did you mean Transaction.AUTO_COMMIT?");
        }
        this.transaction = transaction;
    }
}

