/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.geotools.data.DataSourceException;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.index.Data;
import org.geotools.index.LockTimeoutException;
import org.geotools.index.TreeException;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemIndexStore;
import org.geotools.index.rtree.PageStore;
import org.geotools.index.rtree.RTree;
import org.geotools.index.rtree.fs.FileSystemPageStore;
import org.geotools.renderer.shape.ShapefileRenderer;

public class IndexInfo {
    static final byte TREE_NONE = 0;
    static final byte R_TREE = 1;
    static final byte QUAD_TREE = 2;
    final byte treeType;
    final URL treeURL;
    final URL shxURL;
    private RTree rtree;
    private QuadTree qtree;

    public IndexInfo(byte treeType, URL treeURL, URL shxURL) {
        this.treeType = treeType;
        this.treeURL = treeURL;
        this.shxURL = shxURL;
    }

    List queryRTree(Envelope bbox) throws DataSourceException, IOException {
        List goodRecs = null;
        try {
            if (this.rtree != null && !bbox.contains(this.rtree.getBounds())) {
                goodRecs = this.rtree.search(bbox);
            }
        }
        catch (LockTimeoutException le) {
            throw new DataSourceException("Error querying RTree", (Throwable)le);
        }
        catch (TreeException re) {
            throw new DataSourceException("Error querying RTree", (Throwable)re);
        }
        finally {
            try {
                this.rtree.close();
            }
            catch (Exception ee) {}
        }
        return goodRecs;
    }

    Collection queryQuadTree(Envelope bbox) throws DataSourceException, IOException, TreeException {
        Collection tmp = null;
        try {
            if (this.qtree != null && !bbox.contains(this.qtree.getRoot().getBounds()) && (tmp = this.qtree.search(bbox)) != null && !tmp.isEmpty()) {
                return tmp;
            }
            if (this.qtree != null) {
                this.qtree.close();
            }
        }
        catch (Exception e) {
            ShapefileRenderer.LOGGER.warning(e.getLocalizedMessage());
        }
        return null;
    }

    RTree openRTree() throws IOException {
        File file = new File(this.treeURL.getPath());
        RTree ret = null;
        try {
            FileSystemPageStore fps = new FileSystemPageStore(file);
            ret = new RTree((PageStore)fps);
        }
        catch (TreeException re) {
            throw new DataSourceException("Error opening RTree", (Throwable)re);
        }
        return ret;
    }

    QuadTree openQuadTree() throws StoreException {
        File file = new File(this.treeURL.getPath());
        FileSystemIndexStore store = new FileSystemIndexStore(file);
        try {
            return store.load(this.openIndexFile());
        }
        catch (IOException e) {
            throw new StoreException((Throwable)e);
        }
    }

    IndexFile openIndexFile() throws IOException {
        ReadableByteChannel rbc = this.getReadChannel(this.shxURL);
        if (rbc == null) {
            return null;
        }
        return new IndexFile(rbc, false);
    }

    private ReadableByteChannel getReadChannel(URL url) throws IOException {
        ReadableByteChannel channel = null;
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            if (!file.exists() || !file.canRead()) {
                throw new IOException("File either doesn't exist or is unreadable : " + file);
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = url.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    private Collection queryTree(Envelope bbox) throws IOException, TreeException {
        if (this.treeType == 1) {
            return this.queryRTree(bbox);
        }
        if (this.treeType == 2) {
            return this.queryQuadTree(bbox);
        }
        return null;
    }

    static class Reader
    implements RecordNumberTracker {
        private ShapefileReader shp;
        Iterator goodRecs;
        private int recno = 1;
        private Data next;
        private IndexInfo info;

        public Reader(IndexInfo info, ShapefileReader reader, Envelope bbox) throws IOException {
            this.shp = reader;
            try {
                if (info.treeType == 1) {
                    info.rtree = info.openRTree();
                } else if (info.treeType == 2) {
                    info.qtree = info.openQuadTree();
                }
                Collection queryTree = info.queryTree(bbox);
                if (queryTree != null) {
                    this.goodRecs = queryTree.iterator();
                }
            }
            catch (Exception e) {
                ShapefileRenderer.LOGGER.log(Level.FINE, "Exception occured attempting to use indexing:", e);
                this.goodRecs = null;
            }
            this.info = info;
        }

        public int getRecordNumber() {
            return this.recno;
        }

        public boolean hasNext() throws IOException {
            if (this.goodRecs != null) {
                if (this.next != null) {
                    return true;
                }
                if (this.goodRecs.hasNext()) {
                    this.next = (Data)this.goodRecs.next();
                    this.recno = (Integer)this.next.getValue(0);
                    return true;
                }
                return false;
            }
            return this.shp.hasNext();
        }

        public ShapefileReader.Record next() throws IOException {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("No more features in reader");
            }
            if (this.goodRecs != null) {
                Long l = (Long)this.next.getValue(1);
                ShapefileReader.Record record = this.shp.recordAt(l.intValue());
                this.next = null;
                return record;
            }
            ++this.recno;
            return this.shp.nextRecord();
        }

        public void close() throws IOException {
            this.shp.close();
            try {
                if (this.info.qtree != null) {
                    this.info.qtree.close(this.goodRecs);
                    this.info.qtree.close();
                }
            }
            catch (StoreException e) {
                e.printStackTrace();
            }
        }
    }
}

