/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.soilWater;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessLumpedSoilWater", author="Peter Krause", description="Calculates soil water balance for each HRU without vertical layers")
public class J2KProcessLayeredSoilWater
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute slope")
    public JAMSDouble slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="sealed grade")
    public JAMSDouble sealedGrade;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable net rain")
    public JAMSDouble netRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable net snow")
    public JAMSDouble netSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable potET")
    public JAMSDouble potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable actET")
    public JAMSDouble actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="snow depth")
    public JAMSDouble snowDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="daily snow melt")
    public JAMSDouble snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="horizons")
    public JAMSDouble horizons;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum MPS")
    public JAMSDoubleArray maxMPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum LPS")
    public JAMSDoubleArray maxLPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual MPS")
    public JAMSDoubleArray actMPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual LPS")
    public JAMSDoubleArray actLPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual depression storage")
    public JAMSDouble actDPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of MPS")
    public JAMSDoubleArray satMPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of LPS")
    public JAMSDoubleArray satLPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum MPS of soil")
    public JAMSDouble soilMaxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum LPS of soil")
    public JAMSDouble soilMaxLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual MPS of soil")
    public JAMSDouble soilActMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual LPS of soil")
    public JAMSDouble soilActLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of MPS of soil")
    public JAMSDouble soilSatMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of LPS of soil")
    public JAMSDouble soilSatLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of whole soil")
    public JAMSDouble satSoil;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar infiltration")
    public JAMSDouble infiltration;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar interflow")
    public JAMSDouble interflow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar percolation")
    public JAMSDouble percolation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD1 inflow")
    public JAMSDouble inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD1 outflow")
    public JAMSDouble outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD1 generation")
    public JAMSDouble genRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD2 inflow")
    public JAMSDoubleArray inRD2 = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD2 outflow")
    public JAMSDoubleArray outRD2 = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD2 generation")
    public JAMSDoubleArray genRD2 = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum depression storage [mm]")
    public JAMSDouble soilMaxDPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="poly reduction of ETP")
    public JAMSDouble soilPolRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="linear reduction of ETP")
    public JAMSDouble soilLinRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration rate in summer [mm/d]")
    public JAMSDouble soilMaxInfSummer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration rate in winter [mm/d]")
    public JAMSDouble soilMaxInfWinter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration rate on snow [mm/d]")
    public JAMSDouble soilMaxInfSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration part on sealed areas (gt 80%)")
    public JAMSDouble soilImpGT80;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration part on sealed areas (lt 80%)")
    public JAMSDouble soilImpLT80;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="MPS/LPS distribution coefficient for inflow")
    public JAMSDouble soilDistMPSLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="MPS/LPS diffusion coefficient")
    public JAMSDouble soilDiffMPSLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="LPS outflow coefficient")
    public JAMSDouble soilOutLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="LPS lateral-vertical distribution coefficient")
    public JAMSDouble soilLatVertLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum percolation rate [mm/d]")
    public JAMSDouble soilMaxPerc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="concentration coefficient for RD1")
    public JAMSDouble soilConcRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="concentration coefficient for RD2")
    public JAMSDouble soilConcRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="intfiltration poritions for the single horizonts")
    public JAMSDoubleArray infiltration_hor = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="percolation out of the single horizonts")
    public JAMSDoubleArray perco_hor = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="evapotranspiration out of the single horizonts")
    public JAMSDoubleArray actETP_h = new JAMSDoubleArray();
    double run_actDPS;
    double run_satSoil;
    double run_inRain;
    double run_inSnow;
    double run_snowMelt;
    double run_infiltration;
    double run_latComp;
    double run_vertComp;
    double run_overlandflow;
    double run_potETP;
    double run_actETP;
    double run_snowDepth;
    double run_area;
    double run_slope;
    double run_inRD1;
    double soilSatMps;
    double soilSatLps;
    double soilActMps;
    double soilActLps;
    double soilMaxMps;
    double soilMaxLps;
    double run_outRD1;
    double run_genRD1;
    double[] run_maxMPS;
    double[] run_maxLPS;
    double[] run_actMPS;
    double[] run_actLPS;
    double[] run_satMPS;
    double[] run_satLPS;
    double[] run_inRD2;
    double[] run_satHor;
    double[] run_outRD2;
    double[] run_genRD2;
    int nhor;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int h;
        double balMPSstart = 0.0;
        double balMPSend = 0.0;
        double balLPSstart = 0.0;
        double balLPSend = 0.0;
        double balDPSstart = 0.0;
        double balDPSend = 0.0;
        double balIn = 0.0;
        double balOut = 0.0;
        double balET = 0.0;
        this.run_area = this.area.getValue();
        this.run_slope = this.slope.getValue();
        this.nhor = (int)this.horizons.getValue();
        double[] infilhor = new double[this.nhor];
        double[] perchor = new double[this.nhor];
        double[] actETP_hor = new double[this.nhor];
        this.run_satHor = new double[this.nhor];
        this.run_maxMPS = this.maxMPS.getValue();
        this.run_maxLPS = this.maxLPS.getValue();
        this.run_actMPS = this.actMPS.getValue();
        this.run_actLPS = this.actLPS.getValue();
        this.run_satMPS = this.satMPS.getValue();
        this.run_satLPS = this.satLPS.getValue();
        this.run_actDPS = this.actDPS.getValue();
        this.run_inRD1 = this.inRD1.getValue();
        this.run_inRD2 = this.inRD2.getValue();
        balIn += this.run_inRD1;
        this.run_inRain = this.netRain.getValue();
        this.run_inSnow = this.netSnow.getValue();
        this.run_potETP = this.potET.getValue();
        this.run_actETP = this.actET.getValue();
        this.run_snowDepth = this.snowDepth.getValue();
        this.run_snowMelt = this.snowMelt.getValue();
        this.run_genRD2 = new double[this.nhor];
        this.run_outRD2 = new double[this.nhor];
        this.run_latComp = 0.0;
        this.run_vertComp = 0.0;
        this.run_genRD1 = 0.0;
        this.run_outRD1 = 0.0;
        balET = this.run_actETP;
        balDPSstart = this.run_actDPS;
        for (int h2 = 0; h2 < this.nhor; ++h2) {
            balIn += this.run_inRD2[h2];
            balMPSstart += this.run_actMPS[h2];
            balLPSstart += this.run_actLPS[h2];
            this.run_genRD2[h2] = 0.0;
            this.run_outRD2[h2] = 0.0;
        }
        this.calcSoilSaturations(false);
        this.redistRD1_RD2_in();
        this.calcPreInfEvaporation();
        this.run_infiltration = this.run_inRain + this.run_inSnow + this.run_snowMelt + this.run_actDPS;
        balIn += this.run_inRain;
        balIn += this.run_inSnow;
        balIn += this.run_snowMelt;
        this.run_actDPS = 0.0;
        this.run_inRain = 0.0;
        this.run_inSnow = 0.0;
        this.run_snowMelt = 0.0;
        this.calcInfImperv(this.sealedGrade.getValue());
        this.calcSoilSaturations(false);
        double maxInf = this.calcMaxInfiltration(this.time.get(2) + 1);
        if (maxInf < this.run_infiltration) {
            double deltaInf = this.run_infiltration - maxInf;
            this.run_actDPS += deltaInf;
            this.run_infiltration = maxInf;
        }
        for (h = 0; h < this.nhor; ++h) {
            double bak_infiltration = this.run_infiltration;
            this.run_infiltration = this.calcMPSInflow(this.run_infiltration, h);
            this.run_infiltration = this.calcLPSInflow(this.run_infiltration, h);
            infilhor[h] = bak_infiltration - this.run_infiltration;
        }
        if (this.run_infiltration > 0.0) {
            this.run_actDPS += this.run_infiltration;
            this.run_infiltration = 0.0;
        }
        for (h = 0; h < this.nhor; ++h) {
            this.run_vertComp = this.calcMPSInflow(this.run_vertComp, h);
            this.calcMPSTranspiration(false, h);
            actETP_hor[h] = this.run_actETP;
            this.run_vertComp = this.calcLPSInflow(this.run_vertComp, h);
            if (this.run_vertComp > 0.0) {
                this.run_vertComp = this.calcMPSInflow(this.run_vertComp, h - 1);
                this.run_vertComp = this.calcLPSInflow(this.run_vertComp, h - 1);
                if (this.run_vertComp > 0.0) {
                    this.getModel().getRuntime().println("VertIn is still not zero!");
                }
            }
            this.calcSoilSaturations(false);
            double MobileWater = 0.0;
            MobileWater = this.run_actLPS[h] > 0.0 ? this.calcLPSoutflow(h) : 0.0;
            this.calcIntfPercRates(MobileWater);
            perchor[h] = this.run_vertComp;
            this.calcRD2_out(h);
            this.calcDiffusion(h);
            this.calcSoilSaturations(false);
        }
        if (this.run_overlandflow < 0.0) {
            this.getModel().getRuntime().println("overlandflow is negative! --> " + this.run_overlandflow);
        }
        this.run_overlandflow += this.calcDirectRunoff();
        this.calcRD1_out();
        for (h = 0; h < this.nhor; ++h) {
            balMPSend += this.run_actMPS[h];
            balLPSend += this.run_actLPS[h];
            balOut += this.run_outRD2[h];
        }
        balDPSend = this.run_actDPS;
        balET = this.run_actETP - balET;
        balOut += balET;
        balOut += this.run_outRD1;
        double balance = balIn + (balMPSstart - balMPSend) + (balLPSstart - balLPSend) + (balDPSstart - balDPSend) - (balOut += this.run_vertComp);
        if (Math.abs(balance) > 1.0E-5) {
            this.getModel().getRuntime().println("balance error at : " + this.time.toString() + ", entity: " + this.entity.getDouble("ID") + " --> " + balance);
        }
        this.satMPS.setValue(this.run_satMPS);
        this.satLPS.setValue(this.run_satLPS);
        this.actMPS.setValue(this.run_actMPS);
        this.actLPS.setValue(this.run_actLPS);
        this.actDPS.setValue(this.run_actDPS);
        this.netRain.setValue(this.run_inRain);
        this.netSnow.setValue(this.run_inSnow);
        this.actET.setValue(this.run_actETP);
        this.inRD1.setValue(this.run_inRD1);
        this.inRD2.setValue(this.run_inRD2);
        this.outRD1.setValue(this.run_outRD1);
        this.outRD2.setValue(this.run_outRD2);
        this.genRD1.setValue(this.run_genRD1);
        this.genRD2.setValue(this.run_genRD2);
        this.percolation.setValue(this.run_vertComp);
        this.interflow.setValue(this.run_latComp);
        this.soilActMPS.setValue(this.soilActMps);
        this.soilMaxMPS.setValue(this.soilMaxMps);
        this.soilSatMPS.setValue(this.soilSatMps);
        this.soilActLPS.setValue(this.soilActLps);
        this.soilMaxLPS.setValue(this.soilMaxLps);
        this.soilSatLPS.setValue(this.soilSatLps);
        this.infiltration_hor.setValue(infilhor);
        this.perco_hor.setValue(perchor);
        this.actETP_h.setValue(actETP_hor);
    }

    public void cleanup() {
    }

    private boolean calcSoilSaturations(boolean debug) {
        this.soilMaxMps = 0.0;
        this.soilActMps = 0.0;
        this.soilMaxLps = 0.0;
        this.soilActLps = 0.0;
        this.soilSatMps = 0.0;
        this.soilSatLps = 0.0;
        for (int h = 0; h < this.nhor; ++h) {
            this.run_satLPS[h] = this.run_actLPS[h] > 0.0 && this.run_maxLPS[h] > 0.0 ? this.run_actLPS[h] / this.run_maxLPS[h] : 0.0;
            this.run_satMPS[h] = this.run_actMPS[h] > 0.0 && this.run_maxMPS[h] > 0.0 ? this.run_actMPS[h] / this.run_maxMPS[h] : 0.0;
            if ((this.run_maxLPS[h] > 0.0 | this.run_maxMPS[h] > 0.0) & (this.run_actLPS[h] > 0.0 | this.run_actMPS[h] > 0.0)) {
                this.run_satHor[h] = (this.run_actLPS[h] + this.run_actMPS[h]) / (this.run_maxLPS[h] + this.run_maxMPS[h]);
            } else {
                this.run_satSoil = 0.0;
            }
            this.soilMaxMps += this.run_maxMPS[h];
            this.soilActMps += this.run_actMPS[h];
            this.soilMaxLps += this.run_maxLPS[h];
            this.soilActLps += this.run_actLPS[h];
        }
        if ((this.soilMaxLps > 0.0 | this.soilMaxMps > 0.0) & (this.soilActLps > 0.0 | this.soilActMps > 0.0)) {
            this.run_satSoil = (this.soilActLps + this.soilActMps) / (this.soilMaxLps + this.soilMaxMps);
            this.soilSatMps = this.soilActMps / this.soilMaxMps;
            this.soilSatLps = this.soilActLps / this.soilMaxLps;
        } else {
            this.run_satSoil = 0.0;
        }
        return true;
    }

    private boolean redistRD1_RD2_in() throws JAMSEntity.NoSuchAttributeException {
        if (this.run_inRD1 > 0.0) {
            this.run_actDPS += this.run_inRD1;
            this.run_inRD1 = 0.0;
        }
        for (int h = 0; h < this.nhor; ++h) {
            if (!(this.run_inRD2[h] > 0.0)) continue;
            this.run_inRD2[h] = this.calcMPSInflow(this.run_inRD2[h], h);
            this.run_inRD2[h] = this.calcLPSInflow(this.run_inRD2[h], h);
            if (!(this.run_inRD2[h] > 0.0)) continue;
            this.run_outRD2[h] = this.run_outRD2[h] + this.run_inRD2[h];
            this.run_inRD2[h] = 0.0;
        }
        return true;
    }

    private boolean calcPreInfEvaporation() {
        double deltaETP = this.run_potETP - this.run_actETP;
        if (this.run_actDPS > 0.0) {
            if (this.run_actDPS >= deltaETP) {
                this.run_actDPS -= deltaETP;
                deltaETP = 0.0;
                this.run_actETP = this.run_potETP;
            } else {
                this.run_actDPS = 0.0;
                this.run_actETP = this.run_potETP - (deltaETP -= this.run_actDPS);
            }
        }
        return true;
    }

    private boolean calcInfImperv(double sealedGrade) {
        if (sealedGrade > 0.8) {
            this.run_overlandflow += (1.0 - this.soilImpGT80.getValue()) * this.run_infiltration;
            this.run_infiltration *= this.soilImpGT80.getValue();
        } else if (sealedGrade > 0.0 && sealedGrade <= 0.8) {
            this.run_overlandflow += (1.0 - this.soilImpLT80.getValue()) * this.run_infiltration;
            this.run_infiltration *= this.soilImpLT80.getValue();
        }
        if (this.run_overlandflow < 0.0) {
            this.getModel().getRuntime().println("overlandflow gets negative because of sealing! " + this.soilImpGT80.getValue() + ", " + this.soilImpLT80.getValue() + ", " + this.run_infiltration);
        }
        return true;
    }

    private double calcMaxInfiltration(int nowmonth, int horizon) {
        double maxInf = 0.0;
        this.calcSoilSaturations(false);
        maxInf = this.run_snowDepth > 0.0 ? this.soilMaxInfSnow.getValue() * this.run_area : (nowmonth >= 5 & nowmonth <= 10 ? (1.0 - this.run_satHor[horizon]) * this.soilMaxInfSummer.getValue() * this.run_area : (1.0 - this.run_satHor[horizon]) * this.soilMaxInfWinter.getValue() * this.run_area);
        return maxInf;
    }

    private double calcMaxInfiltration(int nowmonth) {
        double maxInf = 0.0;
        this.calcSoilSaturations(false);
        maxInf = this.run_snowDepth > 0.0 ? this.soilMaxInfSnow.getValue() * this.run_area : (nowmonth >= 5 & nowmonth <= 10 ? (1.0 - this.run_satSoil) * this.soilMaxInfSummer.getValue() * this.run_area : (1.0 - this.run_satSoil) * this.soilMaxInfWinter.getValue() * this.run_area);
        return maxInf;
    }

    private boolean calcMPSTranspiration(boolean debug, int hor) {
        double sat_factor;
        double reductionFactor;
        double maxTrans = 0.0;
        this.calcSoilSaturations(debug);
        double deltaETP = this.run_potETP - this.run_actETP;
        if (this.soilLinRed.getValue() > 0.0) {
            if (this.run_satMPS[hor] < this.soilLinRed.getValue()) {
                double reductionFactor2 = this.run_satMPS[hor] / this.soilLinRed.getValue();
                maxTrans = deltaETP * reductionFactor2;
            } else {
                maxTrans = deltaETP;
            }
        } else if (this.soilPolRed.getValue() > 0.0 && (maxTrans = deltaETP * (reductionFactor = Math.pow(10.0, sat_factor = -10.0 * Math.pow(1.0 - this.run_satMPS[hor], this.soilPolRed.getValue())))) > deltaETP) {
            maxTrans = deltaETP;
        }
        if (deltaETP > 0.0) {
            if (this.run_actMPS[hor] > maxTrans) {
                this.run_actMPS[hor] = this.run_actMPS[hor] - maxTrans;
                deltaETP -= maxTrans;
            } else {
                deltaETP -= this.run_actMPS[hor];
                this.run_actMPS[hor] = 0.0;
            }
        }
        this.run_actETP = this.run_potETP - deltaETP;
        this.calcSoilSaturations(debug);
        return true;
    }

    private double calcMPSInflow(double infiltration, int hor) {
        double inflow = infiltration;
        this.calcSoilSaturations(false);
        if (inflow < this.run_maxMPS[hor] - this.run_actMPS[hor]) {
            if (this.run_actMPS[hor] == 0.0) {
                this.run_actMPS[hor] = this.run_actMPS[hor] + inflow;
                inflow = 0.0;
            } else {
                double alpha = this.soilDistMPSLPS.getValue();
                if (this.run_satMPS[hor] == 0.0) {
                    this.run_satMPS[hor] = 1.0E-7;
                }
                double inMPS = inflow * (1.0 - Math.exp(-1.0 * alpha / this.run_satMPS[hor]));
                this.run_actMPS[hor] = this.run_actMPS[hor] + inMPS;
                inflow -= inMPS;
            }
        } else {
            double deltaMPS = this.run_maxMPS[hor] - this.run_actMPS[hor];
            this.run_actMPS[hor] = this.run_maxMPS[hor];
            inflow -= deltaMPS;
        }
        this.calcSoilSaturations(false);
        return inflow;
    }

    private double calcLPSInflow(double infiltration, int hor) {
        this.calcSoilSaturations(false);
        this.run_actLPS[hor] = this.run_actLPS[hor] + infiltration;
        infiltration = 0.0;
        if (this.run_actLPS[hor] > this.run_maxLPS[hor]) {
            infiltration = this.run_actLPS[hor] - this.run_maxLPS[hor];
            this.run_actLPS[hor] = this.run_maxLPS[hor];
        }
        this.calcSoilSaturations(false);
        return infiltration;
    }

    private double calcLPSoutflow(int hor) {
        double LPSoutflow;
        double potLPSoutflow;
        double alpha = this.soilOutLPS.getValue();
        if (this.run_satLPS[hor] == 1.0) {
            this.run_satLPS[hor] = 0.999999;
        }
        if ((potLPSoutflow = Math.pow(this.run_satHor[hor], alpha) * this.run_actLPS[hor]) > this.run_actLPS[hor]) {
            potLPSoutflow = this.run_actLPS[hor];
        }
        if ((LPSoutflow = potLPSoutflow) > this.run_actLPS[hor]) {
            LPSoutflow = this.run_actLPS[hor];
        }
        this.run_actLPS[hor] = this.run_actLPS[hor] - LPSoutflow;
        return LPSoutflow;
    }

    private boolean calcIntfPercRates(double MobileWater) {
        if (MobileWater > 0.0) {
            double slope_weight = Math.tan(this.run_slope * (Math.PI / 180)) * this.soilLatVertLPS.getValue();
            double part_perc = 1.0 - slope_weight;
            if (part_perc > 1.0) {
                part_perc = 1.0;
            } else if (part_perc < 0.0) {
                part_perc = 0.0;
            }
            double part_intf = 1.0 - part_perc;
            this.run_latComp += MobileWater * part_intf;
            this.run_vertComp += MobileWater * part_perc;
            double maxPerc = this.soilMaxPerc.getValue() * this.run_area;
            if (this.run_vertComp > maxPerc) {
                double rest = this.run_vertComp - maxPerc;
                this.run_vertComp = maxPerc;
                this.run_latComp += rest;
            }
        } else {
            this.run_latComp = 0.0;
            this.run_vertComp = 0.0;
        }
        return true;
    }

    private double calcDirectRunoff() {
        double directRunoff = 0.0;
        if (this.run_actDPS > 0.0) {
            double maxDep = 0.0;
            maxDep = this.run_slope > 5.0 ? this.soilMaxDPS.getValue() * this.run_area / 2.0 : this.soilMaxDPS.getValue() * this.run_area;
            if (this.run_actDPS > maxDep) {
                directRunoff = this.run_actDPS - maxDep;
                this.run_actDPS = maxDep;
            }
        }
        if (directRunoff < 0.0) {
            this.getModel().getRuntime().println("directRunoff is negative! --> " + directRunoff);
        }
        return directRunoff;
    }

    private boolean calcRD2_out(int h) {
        double RD2_output_factor = 1.0 / this.soilConcRD2.getValue();
        if (RD2_output_factor > 1.0) {
            RD2_output_factor = 1.0;
        } else if (RD2_output_factor < 0.0) {
            RD2_output_factor = 0.0;
        }
        double RD2_output = this.run_latComp * RD2_output_factor;
        this.run_actLPS[h] = this.run_actLPS[h] + (this.run_latComp - RD2_output);
        this.run_outRD2[h] = this.run_outRD2[h] + RD2_output;
        this.run_genRD2[h] = this.run_outRD2[h];
        if (this.run_genRD2[h] < 0.0) {
            this.run_genRD2[h] = 0.0;
        }
        this.run_latComp = 0.0;
        return true;
    }

    private boolean calcRD1_out() {
        double RD1_output_factor = 1.0 / this.soilConcRD1.getValue();
        if (RD1_output_factor > 1.0) {
            RD1_output_factor = 1.0;
        } else if (RD1_output_factor < 0.0) {
            RD1_output_factor = 0.0;
        }
        double RD1_output = this.run_overlandflow * RD1_output_factor;
        this.run_actDPS += this.run_overlandflow - RD1_output;
        this.run_outRD1 += RD1_output;
        this.run_genRD1 = this.run_outRD1;
        this.run_overlandflow = 0.0;
        return true;
    }

    private boolean calcDiffusion(int h) {
        double diffusion = 0.0;
        this.calcSoilSaturations(false);
        double deltaMPS = this.run_maxMPS[h] - this.run_actMPS[h];
        if (this.run_satMPS[h] == 0.0) {
            diffusion = 0.0;
        } else {
            double diff = this.soilDiffMPSLPS.getValue();
            diffusion = this.run_actLPS[h] * (1.0 - Math.exp(-1.0 * diff / this.run_satMPS[h]));
        }
        if (diffusion > this.run_actLPS[h]) {
            diffusion = this.run_actLPS[h];
        }
        if (diffusion < deltaMPS) {
            this.run_actMPS[h] = this.run_actMPS[h] + diffusion;
            this.run_actLPS[h] = this.run_actLPS[h] - diffusion;
        } else {
            double rest = this.run_maxMPS[h] - this.run_actMPS[h];
            this.run_actMPS[h] = this.run_maxMPS[h];
            this.run_actLPS[h] = this.run_actLPS[h] - rest;
        }
        return true;
    }
}

