/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.HourlySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcAdditionalHRUAttribs", author="Peter Krause", description="Calculates additional attributes from existent ones")
public class CalcExtraterrRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity latidute [deg]")
    public JAMSDouble latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity longitude [deg]")
    public JAMSDouble longitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="longitude of time zone [deg]")
    public JAMSDouble longTZ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="temporal resolution [d | h | m]")
    public JAMSString tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="location from Greenwich [w | e]")
    public JAMSString locGrw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="extraterrestric radiation of each time step of the year [MJ/m\u00b2 timeUnit]")
    public JAMSDoubleArray extRadArray = new JAMSDoubleArray();
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double[] extRadiation = null;
        if (this.tempRes.getValue().equals("d")) {
            extRadiation = new double[366];
        } else if (this.tempRes.getValue().equals("h")) {
            extRadiation = new double[8784];
        } else if (this.tempRes.getValue().equals("m")) {
            extRadiation = new double[12];
        }
        double lati = this.latitude.getValue();
        double longi = this.longitude.getValue();
        double longiTZ = this.longTZ.getValue();
        if (this.locGrw.getValue().equals("e")) {
            longi = 360.0 - longi;
            longiTZ = 360.0 - longiTZ;
        }
        double latRad = MathematicalCalculations.deg2rad(lati);
        JAMSCalendar time = new JAMSCalendar();
        time.set(2000, 1, 1, 0, 0);
        if (this.tempRes.getValue().equals("m")) {
            for (int i = 0; i < 12; ++i) {
                double declination = SolarRadiationCalculationMethods.calc_SunDeclination(this.monthMean[i]);
                double solarConstant = SolarRadiationCalculationMethods.calc_SolarConstant(this.monthMean[i]);
                double invRelDistEarthSun = SolarRadiationCalculationMethods.calc_InverseRelativeDistanceEarthSun(this.monthMean[i]);
                double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
                extRadiation[i] = DailySolarRadiationCalculationMethods.calc_DailyExtraterrestrialRadiation(solarConstant, invRelDistEarthSun, sunsetHourAngle, latRad, declination);
            }
        } else {
            for (int i = 0; i < 366; ++i) {
                int julDay = i + 1;
                double declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
                double solarConstant = SolarRadiationCalculationMethods.calc_SolarConstant(julDay);
                double invRelDistEarthSun = SolarRadiationCalculationMethods.calc_InverseRelativeDistanceEarthSun(julDay);
                if (this.tempRes.getValue().equals("d")) {
                    double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
                    extRadiation[i] = DailySolarRadiationCalculationMethods.calc_DailyExtraterrestrialRadiation(solarConstant, invRelDistEarthSun, sunsetHourAngle, latRad, declination);
                    time.add(5, 1);
                    continue;
                }
                if (!this.tempRes.getValue().equals("h")) continue;
                for (int hour = 0; hour < 24; ++hour) {
                    double midTimeHourAngle = HourlySolarRadiationCalculationMethods.calc_midTimeHourAngle(time, julDay, longi, longiTZ, false);
                    double startTimeHourAngle = HourlySolarRadiationCalculationMethods.calc_startTimeHourAngle(midTimeHourAngle);
                    double endTimeHourAngle = HourlySolarRadiationCalculationMethods.calc_endTimeHourAngle(midTimeHourAngle);
                    int idx = i * 24 + hour;
                    extRadiation[idx] = HourlySolarRadiationCalculationMethods.calc_HourlyExtraterrestrialRadiation(solarConstant, invRelDistEarthSun, startTimeHourAngle, endTimeHourAngle, latRad, declination);
                    time.add(11, 1);
                }
            }
        }
        this.extRadArray.setValue(extRadiation);
    }

    public void cleanup() {
    }
}

