/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.PrintWriter;
import java.util.Arrays;
import org.geotools.factory.Hints;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.resources.Arguments;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationNotFoundException;

final class Console {
    private static final Hints HINTS = null;

    Console() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintWriter out;
        block12: {
            Arguments arguments = new Arguments(args);
            boolean printMT = arguments.getFlag("-transform");
            args = arguments.getRemainingArguments(Integer.MAX_VALUE);
            out = arguments.out;
            char[] separator = new char[79];
            Arrays.fill(separator, '_');
            int count = 0;
            CoordinateReferenceSystem[] crs = new CoordinateReferenceSystem[args.length];
            try {
                CRSAuthorityFactory factory = null;
                try {
                    for (int i = 0; i < args.length; ++i) {
                        if (factory == null && (factory = FactoryFinder.getCRSAuthorityFactory("EPSG", HINTS)) instanceof AbstractAuthorityFactory) {
                            out.println(((AbstractAuthorityFactory)((Object)factory)).getBackingStoreDescription());
                        }
                        IdentifiedObject object = factory.createObject(args[i]);
                        out.println(separator);
                        out.println();
                        out.println(object);
                        if (!(object instanceof CoordinateReferenceSystem)) continue;
                        crs[count++] = (CoordinateReferenceSystem)object;
                    }
                    if (!printMT) break block12;
                    CoordinateOperationFactory opFactory = FactoryFinder.getCoordinateOperationFactory(HINTS);
                    for (int i = 0; i < count; ++i) {
                        for (int j = i + 1; j < count; ++j) {
                            CoordinateOperation op;
                            out.println(separator);
                            out.println();
                            try {
                                op = opFactory.createOperation(crs[i], crs[j]);
                            }
                            catch (OperationNotFoundException exception) {
                                out.println(exception.getLocalizedMessage());
                                continue;
                            }
                            out.println(op);
                            out.println();
                            out.println(op.getMathTransform());
                        }
                    }
                }
                finally {
                    if (factory instanceof AbstractAuthorityFactory) {
                        ((AbstractAuthorityFactory)((Object)factory)).dispose();
                    }
                }
            }
            catch (Exception exception) {
                out.flush();
                exception.printStackTrace(arguments.err);
                return;
            }
        }
        out.flush();
    }
}

