/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet.kernels;

import org.unijena.predictionnet.kernels.Kernel;

public class MaternClass
extends Kernel {
    public MaternClass(int inputDim) {
        this.inputDim = inputDim;
        this.parameterCount = inputDim + 1;
        this.KernelParameterCount = inputDim + 1;
    }

    public double SqrDistance2(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double tmp = (x[i] - y[i]) / this.theta[i];
            sum += tmp * tmp;
        }
        return sum;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        double r = Math.sqrt(this.SqrDistance2(x, y));
        double noise = 0.0;
        if (index1 == index2) {
            noise = this.theta[this.KernelParameterCount - 1] * this.theta[this.KernelParameterCount - 1];
        }
        return (1.0 + 1.732 * r / this.theta[0]) * Math.exp(-1.732 * r / this.theta[0]);
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        if (d >= this.inputDim) {
            return 0.0;
        }
        double r = this.SqrDistance2(x, y);
        double dr = (x[d] - y[d]) / this.theta[d];
        return dr * dr * Math.exp(-0.5 * r) / this.theta[d];
    }
}

