/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet;

import java.util.HashSet;
import java.util.Random;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

public class SubsetSelect
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger n;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity InputData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity OutputData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSBoolean active;

    public void init() {
    }

    public void run() {
        int i;
        int j;
        double[][] data = null;
        double[] predict = null;
        HashSet<Double> HashFilter = new HashSet<Double>();
        try {
            data = (double[][])this.InputData.getObject("data");
            predict = (double[])this.InputData.getObject("predict");
        }
        catch (Exception e) {
            System.out.println("Konnte InputData nicht finden" + e.toString());
        }
        if (!this.active.getValue()) {
            this.OutputData.setObject("data", (Object)data);
            this.OutputData.setObject("predict", (Object)predict);
            return;
        }
        System.out.println("Optimiere Trainingsdaten!");
        int Ngoal = this.n.getValue();
        int N0 = data.length;
        int M = data[0].length;
        int[] set = new int[Ngoal];
        double[] variance = new double[N0];
        double[] hash_value = new double[N0];
        boolean[] inSet = new boolean[N0];
        for (int j2 = 0; j2 < N0; ++j2) {
            variance[j2] = 0.0;
            inSet[j2] = false;
            hash_value[j2] = 0.0;
            for (int k = 0; k < M; ++k) {
                int n = j2;
                hash_value[n] = hash_value[n] + data[j2][k];
            }
        }
        inSet[0] = true;
        set[0] = 0;
        for (int i2 = 1; i2 < Ngoal; ++i2) {
            int bestIndex = -1;
            double bestValue = -1.0;
            for (j = 0; j < N0; ++j) {
                if (inSet[j]) continue;
                for (int l = 0; l < M; ++l) {
                    int n = j;
                    variance[n] = variance[n] + (data[j][l] - data[set[i2 - 1]][l]) * (data[j][l] - data[set[i2 - 1]][l]);
                }
                if (!(variance[j] > bestValue)) continue;
                bestValue = variance[j];
                bestIndex = j;
            }
            if (bestValue == -1.0) {
                System.out.println("No enough data!!");
            }
            inSet[bestIndex] = true;
            HashFilter.add(new Double(hash_value[bestIndex]));
            set[i2] = bestIndex;
            for (int k = 1; k < N0; ++k) {
                if (!(Math.abs(hash_value[k] - hash_value[bestIndex]) < 1.0E-7)) continue;
                inSet[k] = true;
            }
        }
        double[][] optimizedata = new double[Ngoal][];
        double[] optimizepredict = new double[Ngoal];
        Random r = new Random();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < Ngoal; ++j) {
                int Shuffle = r.nextInt(Ngoal);
                int tmp = set[j];
                set[j] = set[Shuffle];
                set[Shuffle] = tmp;
            }
        }
        for (i = 0; i < Ngoal; ++i) {
            optimizedata[i] = data[set[i]];
            optimizepredict[i] = predict[set[i]];
        }
        this.OutputData.setObject("data", (Object)optimizedata);
        this.OutputData.setObject("predict", (Object)optimizepredict);
        System.out.println("Fertig!");
    }
}

