/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet;

import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

public class SplitValidation
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger trainingStart;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger trainingEnd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger validationStart;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger validationEnd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity Data;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity trainingData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity validationData;

    public void init() {
    }

    private void singleRun() {
        JAMSComponent comp;
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public void run() {
        double[][] data = null;
        double[] predict = null;
        try {
            data = (double[][])this.Data.getObject("data");
            predict = (double[])this.Data.getObject("predict");
        }
        catch (Exception e) {
            System.out.println("Konnte Daten nicht finden!!" + e.toString());
        }
        System.out.println("Split Validation");
        double[][] valData = new double[this.validationEnd.getValue() - this.validationStart.getValue()][];
        double[] valPredict = new double[this.validationEnd.getValue() - this.validationStart.getValue()];
        double[][] trainData = new double[this.trainingEnd.getValue() - this.trainingStart.getValue()][];
        double[] trainPredict = new double[this.trainingEnd.getValue() - this.trainingStart.getValue()];
        for (int j = 0; j < data.length; ++j) {
            if (j >= this.validationStart.getValue() && j < this.validationEnd.getValue()) {
                valData[j - this.validationStart.getValue()] = data[j];
                valPredict[j - this.validationStart.getValue()] = predict[j];
            }
            if (j < this.trainingStart.getValue() || j >= this.trainingEnd.getValue()) continue;
            trainData[j - this.trainingStart.getValue()] = data[j];
            trainPredict[j - this.trainingStart.getValue()] = predict[j];
        }
        this.trainingData.setObject("data", (Object)trainData);
        this.trainingData.setObject("predict", (Object)trainPredict);
        this.validationData.setObject("data", (Object)valData);
        this.validationData.setObject("predict", (Object)valPredict);
        this.singleRun();
    }
}

