/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet;

import Jama.Matrix;
import org.unijena.predictionnet.Learner;

public class LinearRegression
extends Learner {
    public double InterpolationSize = 0.1;
    public int KernelMethod = 1;
    int ApproxSize = 0;
    Matrix WeightTable = null;
    int[] InterpolationPoints;

    public double Distance2(double[] x, double[] y) {
        if (x.length != y.length) {
            System.out.println("Distance -> x length != y length");
            return Double.NaN;
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += (x[i] - y[i]) * (x[i] - y[i]);
        }
        return Math.sqrt(sum);
    }

    public double KernelValue(double r) {
        if (r == 0.0) {
            return 0.0;
        }
        return r * r - r;
    }

    @Override
    public void setTrainingData(double[][] data, double[] result) {
        super.setTrainingData(data, result);
        this.ApproxSize = (int)((double)this.TrainLength * this.InterpolationSize);
    }

    public void Train() {
        int i;
        Matrix W = new Matrix(this.TrainLength, this.ApproxSize);
        Matrix F = new Matrix(this.TrainLength, 1);
        this.InterpolationPoints = new int[this.ApproxSize];
        for (i = 0; i < this.ApproxSize; ++i) {
            boolean allreadyIn = true;
            int rndPoint = 0;
            block1: while (allreadyIn) {
                rndPoint = this.generator.nextInt(this.TrainLength);
                allreadyIn = false;
                for (int j = 0; j < i; ++j) {
                    if (this.InterpolationPoints[j] != rndPoint) continue;
                    allreadyIn = true;
                    continue block1;
                }
            }
            this.InterpolationPoints[i] = rndPoint;
        }
        for (i = 0; i < this.TrainLength; ++i) {
            for (int j = 0; j < this.ApproxSize; ++j) {
                W.set(i, j, this.KernelValue(this.Distance2(this.data[i], this.data[this.InterpolationPoints[j]])));
            }
            F.set(i, 0, this.result[i]);
        }
        Matrix F2 = W;
        F2 = F2.transpose();
        F2 = F2.times(F);
        Matrix W2 = W;
        W2 = W2.transpose();
        W2 = W2.times(W);
        this.WeightTable = W2.solve(F2);
        System.out.println("matrix 2 norm:" + W.times(this.WeightTable).minus(F).norm1());
    }

    public double Predict(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < this.ApproxSize; ++i) {
            sum += this.WeightTable.get(i, 0) * this.KernelValue(this.Distance2(x, this.data[this.InterpolationPoints[i]]));
        }
        return sum;
    }

    public LinearRegression() {
        this.generator.setSeed(1L);
    }
}

