/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import org.unijena.hydronet.DistNeuron;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="HydroNETControl", author="Christian Fischer", description="Context Component which controls optimization")
public class HydroNETControl
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Nitrongen Output Neuron")
    public JAMSEntity NitrogenOutEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Cost Output Neuron")
    public JAMSEntity CostOutEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="smallest improvement which is accepted")
    public JAMSDouble delta_min;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="learning rate")
    public JAMSDouble learningrate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="momentum")
    public JAMSDouble momentum = new JAMSDouble(0.9);
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="largest accepted nitrogen value")
    public JAMSDouble nitrogen_goal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="largest accepted nitrogen value")
    public JAMSDouble current_output;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="largest accepted nitrogen value")
    public JAMSDouble current_cost;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="largest accepted nitrogen value")
    public JAMSDouble current_sum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="largest accepted nitrogen value")
    public JAMSDouble current_iteration;
    private double errorNO;
    private double errorCost;
    private double avgperformance = 1000.0;
    private double performance;
    private double minError = 1.0E15;
    private double lasterror;
    private int iteration;
    private int breakcount = 550;

    public boolean hasNext() throws JAMSEntity.NoSuchAttributeException {
        DistNeuron NitrogenOutNeuron = (DistNeuron)this.NitrogenOutEntity.getObject("NEURON");
        DistNeuron CostOutNeuron = (DistNeuron)this.CostOutEntity.getObject("NEURON");
        this.errorNO = NitrogenOutNeuron.getActivation() - this.nitrogen_goal.getValue();
        double outbefore = NitrogenOutNeuron.getActivation();
        this.errorCost = CostOutNeuron.getActivation();
        if (this.iteration <= 2) {
            this.lasterror = Math.abs(this.errorNO) + Math.abs(this.errorCost);
            return true;
        }
        if (Math.abs(this.errorNO) + Math.abs(this.errorCost) < this.minError) {
            this.minError = Math.abs(this.errorNO) + Math.abs(this.errorCost);
        }
        this.performance = this.lasterror - (Math.abs(this.errorNO) + Math.abs(this.errorCost));
        this.avgperformance = 0.9 * this.avgperformance + 0.1 * this.performance;
        if (Math.abs(this.errorNO + this.errorCost) > Math.abs(this.minError)) {
            --this.breakcount;
        } else {
            this.minError = this.errorNO + this.errorCost;
            if (this.performance < this.delta_min.getValue()) {
                this.learningrate.setValue(this.learningrate.getValue() * 1.035);
            } else {
                this.breakcount = 200;
            }
        }
        this.lasterror = Math.abs(this.errorNO) + Math.abs(this.errorCost);
        DistNeuron.eta = this.learningrate.getValue();
        System.out.println("Output before learning : " + outbefore + " NO - Output : " + new Double(NitrogenOutNeuron.getActivation()).toString() + "\t" + "  Cost - Output : " + new Double(CostOutNeuron.getActivation()).toString() + "  Summe - Output : " + "  AvgPerf : " + new Double(this.avgperformance).toString());
        this.current_output.setValue(NitrogenOutNeuron.getActivation());
        this.current_cost.setValue(CostOutNeuron.getActivation());
        this.current_sum.setValue(NitrogenOutNeuron.getActivation() + CostOutNeuron.getActivation());
        this.current_iteration.setValue((double)this.iteration);
        NitrogenOutNeuron.setActivation(this.current_output.getValue() - this.nitrogen_goal.getValue());
        return this.breakcount >= 0 && this.avgperformance >= this.delta_min.getValue();
    }

    public void init() {
        this.iteration = 0;
        DistNeuron.alpha = this.momentum.getValue();
        DistNeuron.eta = this.learningrate.getValue();
        if (this.runEnumerator == null) {
            this.runEnumerator = super.getChildrenEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            JAMSComponent comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception exception) {}
        }
    }

    public void singleRun() {
        if (this.runEnumerator == null) {
            this.runEnumerator = super.getChildrenEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            JAMSComponent comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception exception) {}
        }
    }

    public void run() {
        try {
            while (this.hasNext()) {
                this.singleRun();
                ++this.iteration;
            }
            for (int i = this.hrus.getEntities().size() - 1; i >= 0; --i) {
                JAMSEntity e = (JAMSEntity)this.hrus.getEntities().get(i);
                DistNeuron d = (DistNeuron)e.getObject("DIST_NEURON");
                if (d.getInitalExternInput() != 0.0) {
                    e.setDouble("reduction", d.getInput() / d.getInitalExternInput());
                } else {
                    e.setDouble("reduction", 0.0);
                }
                e.setDouble("new_input", ((DistNeuron)e.getObject("DIST_NEURON")).getInput());
            }
        }
        catch (JAMSEntity.NoSuchAttributeException e) {
            this.getModel().getRuntime().sendInfoMsg("No such attribute Exception: " + e.getMessage());
        }
    }

    public void cleanup() {
        if (this.runEnumerator == null) {
            this.runEnumerator = super.getChildrenEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            JAMSComponent comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception exception) {}
        }
    }
}

