/*
 * Decompiled with CFR 0.152.
 */
package jams.components.optimizer;

import jams.components.optimizer.nn.InputNeuron;
import jams.components.optimizer.nn.Neuron;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.unijena.jams.JAMS;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDataFactory;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.predictionnet.GaussianLearner;

@JAMSComponentDescription(title="NNOptimizer", author="Christian Fischer", description="under construction!!")
public class NNOptimizer
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter identifiers to be sampled")
    public JAMSString parameterIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter value bounaries corresponding to parameter identifiers")
    public JAMSString boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="objective function name")
    public JAMSString effMethodName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the prediction series")
    public JAMSDouble effValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="optimization mode")
    public JAMSInteger mode;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="maximum runs")
    public JAMSInteger maxn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Flag for enabling/disabling this sampler")
    public JAMSBoolean enable;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString outputFileName;
    JAMSDouble[] parameters;
    String[] parameterNames;
    double[] lowBound;
    double[] upBound;
    int n;
    int currentSampleCount;
    int SamplesPerIteration = 60;
    Random generator = new Random();
    GenericDataWriter writer;
    static final int MODE_MAXIMIZATION = 1;
    static final int MODE_MINIMIZATION = 2;
    static final int MODE_ABSMAXIMIZATION = 3;
    static final int MODE_ABSMINIMIZATION = 4;
    int LayerCount = 4;
    Vector<Neuron>[] Layer = new Vector[this.LayerCount];
    int[] LayerSize = new int[this.LayerCount];
    Vector<double[]> TrainData = new Vector();
    Neuron outNeuron = null;
    Neuron rootNeuron = null;
    Vector<SubSpace> WSpaces = new Vector();
    int NodeCounter = 0;
    int ProbCounter = 0;

    public void init() {
        int k;
        String key;
        StringTokenizer tok = new StringTokenizer(this.parameterIDs.getValue(), ";");
        this.parameters = new JAMSDouble[tok.countTokens()];
        this.parameterNames = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.parameterNames[i] = key = tok.nextToken();
            this.parameters[i] = (JAMSDouble)this.getModel().getRuntime().getDataHandles().get(key);
            ++i;
        }
        tok = new StringTokenizer(this.boundaries.getValue(), ";");
        int n = tok.countTokens();
        this.lowBound = new double[n];
        this.upBound = new double[n];
        if (n != i) {
            this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": Different number of parameterIDs and boundaries!");
        }
        i = 0;
        while (tok.hasMoreTokens()) {
            key = tok.nextToken();
            key = key.substring(1, key.length() - 1);
            StringTokenizer boundTok = new StringTokenizer(key, ">");
            this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
            this.upBound[i] = Double.parseDouble(boundTok.nextToken());
            if (this.upBound[i] <= this.lowBound[i]) {
                this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
            }
            ++i;
        }
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.outputFileName.getValue());
        this.writer.addComment("SCE output");
        for (int p = 0; p < this.parameterNames.length; ++p) {
            this.writer.addColumn(this.parameterNames[p]);
        }
        this.writer.addColumn(this.effMethodName.getValue());
        this.writer.writeHeader();
        this.writer.flush();
        n = this.parameters.length;
        this.currentSampleCount = 0;
        this.generator.setSeed(1L);
        this.rootNeuron = new InputNeuron();
        this.Layer[0] = new Vector();
        this.Layer[1] = new Vector();
        this.Layer[2] = new Vector();
        this.Layer[3] = new Vector();
        this.Layer[0].add(this.rootNeuron);
        for (int k2 = 0; k2 < n; ++k2) {
            Neuron parameterNeuron = new Neuron();
            this.Layer[1].add(parameterNeuron);
            this.rootNeuron.AddConnection(parameterNeuron, this.generator.nextDouble() - 0.5);
        }
        int h1Size = 20;
        for (k = 0; k < h1Size; ++k) {
            Neuron hiddenNeuron = new Neuron(true);
            this.Layer[2].add(hiddenNeuron);
            for (int r = 0; r < n; ++r) {
                this.Layer[1].get(r).AddConnection(hiddenNeuron, this.generator.nextDouble() - 0.5);
            }
        }
        this.outNeuron = new Neuron();
        for (k = 0; k < h1Size; ++k) {
            this.Layer[2].get(k).AddConnection(this.outNeuron, this.generator.nextDouble() - 0.5);
        }
        this.Layer[3].add(this.outNeuron);
    }

    private void ResetNet() {
        for (int k = 0; k < this.n; ++k) {
            this.rootNeuron.getConnection((int)k).Weight = this.generator.nextDouble() - 0.5;
            this.Layer[2].get((int)k).getConnection((int)0).Weight = this.generator.nextDouble() - 0.5;
            for (int r = 0; r < this.Layer[2].size(); ++r) {
                this.Layer[1].get((int)k).getConnection((int)r).Weight = this.generator.nextDouble() - 0.5;
            }
        }
    }

    private double[] RandomSampler() {
        int paras = this.parameterNames.length;
        double[] sample = new double[paras];
        for (int i = 0; i < paras; ++i) {
            double d = this.generator.nextDouble();
            sample[i] = this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]);
        }
        return sample;
    }

    public double funct(double[] x) {
        double value = 0.0;
        for (int j = 0; j < this.parameters.length; ++j) {
            this.parameters[j].setValue(x[j]);
        }
        this.singleRun();
        return Math.log(-this.effValue.getValue() + 1.0);
    }

    private void singleRun() {
        JAMSComponent comp;
        ++this.currentSampleCount;
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void collectSamples() {
        for (int i = 0; i < this.SamplesPerIteration; ++i) {
            double[] parameter = this.RandomSampler();
            double result = this.funct(parameter);
            if (result < -10.0) {
                result = -10.0;
            }
            if (result > 10.0) {
                result = 10.0;
            }
            double[] sample = new double[parameter.length + 1];
            for (int k = 0; k < parameter.length; ++k) {
                sample[k] = parameter[k];
            }
            sample[sample.length - 1] = result;
            this.TrainData.add(sample);
        }
    }

    public double Propagate() {
        for (int k = 0; k < this.LayerCount; ++k) {
            for (int i = 0; i < this.Layer[k].size(); ++i) {
                this.Layer[k].get(i).propagate();
            }
        }
        return this.outNeuron.getActivation();
    }

    public void BackPropagate(double error) {
        this.outNeuron.addToError(error);
        for (int k = this.LayerCount - 1; k >= 0; --k) {
            for (int i = 0; i < this.Layer[k].size(); ++i) {
                this.Layer[k].get(i).backpropagate();
                this.Layer[k].get(i).updateWeightDelta();
            }
        }
    }

    public void AdjustWeights() {
        for (int k = 1; k < this.LayerCount; ++k) {
            for (int i = 0; i < this.Layer[k].size(); ++i) {
                this.Layer[k].get(i).adjustWeight();
            }
        }
    }

    public double Predict(double[] input) {
        this.rootNeuron.reset();
        this.rootNeuron.addToInput(1.0);
        for (int i = 0; i < input.length; ++i) {
            this.rootNeuron.getConnection(i).setLock(true);
            this.rootNeuron.getConnection((int)i).Weight = input[i];
        }
        return this.Propagate();
    }

    public double Cycle(double[][] TrainingSet, boolean train) {
        int p;
        double accError = 0.0;
        double[] parameter = new double[this.n];
        double mean = 0.0;
        double normalizer = 0.0;
        for (p = 0; p < TrainingSet.length; ++p) {
            mean += TrainingSet[p][this.n];
        }
        mean /= (double)TrainingSet.length;
        for (p = 0; p < TrainingSet.length; ++p) {
            for (int r = 0; r < this.n; ++r) {
                parameter[r] = 2.0 * (TrainingSet[p][r] - this.lowBound[r]) / (this.upBound[r] - this.lowBound[r]) - 1.0;
            }
            double predValue = this.Predict(parameter);
            double correctValue = TrainingSet[p][this.n];
            accError += (correctValue - predValue) * (correctValue - predValue);
            normalizer += (correctValue - mean) * (correctValue - mean);
            if (!train) continue;
            this.BackPropagate(correctValue - predValue);
        }
        if (train) {
            this.AdjustWeights();
        }
        return 1.0 - accError / normalizer;
    }

    private double Train(double[][] TrainingSet, double[][] ValidationSet) {
        double TrainingEff = Double.NEGATIVE_INFINITY;
        double oldTrainEff = 0.0;
        double ValidationEff = 0.0;
        double meanValidationEff_older = 0.0;
        double meanValidationEff_newer = 0.0;
        double meanTrainImprovement = 1.0;
        Vector<Double> ValidationEffHistory = new Vector<Double>();
        boolean ValidationImprovement = true;
        Neuron.learningRate = 0.001;
        int cycle = 0;
        this.ResetNet();
        while ((TrainingEff < 0.7 || ValidationImprovement || cycle <= 10) && meanTrainImprovement > 1.0E-7) {
            TrainingEff = this.Cycle(TrainingSet, true);
            ValidationEff = this.Cycle(ValidationSet, false);
            if (oldTrainEff == 0.0) {
                oldTrainEff = TrainingEff;
            }
            ValidationEffHistory.add(ValidationEff);
            meanValidationEff_older = 0.1 * ValidationEff + 0.9 * meanValidationEff_older;
            meanValidationEff_newer = 0.2 * ValidationEff + 0.8 * meanValidationEff_newer;
            meanTrainImprovement = 0.001 * (TrainingEff - oldTrainEff) + 0.999 * meanTrainImprovement;
            ValidationImprovement = meanValidationEff_newer > meanValidationEff_older;
            System.out.println("Cycle:" + ++cycle + "\tTrainEff:" + TrainingEff + "\tValidationEff:" + ValidationEff + "\timpr:" + meanTrainImprovement);
            Neuron.learningRate = oldTrainEff > TrainingEff ? (Neuron.learningRate *= 0.99) : (Neuron.learningRate /= 0.999);
            oldTrainEff = TrainingEff;
        }
        return (Double)ValidationEffHistory.lastElement();
    }

    private double AdjustNet() {
        Object[] tmp = this.TrainData.toArray();
        double[][] samples = new double[tmp.length][];
        for (int i = 0; i < tmp.length; ++i) {
            samples[i] = (double[])tmp[i];
        }
        int count = samples.length;
        int folds = 3;
        int beginIndex = 0;
        int endIndex = count / folds;
        double error = 0.0;
        for (int k = 0; k < folds; ++k) {
            double[][] TrainingSet = new double[count - (endIndex - beginIndex)][];
            double[][] ValidationSet = new double[endIndex - beginIndex][];
            int vCounter = 0;
            int tCounter = 0;
            for (int r = 0; r < count; ++r) {
                if (r >= beginIndex && r < endIndex) {
                    ValidationSet[vCounter] = samples[r];
                    ++vCounter;
                    continue;
                }
                TrainingSet[tCounter] = samples[r];
                ++tCounter;
            }
            error += this.Train(TrainingSet, ValidationSet);
        }
        return error / (double)folds;
    }

    public boolean IndexIncrement(int[] indexSet, int l) {
        int i;
        int currentSum = 0;
        for (i = indexSet.length - 1; i >= 0; --i) {
            currentSum += indexSet[i];
        }
        for (i = indexSet.length - 1; i >= 0; --i) {
            if (l - currentSum <= 0) {
                currentSum -= indexSet[i];
            } else {
                int n = i;
                indexSet[n] = indexSet[n] + 1;
                return true;
            }
            indexSet[i] = 0;
        }
        return false;
    }

    public void BuildLevel(int l, int d) {
        int[] indexSet = new int[d];
        for (int i = 0; i < d; ++i) {
            indexSet[i] = 0;
        }
        do {
            SubSpace w = new SubSpace(indexSet);
            this.WSpaces.add(w);
        } while (this.IndexIncrement(indexSet, l));
    }

    public int IndexComperator(double[] i1, double[] i2) {
        if (i1.length != i2.length) {
            if (i1.length < i2.length) {
                return -1;
            }
            if (i1.length == i2.length) {
                return 0;
            }
            return 1;
        }
        for (int i = 0; i < i1.length; ++i) {
            if (i1[i] < i2[i]) {
                return -1;
            }
            if (!(i1[i] > i2[i])) continue;
            return 1;
        }
        return 0;
    }

    public double FunctionValue(double[] x, int l, int d) {
        int i;
        int[] indexSet = new int[d];
        for (i = 0; i < d; ++i) {
            indexSet[i] = 0;
        }
        for (i = 0; i < this.WSpaces.size(); ++i) {
            SubSpace w = this.WSpaces.get(i);
            int sum = 0;
            for (int j = 0; j < d; ++j) {
                sum += w.Index[j];
            }
            if (sum > l) continue;
        }
        return 0.0;
    }

    double TransformAndEvaluate(double[] in) {
        double[] value = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            value[i] = in[i] * (this.upBound[i] - this.lowBound[i]) + this.lowBound[i];
        }
        return this.funct(value);
    }

    GaussianLearner CreateGPModel(Vector<double[]> samplePoint, Vector<Double> sampleValue) {
        GaussianLearner GP = new GaussianLearner();
        GP.MeanMethod = new JAMSInteger();
        GP.MeanMethod.setValue(0);
        GP.PerformanceMeasure = new JAMSInteger();
        GP.PerformanceMeasure.setValue(0);
        GP.doOptimization = new JAMSBoolean();
        GP.doOptimization.setValue(false);
        GP.kernelMethod = new JAMSInteger();
        GP.kernelMethod.setValue(2);
        GP.resultFile = new JAMSString();
        GP.resultFile.setValue("test.txt");
        double[][] data = new double[samplePoint.size()][];
        for (int i = 0; i < samplePoint.size(); ++i) {
            data[i] = samplePoint.get(i);
        }
        double[] predict = new double[sampleValue.size()];
        for (int i = 0; i < sampleValue.size(); ++i) {
            predict[i] = sampleValue.get(i);
        }
        GP.trainData = JAMSDataFactory.createEntity();
        GP.trainData.setObject("data", (Object)data);
        GP.trainData.setObject("predict", (Object)predict);
        double[] param = new double[this.n + 1];
        for (int i = 0; i < this.n; ++i) {
            param[i] = 0.1;
        }
        param[this.n] = 0.0;
        GP.param_theta = new JAMSDoubleArray();
        GP.param_theta.setValue(param);
        GP.trainInit();
        GP.setKernels();
        System.out.println("Training Performance (LOO-CV):" + GP.Train(3));
        return GP;
    }

    double CollectData(SpatialDivisionTree tree, Vector<double[]> samplePoint, Vector<Double> sampleValue) {
        if (!tree.isEvaluated) {
            return Double.MAX_VALUE;
        }
        samplePoint.add(((SpatialDivisionTree)tree).Center.value);
        sampleValue.add(new Double(tree.CenterValue));
        if (tree.childs == null) {
            return tree.CenterValue;
        }
        double min = tree.CenterValue;
        for (int i = 0; i < tree.N; ++i) {
            double r = this.CollectData(tree.GetChild(i), samplePoint, sampleValue);
            if (!(r < min)) continue;
            min = r;
        }
        return min;
    }

    public SpatialDivisionTree FindFavouriteNode(SpatialDivisionTree tree, GaussianLearner GP, double currentOptimum) {
        if (tree.childs == null) {
            tree.probability = -100000.0;
            for (int i = 0; i < tree.N; ++i) {
                DVector Corner1 = tree.Center;
                DVector Corner2 = tree.Corners[i];
                DVector Center = new DVector(tree.d);
                for (int j = 0; j < tree.d; ++j) {
                    Center.value[j] = (Corner1.value[j] + Corner2.value[j]) / 2.0;
                }
                double prob = GP.GetProbabilityForXLessY(Center.value, currentOptimum);
                ++this.NodeCounter;
                if (prob == 0.0) {
                    ++this.ProbCounter;
                }
                if (!(tree.probability < prob)) continue;
                tree.probability = prob;
            }
            return tree;
        }
        SpatialDivisionTree favourite = null;
        double bestProb = 0.0;
        for (int i = 0; i < tree.N; ++i) {
            SpatialDivisionTree next = this.FindFavouriteNode(tree.childs[i], GP, currentOptimum);
            if (favourite == null) {
                favourite = next;
                bestProb = next.GetProbability();
                continue;
            }
            if (!(next.GetProbability() > bestProb)) continue;
            favourite = next;
            bestProb = next.GetProbability();
        }
        tree.SetProbability(bestProb);
        return favourite;
    }

    public void WriteModellEff(String file) {
        if (this.n != 2) {
            System.out.println("Skip rasterized output, because dim != 2");
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.dirName + "\\" + file));
        }
        catch (IOException ioe) {
            JAMS.handle((Exception)ioe);
        }
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < 50; ++j) {
                double[] x = new double[]{this.lowBound[0] + (double)i * (this.upBound[0] - this.lowBound[0]) / 50.0, this.lowBound[1] + (double)j * (this.upBound[1] - this.lowBound[1]) / 50.0};
                double y = this.funct(x);
                try {
                    writer.write(y + "\t");
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Fehler" + e.toString());
                }
            }
            try {
                writer.write("\n");
                continue;
            }
            catch (Exception e) {
                System.out.println("Fehler" + e.toString());
            }
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public void WriteSamples(Vector<Double> sampleValue, Vector<double[]> samplePoint, String file) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.dirName + "\\" + file));
        }
        catch (IOException ioe) {
            JAMS.handle((Exception)ioe);
        }
        for (int i = 0; i < samplePoint.size(); ++i) {
            try {
                double[] point = samplePoint.get(i);
                double value = sampleValue.get(i);
                for (int j = 0; j < point.length; ++j) {
                    writer.write(point[j] + "\t");
                }
                writer.write(value + "\n");
                continue;
            }
            catch (Exception e) {
                System.out.println("Fehler" + e.toString());
            }
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public void WriteGPData(GaussianLearner GP, String GPmeanFile, String GPvarFile) {
        if (this.n != 2) {
            System.out.println("Skip rasterized output, because dim != 2");
            return;
        }
        BufferedWriter writer_mean = null;
        BufferedWriter writer_var = null;
        try {
            writer_mean = new BufferedWriter(new FileWriter(this.dirName + "\\" + GPmeanFile));
            writer_var = new BufferedWriter(new FileWriter(this.dirName + "\\" + GPvarFile));
        }
        catch (IOException ioe) {
            JAMS.handle((Exception)ioe);
        }
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < 50; ++j) {
                double[] x = new double[]{0.0 + (double)i / 50.0, 0.0 + (double)j / 50.0};
                double mean = GP.GetMean(x);
                double variance = GP.GetVariance(x);
                try {
                    writer_mean.write(mean + "\t");
                    writer_var.write(variance + "\t");
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Fehler" + e.toString());
                }
            }
            try {
                writer_mean.write("\n");
                writer_var.write("\n");
                continue;
            }
            catch (Exception e) {
                System.out.println("Fehler" + e.toString());
            }
        }
        try {
            writer_mean.close();
            writer_var.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public void WriteGPProb(GaussianLearner GP, String GPprobFile, double min) {
        if (this.n != 2) {
            System.out.println("Skip rasterized output, because dim != 2");
            return;
        }
        BufferedWriter writer_prob = null;
        try {
            writer_prob = new BufferedWriter(new FileWriter(this.dirName + "\\" + GPprobFile));
        }
        catch (IOException ioe) {
            JAMS.handle((Exception)ioe);
        }
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < 50; ++j) {
                double[] x = new double[]{0.0 + (double)i / 50.0, 0.0 + (double)j / 50.0};
                double mean = GP.GetMean(x);
                double optprob = GP.GetProbabilityForXLessY(x, min);
                try {
                    writer_prob.write(optprob + "\t");
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Fehler" + e.toString());
                }
            }
            try {
                writer_prob.write("\n");
                continue;
            }
            catch (Exception e) {
                System.out.println("Fehler" + e.toString());
            }
        }
        try {
            writer_prob.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public void run() {
        this.n = this.parameters.length;
        GaussianLearner.BuildGaussDistributionTable();
        DVector zero = new DVector(this.n);
        DVector one = new DVector(this.n);
        for (int i = 0; i < this.n; ++i) {
            zero.value[i] = 0.0;
            one.value[i] = 1.0;
        }
        SpatialDivisionTree tree = new SpatialDivisionTree(this.n, zero, one, this);
        tree.Subdivide();
        double varianceControl = 1.0;
        Vector<double[]> samplePoint = new Vector<double[]>();
        Vector<Double> sampleValue = new Vector<Double>();
        this.WriteModellEff("model.dat");
        double[] T = new double[]{0.05, 4.0};
        int counter = 0;
        while (true) {
            samplePoint.clear();
            sampleValue.clear();
            double min = this.CollectData(tree, samplePoint, sampleValue);
            SpatialDivisionTree[] bestNode = new SpatialDivisionTree[T.length];
            GaussianLearner GP = this.CreateGPModel(samplePoint, sampleValue);
            GP.variancecontrol = varianceControl;
            this.WriteGPData(GP, "\\info\\gp_mean" + counter + ".dat", "\\info\\gp_variance" + counter + ".dat");
            for (int i = 0; i < T.length; ++i) {
                double opt = min - T[i] * Math.abs(min);
                this.WriteGPProb(GP, "\\info\\gp_prob" + counter + "_T" + T[i] + ".dat", opt);
                this.NodeCounter = 0;
                this.ProbCounter = 0;
                bestNode[i] = this.FindFavouriteNode(tree, GP, opt);
                double f = (double)this.ProbCounter / (double)this.NodeCounter;
                if (!(f > 0.75)) continue;
                varianceControl *= 2.0;
            }
            this.WriteSamples(sampleValue, samplePoint, "\\info\\samples_" + counter + ".dat");
            bestNode[0].Subdivide();
            if (bestNode[0] != bestNode[1]) {
                bestNode[1].Subdivide();
            }
            System.out.println("Iteration: " + counter + "1 ->Explore Node: \n" + bestNode[0].GetCenter().toString() + "\nValue:" + bestNode[0].CenterValue);
            System.out.println("Iteration: " + counter + "2 ->Explore Node: \n" + bestNode[1].GetCenter().toString() + "\nValue:" + bestNode[1].CenterValue);
            System.out.println("Evaluations:" + this.currentSampleCount);
            ++counter;
        }
    }

    class SpatialDivisionTree {
        private SpatialDivisionTree[] childs = null;
        private DVector[] Corners;
        private DVector Center;
        private double CenterValue;
        private double probability;
        private NNOptimizer optimizer;
        public boolean isEvaluated;
        int N;
        int d;

        SpatialDivisionTree(int dimension, DVector Corner1, DVector Corner2, NNOptimizer optimizer) {
            int i;
            this.d = dimension;
            this.N = 1 << dimension;
            this.Corners = new DVector[this.N];
            this.isEvaluated = false;
            for (i = 0; i < this.N; ++i) {
                this.Corners[i] = new DVector(this.d);
                for (int j = 0; j < this.d; ++j) {
                    int maskbit = 1 << j;
                    this.Corners[i].value[j] = (i & maskbit) != 0 ? Corner1.value[j] : Corner2.value[j];
                }
            }
            this.Center = new DVector(this.d);
            for (i = 0; i < this.d; ++i) {
                this.Center.value[i] = (this.Corners[0].value[i] + this.Corners[this.N - 1].value[i]) / 2.0;
            }
            this.optimizer = optimizer;
        }

        SpatialDivisionTree GetChild(int i) {
            return this.childs[i];
        }

        void Subdivide() {
            this.childs = new SpatialDivisionTree[this.N];
            this.isEvaluated = true;
            this.CenterValue = this.optimizer.TransformAndEvaluate(this.Center.value);
            for (int i = 0; i < this.N; ++i) {
                this.childs[i] = new SpatialDivisionTree(this.d, this.Center, this.Corners[i], this.optimizer);
            }
        }

        DVector GetCenter() {
            return this.Center;
        }

        double GetCenterValue() {
            return this.CenterValue;
        }

        void SetProbability(double p) {
            this.probability = p;
        }

        double GetProbability() {
            return this.probability;
        }
    }

    class DVector {
        double[] value;

        DVector(int d) {
            this.value = new double[d];
        }

        public String toString() {
            String r = new String();
            for (int i = 0; i < this.value.length; ++i) {
                r = r + this.value[i] + "\t";
            }
            return r;
        }
    }

    class SubSpace {
        int[] Level;
        int[] Index;
        int d;
        Vector<GridPoint> Grid;

        SubSpace(int[] Level2) {
            this.Level = new int[Level2.length];
            this.d = Level2.length;
            for (int i = 0; i < Level2.length; ++i) {
                this.Level[i] = Level2[i];
                this.Index[i] = 1 << Level2[i];
            }
        }

        boolean NextIndex(int[] IndexOfPoint) {
            for (int i = 0; i < IndexOfPoint.length; ++i) {
                int n = i;
                IndexOfPoint[n] = IndexOfPoint[n] + 1;
                if (IndexOfPoint[n] <= this.Index[i]) {
                    return true;
                }
                IndexOfPoint[i] = 0;
            }
            return false;
        }

        void BuildLattice(NNOptimizer myContext) {
            int[] IndexOfPoint = new int[this.d];
            do {
                GridPoint x = new GridPoint(this.d, IndexOfPoint);
                for (int i = 0; i < this.d; ++i) {
                    x.position[i] = (double)IndexOfPoint[i] / (double)this.Index[i];
                }
                x.value = myContext.funct(x.position);
                this.Grid.add(x);
            } while (this.NextIndex(IndexOfPoint));
        }

        double eval(double[] x) {
            double y = 1.0;
            int[] j = new int[this.d];
            for (int i = 0; i < this.d; ++i) {
                j[i] = (int)Math.round(x[i] / (double)this.Index[i]);
                y *= 1.0 - Math.abs(x[i] * (double)this.Index[i] / (double)j[i]);
            }
            return y;
        }
    }

    class GridPoint {
        public int[] indexSet;
        public double[] position;
        public double value;

        GridPoint(int d, int[] indexSet) {
            indexSet = new int[d];
            this.position = new double[d];
            for (int i = 0; i < d; ++i) {
                this.indexSet[i] = indexSet[i];
            }
        }
    }
}

