/*
 * Decompiled with CFR 0.152.
 */
package rbis.datastore;

import org.unijena.j2k.io.TSDataReader;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSTimeInterval;
import rbis.datastore.DataSource;

public class StandardTSDataSource
extends DataSource {
    JAMSString dataFileName;
    JAMSString dirName;
    JAMSInteger startColumn;
    JAMSBoolean dataCaching;
    JAMSTimeInterval timeInterval;
    double[][] data;
    int counter = 0;

    @Override
    public boolean init() {
        if (!(this.parameter.containsKey("dataFile") && this.parameter.containsKey("dirName") && this.parameter.containsKey("startColumn") && this.parameter.containsKey("dataCaching") && this.parameter.containsKey("timeInterval"))) {
            return false;
        }
        this.dataFileName = new JAMSString((String)this.parameter.get("dataFile"));
        this.dirName = new JAMSString((String)this.parameter.get("dirName"));
        this.startColumn = new JAMSInteger(Integer.parseInt((String)this.parameter.get("startColumn")) + 1);
        this.dataCaching = new JAMSBoolean(Boolean.parseBoolean((String)this.parameter.get("dataCaching")));
        this.timeInterval = new JAMSTimeInterval();
        this.timeInterval.setValue((String)this.parameter.get("timeInterval"));
        TSDataReader tsReader = new TSDataReader();
        tsReader.dirName = this.dirName;
        tsReader.dataFileName = this.dataFileName;
        tsReader.startColumn = this.startColumn;
        tsReader.skipRegression = this.dataCaching;
        tsReader.setModel(this.model);
        tsReader.init();
        int n = (int)this.timeInterval.getNumberOfTimesteps();
        this.data = new double[n][];
        for (int i = 0; i < n; ++i) {
            tsReader.run();
            this.data[i] = tsReader.dataArray.getValue();
        }
        this.counter = 0;
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.counter < this.data.length;
    }

    @Override
    public Object[] getNext() {
        Object[] row = new JAMSDouble[this.data[this.counter].length];
        for (int i = 0; i < this.data[this.counter].length; ++i) {
            row[i] = new JAMSDouble(this.data[this.counter][i]);
        }
        ++this.counter;
        return row;
    }
}

