/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.geotools.data.shapefile.Lock;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.LockTimeoutException;
import org.geotools.index.TreeException;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemIndexStore;
import org.geotools.index.rtree.RTree;
import org.geotools.index.rtree.cachefs.FileSystemPageStore;

public class ShapeFileIndexer {
    public static final String RTREE = "RTREE";
    public static final String QUADTREE = "QUADTREE";
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.shapefile");
    private static final long MIN_WAIT_TIME = 2000L;
    private static final long MAX_WAIT_TIME = 300000L;
    private static Hashtable IDX_CREATION = new Hashtable();
    private String idxType;
    private int max = 50;
    private int min = 25;
    private short split = 1;
    private String fileName;
    private String byteOrder;

    public static void main(String[] args) {
        if (args.length < 1 || (args.length - 1) % 2 != 0) {
            ShapeFileIndexer.usage();
        }
        long start = System.currentTimeMillis();
        ShapeFileIndexer idx = new ShapeFileIndexer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                idx.setIdxType(args[++i]);
                continue;
            }
            if (args[i].equals("-M")) {
                idx.setMax(Integer.parseInt(args[++i]));
                continue;
            }
            if (args[i].equals("-m")) {
                idx.setMin(Integer.parseInt(args[++i]));
                continue;
            }
            if (args[i].equals("-s")) {
                idx.setSplit(Short.parseShort(args[++i]));
                continue;
            }
            if (args[i].equals("-b")) {
                idx.setByteOrder(args[++i]);
                continue;
            }
            if (!args[i].toLowerCase().endsWith(".shp")) {
                System.out.println("File extension must be '.shp'");
                System.exit(1);
            }
            idx.setShapeFileName(args[i]);
        }
        try {
            System.out.print("Indexing ");
            int cnt = idx.index(true, new Lock());
            System.out.println();
            System.out.print(cnt + " features indexed ");
            System.out.println("in " + (System.currentTimeMillis() - start) + "ms.");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
            ShapeFileIndexer.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: ShapeFileIndexer -t <RTREE | QUADTREE> [-M <max entries per node>] [-m <min entries per node>] [-s <split algorithm>] [-b <byte order NL | NM>] <shape file>");
        System.out.println();
        System.out.println("Options:");
        System.out.println("\t-t Index type: RTREE or QUADTREE");
        System.out.println();
        System.out.println("Following options apllies only to RTREE:");
        System.out.println("\t-M maximum number of entries per node");
        System.out.println("\t-m minimum number of entries per node");
        System.out.println("\t-s split algorithm to use");
        System.out.println();
        System.out.println("Following options apllies only to QUADTREE:");
        System.out.println("\t-b byte order to use: NL = LSB; NM = MSB (default)");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int index(boolean verbose, Lock lock) throws MalformedURLException, IOException, TreeException, StoreException, LockTimeoutException {
        int cnt;
        block41: {
            String string;
            boolean alreadyRunning = true;
            String sync = null;
            if (this.fileName == null) {
                throw new IOException("You have to set a shape file name!");
            }
            File file = new File(this.fileName);
            if (!file.canWrite()) {
                return 0;
            }
            Hashtable hashtable = IDX_CREATION;
            synchronized (hashtable) {
                sync = (String)IDX_CREATION.get(this.fileName);
                if (sync == null) {
                    sync = Thread.currentThread().getName();
                    IDX_CREATION.put(this.fileName, sync);
                    alreadyRunning = false;
                }
            }
            if (alreadyRunning) {
                try {
                    LOGGER.info("Waiting for index build completition by thread " + sync);
                    long start = System.currentTimeMillis();
                    while (IDX_CREATION.get(this.fileName) != null && System.currentTimeMillis() - start < 300000L) {
                        String string2 = sync;
                        synchronized (string2) {
                            sync.wait(2000L);
                        }
                    }
                    if (IDX_CREATION.get(this.fileName) != null) {
                        throw new TreeException("Max wait time for index build reached!");
                    }
                    return 0;
                }
                catch (InterruptedException ie) {
                    throw new TreeException("Interrupted during wait for index build");
                }
            }
            cnt = 0;
            try {
                File treeFile;
                String rtreeName;
                FileInputStream is;
                block40: {
                    if (!RTREE.equals(this.idxType) && !QUADTREE.equals(this.idxType)) {
                        throw new TreeException("Index type must be RTREE or QUADTREE");
                    }
                    is = new FileInputStream(file);
                    FileChannel channel = is.getChannel();
                    ShapefileReader reader = null;
                    String ext = this.fileName.substring(this.fileName.lastIndexOf(46));
                    rtreeName = this.fileName.substring(0, this.fileName.lastIndexOf(46));
                    treeFile = new File(rtreeName + ".bld");
                    try {
                        reader = new ShapefileReader((ReadableByteChannel)channel, true, false, lock);
                        if (!ext.equalsIgnoreCase(".shp")) {
                            throw new TreeException("The file to index must have '.shp' extension");
                        }
                        if (this.idxType.equals(RTREE)) {
                            rtreeName = rtreeName + (ext.equals(".shp") ? ".grx" : ".GRX");
                        } else if (this.idxType.equals(QUADTREE)) {
                            rtreeName = rtreeName + (ext.equals(".shp") ? ".qix" : ".QIX");
                        }
                        if (treeFile.exists() && !treeFile.delete()) {
                            throw new TreeException("Unable to delete " + treeFile + " cannot create a new index!");
                        }
                        if (this.idxType.equals(RTREE)) {
                            cnt = this.buildRTree(reader, treeFile, verbose);
                        } else if (this.idxType.equals(QUADTREE)) {
                            cnt = this.buildQuadTree(reader, treeFile, verbose);
                        }
                        Object var14_19 = null;
                        if (reader == null) break block40;
                    }
                    catch (Throwable throwable) {
                        Object var14_20 = null;
                        if (reader != null) {
                            reader.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                if (is != null) {
                    is.close();
                }
                File finalFile = new File(rtreeName);
                boolean copied = false;
                if (finalFile.exists() && !finalFile.delete()) {
                    try {
                        ShapeFileIndexer.copyFile(treeFile, finalFile);
                        copied = true;
                    }
                    catch (IOException ie) {
                        throw new TreeException("Unable to delete " + treeFile + " cannot commit the new index!");
                    }
                }
                if (!copied && !treeFile.renameTo(finalFile)) {
                    throw new TreeException("Unable to rename " + treeFile + " to " + finalFile + " cannot commit the new index!");
                }
                Object var17_25 = null;
                if (alreadyRunning) break block41;
                string = sync;
            }
            catch (Throwable throwable) {
                Object var17_26 = null;
                if (!alreadyRunning) {
                    String string3 = sync;
                    synchronized (string3) {
                        IDX_CREATION.remove(this.fileName);
                        sync.notifyAll();
                    }
                }
                throw throwable;
            }
            synchronized (string) {
                IDX_CREATION.remove(this.fileName);
                sync.notifyAll();
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File source, File dest) throws IOException {
        FileOutputStream out;
        block7: {
            if (!dest.exists()) {
                dest.createNewFile();
            }
            FileInputStream in = null;
            out = null;
            try {
                int len;
                in = new FileInputStream(source);
                out = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                Object var7_6 = null;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
                throw throwable;
            }
            ((InputStream)in).close();
        }
        if (out != null) {
            ((OutputStream)out).close();
        }
    }

    private int buildRTree(ShapefileReader reader, File rtreeFile, boolean verbose) throws TreeException, LockTimeoutException, IOException {
        DataDefinition keyDef = new DataDefinition("US-ASCII");
        keyDef.addField(Integer.class);
        keyDef.addField(Long.class);
        FileSystemPageStore fps = new FileSystemPageStore(rtreeFile, keyDef, this.max, this.min, this.split);
        RTree rtree = new RTree(fps);
        ShapefileReader.Record record = null;
        Data data = null;
        int cnt = 0;
        while (reader.hasNext()) {
            record = reader.nextRecord();
            data = new Data(keyDef);
            data.addValue(new Integer(++cnt));
            data.addValue(new Long(record.offset()));
            rtree.insert(new Envelope(record.minX, record.maxX, record.minY, record.maxY), data);
            if (!verbose || cnt % 500 != 0) continue;
            System.out.print('.');
        }
        rtree.close();
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buildQuadTree(ShapefileReader reader, File file, boolean verbose) throws IOException, StoreException {
        byte order = 0;
        if (this.byteOrder == null || this.byteOrder.equalsIgnoreCase("NM")) {
            order = 2;
        } else if (this.byteOrder.equalsIgnoreCase("NL")) {
            order = 1;
        } else {
            throw new StoreException("Asked byte order '" + this.byteOrder + "' must be 'NL' or 'NM'!");
        }
        String ext = this.fileName.substring(this.fileName.lastIndexOf(46));
        String idxFileName = this.fileName.substring(0, this.fileName.length() - 4) + (ext.equals(".shp") ? ".shx" : ".SHX");
        FileInputStream fisIdx = new FileInputStream(idxFileName);
        FileChannel channelIdx = fisIdx.getChannel();
        IndexFile shpIndex = new IndexFile((ReadableByteChannel)channelIdx);
        QuadTree tree = null;
        int cnt = 0;
        try {
            int numRecs = shpIndex.getRecordCount();
            ShapefileHeader header = reader.getHeader();
            Envelope bounds = new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
            tree = new QuadTree(numRecs, bounds, shpIndex);
            ShapefileReader.Record rec = null;
            while (reader.hasNext()) {
                rec = reader.nextRecord();
                tree.insert(cnt++, new Envelope(rec.minX, rec.maxX, rec.minY, rec.maxY));
                if (!verbose || cnt % 500 != 0) continue;
                System.out.print('.');
            }
        }
        finally {
            channelIdx.close();
            fisIdx.close();
            shpIndex.close();
        }
        FileSystemIndexStore store = new FileSystemIndexStore(file, order);
        store.store(tree);
        return cnt;
    }

    public void setMax(int i) {
        this.max = i;
    }

    public void setMin(int i) {
        this.min = i;
    }

    public void setSplit(short s) {
        this.split = s;
    }

    public void setShapeFileName(String string) {
        this.fileName = string;
    }

    public void setIdxType(String idxType) {
        this.idxType = idxType;
    }

    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }
}

