/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;

public class JDBCFeatureLocking
extends JDBCFeatureStore
implements FeatureLocking {
    FeatureLock featureLock = FeatureLock.TRANSACTION;

    public JDBCFeatureLocking(JDBC1DataStore jdbcDataStore, FeatureType featureType) {
        super(jdbcDataStore, featureType);
    }

    public void setFeatureLock(FeatureLock lock) {
        if (lock == null) {
            throw new NullPointerException("A FeatureLock is required - did you mean FeatureLock.TRANSACTION?");
        }
        this.featureLock = lock;
    }

    public int lockFeatures() throws IOException {
        return this.lockFeatures(Filter.NONE);
    }

    public int lockFeatures(Filter filter) throws IOException {
        return this.lockFeatures(new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int lockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        FeatureReader reader = this.getFeatures(query).reader();
        String typeName = reader.getFeatureType().getTypeName();
        int count = 0;
        try {
            while (reader.hasNext()) {
                try {
                    Feature feature = reader.next();
                    lockingManager.lockFeatureID(typeName, feature.getID(), this.getTransaction(), this.featureLock);
                    ++count;
                }
                catch (FeatureLockException locked) {
                }
                catch (NoSuchElementException nosuch) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)nosuch);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)e);
                    return count;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    public void unLockFeatures() throws IOException {
        this.unLockFeatures(Filter.NONE);
    }

    public void unLockFeatures(Filter filter) throws IOException {
        this.unLockFeatures(new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unLockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        FeatureReader reader = this.getFeatures(query).reader();
        String typeName = reader.getFeatureType().getTypeName();
        try {
            while (reader.hasNext()) {
                try {
                    Feature feature = reader.next();
                    lockingManager.unLockFeatureID(typeName, feature.getID(), this.getTransaction(), this.featureLock);
                }
                catch (NoSuchElementException nosuch) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)nosuch);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)e);
                    return;
                }
            }
        }
        finally {
            reader.close();
        }
    }
}

