/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree.fs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.StoreException;

public class FileSystemNode
extends Node {
    private FileChannel channel;
    private ByteOrder order;
    private int subNodeStartByte;
    private int subNodesLength;
    private int numSubNodes;

    public FileSystemNode(Envelope bounds, int id, Node parent, FileChannel channel, ByteOrder order, int startByte, int subNodesLength) {
        super(bounds, id, parent);
        this.channel = channel;
        this.order = order;
        this.subNodeStartByte = startByte;
        this.subNodesLength = subNodesLength;
    }

    public Node copy() throws IOException {
        FileSystemNode copy = new FileSystemNode(this.getBounds(), this.id, this.getParent(), this.channel, this.order, this.subNodeStartByte, this.subNodesLength);
        copy.numShapesId = this.numShapesId;
        copy.shapesId = new int[this.numShapesId];
        System.arraycopy(this.shapesId, 0, copy.shapesId, 0, this.numShapesId);
        copy.numSubNodes = this.numSubNodes;
        return copy;
    }

    public int getNumSubNodes() {
        return this.numSubNodes;
    }

    public void setNumSubNodes(int numSubNodes) {
        this.numSubNodes = numSubNodes;
    }

    public int getSubNodeStartByte() {
        return this.subNodeStartByte;
    }

    public int getSubNodesLength() {
        return this.subNodesLength;
    }

    public Node getSubNode(int pos) throws StoreException {
        if (this.subNodes.size() > pos) {
            return super.getSubNode(pos);
        }
        try {
            FileSystemNode subNode = null;
            int offset = this.subNodeStartByte;
            if (pos > 0) {
                subNode = (FileSystemNode)this.getSubNode(pos - 1);
                offset = subNode.getSubNodeStartByte() + subNode.getSubNodesLength();
            }
            if (this.channel.position() != (long)offset) {
                this.channel.position(offset);
            }
            int ii = this.subNodes.size();
            for (int i = 0; i < pos + 1 - ii; ++i) {
                subNode = FileSystemNode.readNode(pos, this, this.channel, this.order);
                this.addSubNode(subNode);
            }
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
        return super.getSubNode(pos);
    }

    public static FileSystemNode readNode(int id, Node parent, FileChannel channel, ByteOrder order) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(40);
        buf.order(order);
        channel.read(buf);
        buf.flip();
        int offset = buf.getInt();
        double x1 = buf.getDouble();
        double y1 = buf.getDouble();
        double x2 = buf.getDouble();
        double y2 = buf.getDouble();
        Envelope env = new Envelope(x1, x2, y1, y2);
        int numShapesId = buf.getInt();
        buf = ByteBuffer.allocate(4 * numShapesId + 4);
        buf.order(order);
        channel.read(buf);
        buf.flip();
        int[] ids = new int[numShapesId];
        IntBuffer intBuf = buf.asIntBuffer();
        intBuf.get(ids);
        int numSubNodes = intBuf.get();
        FileSystemNode node = new FileSystemNode(env, id, parent, channel, order, (int)channel.position(), offset);
        node.setShapesId(ids);
        node.setNumSubNodes(numSubNodes);
        return node;
    }
}

