/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.mathematicalCalculations;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class MathematicalCalculations {
    public static double trim(double val, int prec) {
        String zeros = "0.";
        for (int i = 0; i < prec; ++i) {
            zeros = zeros + "0";
        }
        DecimalFormat formatter = new DecimalFormat(zeros);
        DecimalFormatSymbols dfs = formatter.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        formatter.setDecimalFormatSymbols(dfs);
        String output = formatter.format(val);
        try {
            return Double.parseDouble(output);
        }
        catch (NumberFormatException nof) {
            System.err.println("Number Format Exception: " + nof + " because of " + val);
            return Double.parseDouble("-99999");
        }
    }

    public static double deg2rad(double angleDeg) {
        double rad = Math.PI / 180 * angleDeg;
        return rad;
    }

    public static double rad2deg(double angleRad) {
        double deg = 57.29577951308232 * angleRad;
        return deg;
    }
}

