/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.geographicalCalculations;

import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

public class CalcSlopeAspectCorrectionFactor {
    public static double calc_slopeAspectCorrectionFactor(int julDay, double latitude, double slope, double aspect) {
        double horizontal;
        double latRad = MathematicalCalculations.deg2rad(latitude);
        double convAsp = 180.0 - aspect;
        double aspRad = MathematicalCalculations.deg2rad(convAsp);
        double slopeRad = MathematicalCalculations.deg2rad(slope);
        double declRad = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
        double sloped = Math.sin(declRad) * Math.sin(latRad) * Math.cos(slopeRad) - Math.sin(declRad) * Math.cos(latRad) * Math.sin(slopeRad) * Math.cos(aspRad) + Math.cos(declRad) * Math.cos(latRad) * Math.cos(slopeRad) * 1.0 + Math.cos(declRad) * Math.sin(latRad) * Math.sin(slopeRad) * Math.cos(aspRad) * 1.0 + Math.cos(declRad) * Math.sin(slopeRad) * Math.sin(aspRad) * 0.0;
        double slopeAspect = sloped / (horizontal = Math.sin(declRad) * Math.sin(latRad) + Math.cos(declRad) * Math.cos(latRad) * 1.0);
        if (slopeAspect < 0.0) {
            slopeAspect = 0.0;
        }
        return slopeAspect;
    }
}

