/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="NashCascade", author="Peter Krause", description="Description")
public class NashCascade
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="number of tanks")
    public JAMSInteger nTanks;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="recision coefficient k for all tanks")
    public JAMSDouble k;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="input to the first tank in the cascade")
    public JAMSDouble input;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="the tanks itself")
    public JAMSDoubleArray storages;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="outflow from the last tank in the cascade")
    public JAMSDouble output;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        double[] tanks = new double[this.nTanks.getValue()];
        for (int i = 0; i < this.nTanks.getValue(); ++i) {
            tanks[i] = 0.0;
        }
        this.storages = new JAMSDoubleArray();
        this.storages.setValue(tanks);
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double[] tanks = this.storages.getValue();
        double[] outflow = new double[tanks.length];
        double rec = this.k.getValue();
        tanks[0] = tanks[0] + this.input.getValue();
        for (int i = 0; i < this.nTanks.getValue(); ++i) {
            outflow[i] = 1.0 / rec * tanks[i];
            tanks[i] = tanks[i] - outflow[i];
            if (i >= this.nTanks.getValue() - 1) continue;
            tanks[i + 1] = tanks[i + 1] + outflow[i];
        }
        this.output.setValue(outflow[this.nTanks.getValue() - 1]);
        this.storages.setValue(tanks);
    }

    public void cleanup() {
    }
}

