/*
 * Decompiled with CFR 0.152.
 */
package hymod;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

@JAMSComponentDescription(title="dataWriter", author="Peter Krause", description="The data writer for the JAMS-HYMOD model")
public class DataWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="full qualified path name for model output file")
    public JAMSString outFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the current date provided by the temporal context")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the precipitation value of the respective time step")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the potential ET value of the respective time step")
    public JAMSDouble pET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the simulated actual ET value of the respective time step")
    public JAMSDouble simET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the simulated direct flow component of the respective time step")
    public JAMSDouble simDirectFlow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the simulated base flow component of the respective time step")
    public JAMSDouble simBaseFlow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the simulated total runoff of the respective time step")
    public JAMSDouble simRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the observed of the respective time step")
    public JAMSDouble obsRunoff;
    private GenericDataWriter writer;

    public void init() {
        this.writer = new GenericDataWriter(this.outFileName.getValue());
        this.writer.addComment("hymod output");
        this.writer.addComment("");
        this.writer.addColumn("time");
        this.writer.addColumn("precip");
        this.writer.addColumn("obsRunoff");
        this.writer.addColumn("simRunoff");
        this.writer.addColumn("simDirectFlow");
        this.writer.addColumn("simBaseFlow");
        this.writer.addColumn("simET");
        this.writer.addColumn("pET");
        this.writer.writeHeader();
    }

    public void run() {
        this.writer.addData((Object)this.time);
        this.writer.addData((Object)this.precip);
        this.writer.addData((Object)this.obsRunoff);
        this.writer.addData((Object)this.simRunoff);
        this.writer.addData((Object)this.simDirectFlow);
        this.writer.addData((Object)this.simBaseFlow);
        this.writer.addData((Object)this.simET);
        this.writer.addData((Object)this.pET);
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            System.out.println(jre.getMessage());
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

