/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.soillayer;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessLayerdSoilWater", author="Peter Krause, modifications by Manfred Fink", description="Calculates soil water balance for each HRU with vertical layers")
public class J2KProcessLayeredSoilWater
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute slope")
    public JAMSDouble slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="sealed grade")
    public JAMSDouble sealedGrade;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable net rain")
    public JAMSDouble netRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable net snow")
    public JAMSDouble netSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable potET")
    public JAMSDouble potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable actET")
    public JAMSDouble actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="snow depth")
    public JAMSDouble snowDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="daily snow melt")
    public JAMSDouble snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="horizons")
    public JAMSDouble horizons;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in cm depth of soil layer")
    public JAMSDoubleArray layerdepth = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in m actual depth of roots")
    public JAMSDouble rootdepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum MPS")
    public JAMSDoubleArray maxMPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum LPS")
    public JAMSDoubleArray maxLPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual MPS")
    public JAMSDoubleArray actMPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual LPS")
    public JAMSDoubleArray actLPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual depression storage")
    public JAMSDouble actDPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of MPS")
    public JAMSDoubleArray satMPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of LPS")
    public JAMSDoubleArray satLPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum MPS of soil")
    public JAMSDouble soilMaxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum LPS of soil")
    public JAMSDouble soilMaxLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual MPS of soil")
    public JAMSDouble soilActMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual LPS of soil")
    public JAMSDouble soilActLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of MPS of soil")
    public JAMSDouble soilSatMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of LPS of soil")
    public JAMSDouble soilSatLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var saturation of whole soil")
    public JAMSDouble satSoil;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar infiltration")
    public JAMSDouble infiltration;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar interflow")
    public JAMSDouble interflow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar percolation")
    public JAMSDouble percolation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD1 inflow")
    public JAMSDouble inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD1 outflow")
    public JAMSDouble outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD1 generation")
    public JAMSDouble genRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD2 inflow")
    public JAMSDoubleArray inRD2 = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD2 outflow")
    public JAMSDoubleArray outRD2 = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU statevar RD2 generation")
    public JAMSDoubleArray genRD2 = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum depression storage [mm]")
    public JAMSDouble soilMaxDPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="poly reduction of ETP")
    public JAMSDouble soilPolRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="linear reduction of ETP")
    public JAMSDouble soilLinRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration rate in summer [mm/d]")
    public JAMSDouble soilMaxInfSummer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration rate in winter [mm/d]")
    public JAMSDouble soilMaxInfWinter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration rate on snow [mm/d]")
    public JAMSDouble soilMaxInfSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration part on sealed areas (gt 80%)")
    public JAMSDouble soilImpGT80;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum infiltration part on sealed areas (lt 80%)")
    public JAMSDouble soilImpLT80;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="MPS/LPS distribution coefficient for inflow")
    public JAMSDouble soilDistMPSLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="MPS/LPS diffusion coefficient")
    public JAMSDouble soilDiffMPSLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="LPS outflow coefficient")
    public JAMSDouble soilOutLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="LPS lateral-vertical distribution coefficient")
    public JAMSDouble soilLatVertLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum percolation rate in soil [mm/d]")
    public JAMSDouble soilMaxPerc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum percolation rate out of soil [mm/d]")
    public JAMSDouble geoMaxPerc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="concentration coefficient for RD1")
    public JAMSDouble soilConcRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="concentration coefficient for RD2")
    public JAMSDouble soilConcRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="water-use distribution parameter for Transpiration")
    public JAMSDouble BetaW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="intfiltration poritions for the single horizonts")
    public JAMSDoubleArray infiltration_hor = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="percolation out of the single horizonts")
    public JAMSDoubleArray perco_hor = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="evapotranspiration out of the single horizonts")
    public JAMSDoubleArray actETP_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="mps diffusion between layers value")
    public JAMSDoubleArray w_layer_diff = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of state variables LAI ")
    public JAMSDouble LAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="estimated hydraulicconductivity in cm/d")
    public JAMSDouble Kf_geo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in cm/d soil hydraulic conductivity")
    public JAMSDoubleArray kf_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="ID of soil")
    public JAMSDouble soilID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Layer MPS diffusion factor > 1 [-]  default = 10")
    public JAMSDouble kdiff_layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Indicates whether roots can penetrate or not the soil layer [-]")
    public JAMSDoubleArray root_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="max Root depth in soil in m")
    public JAMSDouble soil_root;
    double run_actDPS;
    double run_satSoil1;
    double run_inRain;
    double run_inSnow;
    double run_snowMelt;
    double run_infiltration;
    double run_latComp;
    double run_vertComp;
    double run_overlandflow;
    double run_potETP;
    double run_actETP;
    double run_snowDepth;
    double run_area;
    double run_slope;
    double run_inRD1;
    double soilSatMps;
    double soilSatLps;
    double soilActMps;
    double soilActLps;
    double soilMaxMps;
    double soilMaxLps;
    double run_outRD1;
    double run_genRD1;
    double lowpart;
    double top_satsoil;
    double[] run_maxMPS;
    double[] run_maxLPS;
    double[] run_actMPS;
    double[] run_actLPS;
    double[] run_satMPS;
    double[] run_satLPS;
    double[] run_inRD2;
    double[] run_satHor;
    double[] run_outRD2;
    double[] run_genRD2;
    double[] runlayerdepth;
    double[] horETP;
    double[] runkf_h;
    double[] flux_h_h1;
    int nhor;
    boolean debug;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int h;
        double balMPSstart = 0.0;
        double balMPSend = 0.0;
        double balLPSstart = 0.0;
        double balLPSend = 0.0;
        double balDPSstart = 0.0;
        double balDPSend = 0.0;
        double balIn = 0.0;
        double balOut = 0.0;
        double balET = 0.0;
        double sumactETP = 0.0;
        this.debug = false;
        this.run_area = this.area.getValue();
        this.run_slope = this.slope.getValue();
        this.nhor = (int)this.horizons.getValue();
        double[] infilhor = new double[this.nhor];
        double[] perchor = new double[this.nhor];
        double[] actETP_hor = new double[this.nhor];
        this.flux_h_h1 = new double[this.nhor - 1];
        this.run_satHor = new double[this.nhor];
        this.run_maxMPS = this.maxMPS.getValue();
        this.run_maxLPS = this.maxLPS.getValue();
        this.run_actMPS = this.actMPS.getValue();
        this.run_actLPS = this.actLPS.getValue();
        this.run_satMPS = this.satMPS.getValue();
        this.run_satLPS = this.satLPS.getValue();
        this.run_actDPS = this.actDPS.getValue();
        this.run_inRD1 = this.inRD1.getValue();
        this.run_inRD2 = this.inRD2.getValue();
        this.runkf_h = this.kf_h.getValue();
        balIn += this.run_inRD1;
        this.run_inRain = this.netRain.getValue();
        this.run_inSnow = this.netSnow.getValue();
        this.run_potETP = this.potET.getValue();
        this.run_actETP = this.actET.getValue();
        this.run_snowDepth = this.snowDepth.getValue();
        this.run_snowMelt = this.snowMelt.getValue();
        this.runlayerdepth = new double[this.nhor];
        this.run_genRD2 = new double[this.nhor];
        this.run_outRD2 = new double[this.nhor];
        this.run_latComp = 0.0;
        this.run_vertComp = 0.0;
        this.run_genRD1 = 0.0;
        this.run_outRD1 = 0.0;
        this.lowpart = 0.0;
        this.top_satsoil = 0.0;
        balET = this.run_actETP;
        balDPSstart = this.run_actDPS;
        for (int h2 = 0; h2 < this.nhor; ++h2) {
            balIn += this.run_inRD2[h2];
            balMPSstart += this.run_actMPS[h2];
            balLPSstart += this.run_actLPS[h2];
            this.run_genRD2[h2] = 0.0;
            this.run_outRD2[h2] = 0.0;
        }
        this.calcSoilSaturations(false);
        this.layer_diffusion();
        this.w_layer_diff.setValue(this.flux_h_h1);
        this.calcSoilSaturations(false);
        this.redistRD1_RD2_in();
        this.calcPreInfEvaporation();
        double preinfep = this.run_actETP;
        this.run_infiltration = this.run_inRain + this.run_inSnow + this.run_snowMelt + this.run_actDPS;
        if (this.run_infiltration < 0.0) {
            System.out.println("negative infiltration!");
            System.out.println("inRain: " + this.run_inRain);
            System.out.println("inSnow: " + this.run_inSnow);
            System.out.println("inSnowMelt: " + this.run_snowMelt);
            System.out.println("inDPS: " + this.run_actDPS);
        }
        balIn += this.run_inRain;
        balIn += this.run_inSnow;
        balIn += this.run_snowMelt;
        this.run_actDPS = 0.0;
        this.run_inRain = 0.0;
        this.run_inSnow = 0.0;
        this.run_snowMelt = 0.0;
        this.calcInfImperv(this.sealedGrade.getValue());
        this.calcSoilSaturations(false);
        double maxInf = this.calcMaxInfiltration(this.time.get(2) + 1);
        if (maxInf < this.run_infiltration) {
            double deltaInf = this.run_infiltration - maxInf;
            this.run_actDPS += deltaInf;
            this.run_infiltration = maxInf;
        }
        this.horETP = this.calcMPSEvapotranslayer(true, this.nhor);
        for (h = 0; h < this.nhor; ++h) {
            double bak_infiltration = this.run_infiltration;
            this.run_infiltration = this.calcMPSInflow(this.run_infiltration, h);
            this.run_infiltration = this.calcLPSInflow(this.run_infiltration, h);
            infilhor[h] = bak_infiltration - this.run_infiltration;
        }
        if (this.run_infiltration > 0.0) {
            this.run_actDPS += this.run_infiltration;
            this.run_infiltration = 0.0;
        }
        for (h = 0; h < this.nhor; ++h) {
            this.run_vertComp = this.calcMPSInflow(this.run_vertComp, h);
            this.calcMPSTranspiration(false, h);
            actETP_hor[h] = this.run_actETP;
            this.run_vertComp = this.calcLPSInflow(this.run_vertComp, h);
            if (this.run_vertComp > 0.0) {
                this.run_vertComp = this.calcMPSInflow(this.run_vertComp, h - 1);
                this.run_vertComp = this.calcLPSInflow(this.run_vertComp, h - 1);
                if (this.run_vertComp > 0.0) {
                    System.out.println("VertIn is still not zero!");
                }
            }
            this.calcSoilSaturations(false);
            double MobileWater = 0.0;
            MobileWater = this.run_actLPS[h] > 0.0 ? this.calcLPSoutflow(h) : 0.0;
            this.calcIntfPercRates(MobileWater, h);
            perchor[h] = this.run_vertComp;
            this.calcRD2_out(h);
            this.calcDiffusion(h);
            this.calcSoilSaturations(false);
        }
        if (this.run_overlandflow < 0.0) {
            System.out.println("overlandflow is negative! --> " + this.run_overlandflow);
        }
        this.run_overlandflow += this.calcDirectRunoff();
        this.calcRD1_out();
        for (h = 0; h < this.nhor; ++h) {
            balMPSend += this.run_actMPS[h];
            balLPSend += this.run_actLPS[h];
            balOut += this.run_outRD2[h];
            sumactETP += actETP_hor[h];
        }
        balDPSend = this.run_actDPS;
        balET = sumactETP + preinfep - balET;
        balOut += balET;
        balOut += this.run_outRD1;
        balOut += this.run_vertComp;
        balET = sumactETP + preinfep;
        double balance = balIn + (balMPSstart - balMPSend) + (balLPSstart - balLPSend) + (balDPSstart - balDPSend) - balOut;
        if (Math.abs(balance) > 1.0E-5) {
            System.out.println("balance error at : " + this.time.toString() + " --> " + balance);
        }
        this.satMPS.setValue(this.run_satMPS);
        this.satLPS.setValue(this.run_satLPS);
        this.actMPS.setValue(this.run_actMPS);
        this.actLPS.setValue(this.run_actLPS);
        this.actDPS.setValue(this.run_actDPS);
        this.actET.setValue(balET);
        this.inRD1.setValue(this.run_inRD1);
        this.inRD2.setValue(this.run_inRD2);
        this.outRD1.setValue(this.run_outRD1);
        this.outRD2.setValue(this.run_outRD2);
        this.genRD1.setValue(this.run_genRD1);
        this.genRD2.setValue(this.run_genRD2);
        this.percolation.setValue(this.run_vertComp);
        this.interflow.setValue(this.run_latComp);
        this.soilActMPS.setValue(this.soilActMps);
        this.soilMaxMPS.setValue(this.soilMaxMps);
        this.soilSatMPS.setValue(this.soilSatMps);
        this.soilActLPS.setValue(this.soilActLps);
        this.soilMaxLPS.setValue(this.soilMaxLps);
        this.soilSatLPS.setValue(this.soilSatLps);
        this.infiltration_hor.setValue(infilhor);
        this.perco_hor.setValue(perchor);
        this.actETP_h.setValue(actETP_hor);
    }

    public void cleanup() {
    }

    private boolean calcSoilSaturations(boolean debug) {
        this.soilMaxMps = 0.0;
        this.soilActMps = 0.0;
        this.soilMaxLps = 0.0;
        this.soilActLps = 0.0;
        this.soilSatMps = 0.0;
        this.soilSatLps = 0.0;
        double upperMaxMps = 0.0;
        double upperActMps = 0.0;
        double upperMaxLps = 0.0;
        double upperActLps = 0.0;
        double[] infil_depth = new double[this.nhor];
        double partdepth = 0.0;
        double soilinfil = 50.0;
        for (int h = 0; h < this.nhor; ++h) {
            this.run_satLPS[h] = this.run_actLPS[h] > 0.0 && this.run_maxLPS[h] > 0.0 ? this.run_actLPS[h] / this.run_maxLPS[h] : 0.0;
            this.run_satMPS[h] = this.run_actMPS[h] > 0.0 && this.run_maxMPS[h] > 0.0 ? this.run_actMPS[h] / this.run_maxMPS[h] : 0.0;
            if ((this.run_maxLPS[h] > 0.0 | this.run_maxMPS[h] > 0.0) & (this.run_actLPS[h] > 0.0 | this.run_actMPS[h] > 0.0)) {
                this.run_satHor[h] = (this.run_actLPS[h] + this.run_actMPS[h]) / (this.run_maxLPS[h] + this.run_maxMPS[h]);
            } else {
                this.run_satSoil1 = 0.0;
            }
            int n = h;
            infil_depth[n] = infil_depth[n] + this.layerdepth.getValue()[h];
            if (infil_depth[h] <= soilinfil || h == 0) {
                upperMaxMps += this.run_maxMPS[h] * this.layerdepth.getValue()[h];
                upperActMps += this.run_actMPS[h] * this.layerdepth.getValue()[h];
                upperMaxLps += this.run_maxLPS[h] * this.layerdepth.getValue()[h];
                upperActLps += this.run_actLPS[h] * this.layerdepth.getValue()[h];
                partdepth += this.layerdepth.getValue()[h];
            } else if (infil_depth[h - 1] <= soilinfil) {
                this.lowpart = soilinfil - partdepth;
                upperMaxMps += this.run_maxMPS[h] * this.lowpart;
                upperActMps += this.run_actMPS[h] * this.lowpart;
                upperMaxLps += this.run_maxLPS[h] * this.lowpart;
                upperActMps += this.run_actLPS[h] * this.lowpart;
            }
            this.soilMaxMps += this.run_maxMPS[h];
            this.soilActMps += this.run_actMPS[h];
            this.soilMaxLps += this.run_maxLPS[h];
            this.soilActLps += this.run_actLPS[h];
        }
        if ((this.soilMaxLps > 0.0 | this.soilMaxMps > 0.0) & (this.soilActLps > 0.0 | this.soilActMps > 0.0)) {
            this.run_satSoil1 = (this.soilActLps + this.soilActMps) / (this.soilMaxLps + this.soilMaxMps);
            this.top_satsoil = (upperActLps + upperActMps) / (upperMaxLps + upperMaxMps);
            this.soilSatMps = this.soilActMps / this.soilMaxMps;
            this.soilSatLps = this.soilActLps / this.soilMaxLps;
        } else {
            this.run_satSoil1 = 0.0;
        }
        return true;
    }

    private boolean redistRD1_RD2_in() throws JAMSEntity.NoSuchAttributeException {
        if (this.run_inRD1 > 0.0) {
            this.run_actDPS += this.run_inRD1;
            this.run_inRD1 = 0.0;
        }
        for (int h = 0; h < this.nhor; ++h) {
            if (!(this.run_inRD2[h] > 0.0)) continue;
            this.run_inRD2[h] = this.calcMPSInflow(this.run_inRD2[h], h);
            this.run_inRD2[h] = this.calcLPSInflow(this.run_inRD2[h], h);
            if (!(this.run_inRD2[h] > 0.0)) continue;
            this.run_outRD2[h] = this.run_outRD2[h] + this.run_inRD2[h];
            this.run_inRD2[h] = 0.0;
        }
        return true;
    }

    private boolean layer_diffusion() {
        double[] gradient_h_h1 = new double[this.nhor];
        double[] resistance_h_h1 = new double[this.nhor];
        for (int h = 0; h < this.nhor - 1; ++h) {
            if (this.run_satLPS[h] < 0.05 && (this.run_satMPS[h] < 0.8 || this.run_satMPS[h + 1] < 0.8) && (this.run_satMPS[h] > 0.0 || this.run_satMPS[h + 1] > 0.0)) {
                gradient_h_h1[h] = Math.log10(2.0 - this.run_satMPS[h]) - Math.log10(2.0 - this.run_satMPS[h + 1]);
                double satbalance = Math.pow((Math.pow(this.run_satMPS[h], 2.0) + Math.pow(this.run_satMPS[h + 1], 2.0)) / 2.0, 0.5);
                resistance_h_h1[h] = Math.log10(satbalance) * -this.kdiff_layer.getValue();
                double avg_sat = (this.run_maxMPS[h] * this.run_satMPS[h] + this.run_maxMPS[h + 1] * this.run_satMPS[h + 1]) / (this.run_maxMPS[h] + this.run_maxMPS[h + 1]);
                double pot_flux = Math.abs((avg_sat - this.run_satMPS[h]) * this.run_maxMPS[h]);
                this.flux_h_h1[h] = pot_flux * gradient_h_h1[h] / resistance_h_h1[h];
            } else {
                this.flux_h_h1[h] = 0.0;
            }
            this.run_actMPS[h] = this.run_actMPS[h] + this.flux_h_h1[h];
            this.run_actMPS[h + 1] = this.run_actMPS[h + 1] - this.flux_h_h1[h];
        }
        return true;
    }

    private boolean calcPreInfEvaporation() {
        double deltaETP = this.run_potETP - this.run_actETP;
        if (this.run_actDPS > 0.0) {
            if (this.run_actDPS >= deltaETP) {
                this.run_actDPS -= deltaETP;
                deltaETP = 0.0;
                this.run_actETP = this.run_potETP;
            } else {
                this.run_actDPS = 0.0;
                this.run_actETP = this.run_potETP - (deltaETP -= this.run_actDPS);
            }
        }
        return true;
    }

    private boolean calcInfImperv(double sealedGrade) {
        if (sealedGrade > 0.8) {
            this.run_overlandflow += (1.0 - this.soilImpGT80.getValue()) * this.run_infiltration;
            this.run_infiltration *= this.soilImpGT80.getValue();
        } else if (sealedGrade > 0.0 && sealedGrade <= 0.8) {
            this.run_overlandflow += (1.0 - this.soilImpLT80.getValue()) * this.run_infiltration;
            this.run_infiltration *= this.soilImpLT80.getValue();
        }
        if (this.run_overlandflow < 0.0) {
            System.out.println("overlandflow gets negative because of sealing! " + this.soilImpGT80.getValue() + ", " + this.soilImpLT80.getValue() + ", " + this.run_infiltration);
        }
        return true;
    }

    private double calcMaxInfiltration(int nowmonth, int horizon) {
        double maxInf = 0.0;
        this.calcSoilSaturations(false);
        maxInf = this.run_snowDepth > 0.0 ? this.soilMaxInfSnow.getValue() * this.run_area : (nowmonth >= 5 & nowmonth <= 10 ? (1.0 - this.run_satHor[horizon]) * this.soilMaxInfSummer.getValue() * this.run_area : (1.0 - this.run_satHor[horizon]) * this.soilMaxInfWinter.getValue() * this.run_area);
        return maxInf;
    }

    private double calcMaxInfiltration(int nowmonth) {
        double maxInf = 0.0;
        this.calcSoilSaturations(false);
        maxInf = this.run_snowDepth > 0.0 ? this.soilMaxInfSnow.getValue() * this.runkf_h[0] * this.run_area : (nowmonth >= 5 & nowmonth <= 10 ? (1.0 - this.run_satSoil1) * this.soilMaxInfSummer.getValue() * this.runkf_h[0] * this.run_area : (1.0 - this.run_satSoil1) * this.soilMaxInfWinter.getValue() * this.runkf_h[0] * this.run_area);
        return maxInf;
    }

    private double[] calcMPSEvapotranslayer(boolean debug, int nhor) {
        double[] horETP = new double[nhor];
        double sumlayer = 0.0;
        int i = 0;
        double runrootdepth = this.rootdepth.getValue() * 1000.0 + 10.0;
        double[] partroot = new double[nhor];
        double rootlayer = 0.0;
        double runLAI = this.LAI.getValue();
        double pTransp = 0.0;
        double pEvap = 0.0;
        double[] transp_hord = new double[nhor];
        double[] evapo_hord = new double[nhor];
        double[] transp_hor = new double[nhor];
        double[] evapo_hor = new double[nhor];
        double[] transdemand = new double[nhor];
        double[] evapodemand = new double[nhor];
        double[] compevapo = new double[nhor];
        double[] comptrans = new double[nhor];
        double sumevapodemand = 0.0;
        double sumtransdemand = 0.0;
        double horbal = 0.0;
        double test = 0.0;
        double deltaETP = this.run_potETP - this.run_actETP;
        if (runLAI <= 3.0) {
            pTransp = deltaETP * runLAI / 3.0;
        } else if (runLAI > 3.0) {
            pTransp = deltaETP;
        }
        pEvap = deltaETP - pTransp;
        double soilroot = 0.0;
        while (i < nhor) {
            sumlayer += this.layerdepth.getValue()[i] * 10.0;
            if (this.root_h.getValue()[i] == 1.0) {
                soilroot += this.layerdepth.getValue()[i] * 10.0;
            }
            this.runlayerdepth[i] = sumlayer;
            if (runrootdepth > this.runlayerdepth[0]) {
                if (runrootdepth > this.runlayerdepth[i] && this.root_h.getValue()[i] == 1.0) {
                    partroot[i] = 1.0;
                    rootlayer = i;
                } else if (runrootdepth > this.runlayerdepth[i - 1] && this.root_h.getValue()[i] == 1.0) {
                    partroot[i] = (runrootdepth - this.runlayerdepth[i - 1]) / (this.runlayerdepth[i] - this.runlayerdepth[i - 1]);
                    rootlayer = i;
                } else {
                    partroot[i] = 0.0;
                }
            } else if (i == 0) {
                partroot[i] = runrootdepth / this.runlayerdepth[0];
                rootlayer = i;
            }
            ++i;
        }
        if (runrootdepth >= sumlayer) {
            runrootdepth = sumlayer;
        }
        for (i = 0; i < nhor; ++i) {
            runrootdepth = Math.min(runrootdepth, soilroot);
            transp_hord[i] = pTransp * (1.0 - Math.exp(-this.BetaW.getValue() * (this.runlayerdepth[i] / runrootdepth))) / (1.0 - Math.exp(-this.BetaW.getValue()));
            if (transp_hord[i] > pTransp) {
                transp_hord[i] = pTransp;
            }
            evapo_hord[i] = pEvap * (this.runlayerdepth[i] / (this.runlayerdepth[i] + Math.exp(2.374 - 0.00713 * this.runlayerdepth[i])));
            if (evapo_hord[i] > pEvap) {
                evapo_hord[i] = pEvap;
            }
            if (i != nhor - 1) continue;
            evapo_hord[i] = pEvap;
            transp_hord[i] = pTransp;
        }
        for (i = 0; i < nhor; ++i) {
            if (i == 0) {
                transp_hor[i] = transp_hord[i];
                evapo_hor[i] = evapo_hord[i];
            } else {
                transp_hor[i] = transp_hord[i] - transp_hord[i - 1];
                evapo_hor[i] = evapo_hord[i] - evapo_hord[i - 1];
            }
            horETP[i] = transp_hor[i] + evapo_hor[i];
            if (!debug) continue;
            test = deltaETP - (horbal += horETP[i]);
        }
        if ((test > 1.0E-7 || test < -1.0E-7) && debug) {
            System.out.println("evaporation balance error = " + test);
        }
        this.soil_root.setValue(soilroot / 1000.0);
        return horETP;
    }

    private boolean calcMPSTranspiration(boolean debug, int hor) {
        double sat_factor;
        double reductionFactor;
        double maxTrans = 0.0;
        this.calcSoilSaturations(debug);
        double deltaETP = this.horETP[hor];
        if (this.soilLinRed.getValue() > 0.0) {
            if (this.run_satMPS[hor] < this.soilLinRed.getValue()) {
                double reductionFactor2 = this.run_satMPS[hor] / this.soilLinRed.getValue();
                maxTrans = deltaETP * reductionFactor2;
            } else {
                maxTrans = deltaETP;
            }
        } else if (this.soilPolRed.getValue() > 0.0 && (maxTrans = deltaETP * (reductionFactor = Math.pow(10.0, sat_factor = -10.0 * Math.pow(1.0 - this.run_satMPS[hor], this.soilPolRed.getValue())))) > deltaETP) {
            maxTrans = deltaETP;
        }
        this.run_actMPS[hor] = this.run_actMPS[hor] - maxTrans;
        this.run_actETP = maxTrans;
        this.calcSoilSaturations(debug);
        return true;
    }

    private double calcMPSInflow(double infiltration, int hor) {
        double inflow = infiltration;
        this.calcSoilSaturations(false);
        if (inflow < this.run_maxMPS[hor] - this.run_actMPS[hor]) {
            if (this.run_actMPS[hor] == 0.0) {
                this.run_actMPS[hor] = this.run_actMPS[hor] + inflow;
                inflow = 0.0;
            } else {
                double alpha = this.soilDistMPSLPS.getValue();
                if (this.run_satMPS[hor] == 0.0) {
                    this.run_satMPS[hor] = 1.0E-7;
                }
                double inMPS = inflow * (1.0 - Math.exp(-1.0 * alpha / this.run_satMPS[hor]));
                this.run_actMPS[hor] = this.run_actMPS[hor] + inMPS;
                inflow -= inMPS;
            }
        } else {
            double deltaMPS = this.run_maxMPS[hor] - this.run_actMPS[hor];
            this.run_actMPS[hor] = this.run_maxMPS[hor];
            inflow -= deltaMPS;
        }
        this.calcSoilSaturations(false);
        return inflow;
    }

    private double calcLPSInflow(double infiltration, int hor) {
        this.calcSoilSaturations(false);
        this.run_actLPS[hor] = this.run_actLPS[hor] + infiltration;
        infiltration = 0.0;
        if (this.run_actLPS[hor] > this.run_maxLPS[hor]) {
            infiltration = this.run_actLPS[hor] - this.run_maxLPS[hor];
            this.run_actLPS[hor] = this.run_maxLPS[hor];
        }
        this.calcSoilSaturations(false);
        return infiltration;
    }

    private double calcLPSoutflow(int hor) {
        double LPSoutflow;
        double potLPSoutflow;
        double alpha = this.soilOutLPS.getValue();
        if (this.run_satLPS[hor] == 1.0) {
            this.run_satLPS[hor] = 0.999999;
        }
        if ((potLPSoutflow = (1.0 - 1.0 / (Math.pow(this.run_satHor[hor], 2.0) + alpha)) * this.run_actLPS[hor]) > this.run_actLPS[hor]) {
            potLPSoutflow = this.run_actLPS[hor];
        }
        if ((LPSoutflow = potLPSoutflow) > this.run_actLPS[hor]) {
            LPSoutflow = this.run_actLPS[hor];
        }
        this.run_actLPS[hor] = this.run_actLPS[hor] - LPSoutflow;
        return LPSoutflow;
    }

    private boolean calcIntfPercRates(double MobileWater, int hor) {
        if (MobileWater > 0.0) {
            double slope_weight = Math.tan(this.run_slope * (Math.PI / 180)) * this.soilLatVertLPS.getValue();
            double part_perc = 1.0 - slope_weight;
            if (part_perc > 1.0) {
                part_perc = 1.0;
            } else if (part_perc < 0.0) {
                part_perc = 0.0;
            }
            double part_intf = 1.0 - part_perc;
            this.run_latComp += MobileWater * part_intf;
            this.run_vertComp += MobileWater * part_perc;
            double maxPerc = 0.0;
            if (hor == this.nhor - 1) {
                maxPerc = this.geoMaxPerc.getValue() * this.run_area * this.Kf_geo.getValue() / 86.4;
                if (this.run_vertComp > maxPerc) {
                    double rest = this.run_vertComp - maxPerc;
                    this.run_vertComp = maxPerc;
                    this.run_latComp += rest;
                }
            } else {
                try {
                    maxPerc = this.soilMaxPerc.getValue() * this.run_area * this.runkf_h[hor + 1] / 86.4;
                }
                catch (Exception e) {
                    System.out.println("SOILID = " + this.soilID.getValue());
                }
                if (this.run_vertComp > maxPerc) {
                    double rest = this.run_vertComp - maxPerc;
                    this.run_vertComp = maxPerc;
                    this.run_latComp += rest;
                }
            }
        } else {
            this.run_latComp = 0.0;
            this.run_vertComp = 0.0;
        }
        return true;
    }

    private double calcDirectRunoff() {
        double directRunoff = 0.0;
        if (this.run_actDPS > 0.0) {
            double maxDep = 0.0;
            maxDep = this.run_slope > 5.0 ? this.soilMaxDPS.getValue() * this.run_area / 2.0 : this.soilMaxDPS.getValue() * this.run_area;
            if (this.run_actDPS > maxDep) {
                directRunoff = this.run_actDPS - maxDep;
                this.run_actDPS = maxDep;
            }
        }
        if (directRunoff < 0.0) {
            System.out.println("directRunoff is negative! --> " + directRunoff);
        }
        return directRunoff;
    }

    private boolean calcRD2_out(int h) {
        double RD2_output_factor = 1.0 / this.soilConcRD2.getValue();
        if (RD2_output_factor > 1.0) {
            RD2_output_factor = 1.0;
        } else if (RD2_output_factor < 0.0) {
            RD2_output_factor = 0.0;
        }
        double RD2_output = this.run_latComp * RD2_output_factor;
        this.run_actLPS[h] = this.run_actLPS[h] + (this.run_latComp - RD2_output);
        this.run_outRD2[h] = this.run_outRD2[h] + RD2_output;
        this.run_genRD2[h] = this.run_outRD2[h];
        if (this.run_genRD2[h] < 0.0) {
            this.run_genRD2[h] = 0.0;
        }
        this.run_latComp = 0.0;
        return true;
    }

    private boolean calcRD1_out() {
        double RD1_output_factor = 1.0 / this.soilConcRD1.getValue();
        if (RD1_output_factor > 1.0) {
            RD1_output_factor = 1.0;
        } else if (RD1_output_factor < 0.0) {
            RD1_output_factor = 0.0;
        }
        double RD1_output = this.run_overlandflow * RD1_output_factor;
        this.run_actDPS += this.run_overlandflow - RD1_output;
        this.run_outRD1 += RD1_output;
        this.run_genRD1 = this.run_outRD1;
        this.run_overlandflow = 0.0;
        return true;
    }

    private boolean calcDiffusion(int h) {
        double diffusion = 0.0;
        this.calcSoilSaturations(false);
        double deltaMPS = this.run_maxMPS[h] - this.run_actMPS[h];
        if (this.run_satMPS[h] == 0.0) {
            diffusion = 0.0;
        } else {
            double diff = this.soilDiffMPSLPS.getValue();
            diffusion = this.run_actLPS[h] * (1.0 - Math.exp(-1.0 * diff / this.run_satMPS[h]));
        }
        if (diffusion > this.run_actLPS[h]) {
            diffusion = this.run_actLPS[h];
        }
        if (diffusion < deltaMPS) {
            this.run_actMPS[h] = this.run_actMPS[h] + diffusion;
            this.run_actLPS[h] = this.run_actLPS[h] - diffusion;
        } else {
            double rest = this.run_maxMPS[h] - this.run_actMPS[h];
            this.run_actMPS[h] = this.run_maxMPS[h];
            this.run_actLPS[h] = this.run_actLPS[h] - rest;
        }
        return true;
    }
}

