/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.io;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Reach water  withdrawal", author="Manfred Fink", description="Takes water and nitrogen out of a reach segment")
public class reach_water_withdraw
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The reach collection")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 outflow in l")
    public JAMSDouble outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 outflow in l")
    public JAMSDouble outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 outflow in l")
    public JAMSDouble outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 outflow in l")
    public JAMSDouble outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Water that leaves the reach out of the system in m\u00c2\u00b3/s determinated by the file")
    public JAMSDouble measured_waterloss;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="SurfaceN outflow in kgN")
    public JAMSDouble SurfaceNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="(fast) InterflowN outflow in kgN")
    public JAMSDouble InterflowNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="(slow) InterflowN outflow in kgN")
    public JAMSDouble N_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="GoundwaterN outflow in kgN")
    public JAMSDouble N_RG2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Water that leaves the reach out of the system in m\u00c2\u00b3/s determinated by the model")
    public JAMSDouble model_waterloss;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Nitrogen that leaves the reach out of the system in kgN determinated by the model")
    public JAMSDouble Nitrogenloss;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="ID of the reach which losses water and nitrogen")
    public JAMSInteger reach_id;

    public void init() {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        int runid = (int)entity.getDouble("ID");
        if (runid == this.reach_id.getValue()) {
            double sumwater = this.outRD1.getValue() + this.outRD2.getValue() + this.outRG1.getValue() + this.outRG2.getValue();
            double sumN = this.SurfaceNabs.getValue() + this.InterflowNabs.getValue() + this.N_RG1_out.getValue() + this.N_RG2_out.getValue();
            double waterloss_run = this.measured_waterloss.getValue() * 8.64E7;
            double losspart = 0.0;
            losspart = waterloss_run < sumwater ? waterloss_run / sumwater : 1.0;
            double keep_part = 1.0 - losspart;
            this.outRD1.setValue(keep_part * this.outRD1.getValue());
            this.outRD2.setValue(keep_part * this.outRD2.getValue());
            this.outRG1.setValue(keep_part * this.outRG1.getValue());
            this.outRG2.setValue(keep_part * this.outRG2.getValue());
            this.SurfaceNabs.setValue(keep_part * this.SurfaceNabs.getValue());
            this.InterflowNabs.setValue(keep_part * this.InterflowNabs.getValue());
            this.N_RG1_out.setValue(keep_part * this.N_RG1_out.getValue());
            this.N_RG2_out.setValue(keep_part * this.N_RG2_out.getValue());
            double run_model_waterloss = sumwater * losspart / 8.64E7;
            double run_N_loss = sumN * losspart;
            this.model_waterloss.setValue(run_model_waterloss);
            this.Nitrogenloss.setValue(run_N_loss);
        }
    }

    public void cleanup() {
    }
}

