/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.crop;

import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KSNDormancy", author="Manfred Fink", description="Calculates dormancy of plants under use of day length (after SWAT). Dormancy variable is also used to simulate maturity")
public class J2KSNDormancy
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Maximum sunshine duration in h")
    public JAMSDouble sunhmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Minimum yearly sunshine duration in h")
    public JAMSDouble sunhmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity latidute")
    public JAMSDouble latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="indicates dormancy of plants")
    public JAMSBoolean dormancy;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plants base growth temperature [\u00c2\u00b0C]")
    public JAMSDouble tbase;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU daily mean temperature [\u00c2\u00b0C]")
    public JAMSDouble Tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Fraction of actual potential heat units sum [-]")
    public JAMSDouble FPHUact;

    public void init() {
    }

    public void run() {
        double sunhminrun = 0.0;
        double tdorm = 0.0;
        boolean rundormancy = false;
        sunhminrun = this.sunhmin.getValue() > 0.0 ? this.sunhmin.getValue() : this.sunhmax.getValue();
        sunhminrun = Math.min(sunhminrun, this.sunhmax.getValue());
        tdorm = this.latitude.getValue() < 20.0 ? 0.0 : (this.latitude.getValue() < 40.0 ? (this.latitude.getValue() - 20.0) / 20.0 : 1.0);
        rundormancy = this.sunhmax.getValue() < sunhminrun + tdorm ? true : this.Tmean.getValue() < this.tbase.getValue();
        if (this.FPHUact.getValue() > 1.0) {
            rundormancy = true;
        }
        this.sunhmin.setValue(sunhminrun);
        this.dormancy.setValue(rundormancy);
    }

    public void cleanup() {
    }
}

