/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSEntityEnumerator;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KGroundwaterNswat", author="Manfred Fink", description="Groundwater N module after SWAT (very Simple)")
public class J2KGroundwaterNswat
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="attribute area")
    public JAMSString aNameArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG1 inflow")
    public JAMSString aNameInRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG2 inflow")
    public JAMSString aNameInRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG1 outflow")
    public JAMSString aNameOutRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG2 outflow")
    public JAMSString aNameOutRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG1 N outflow in kgN")
    public JAMSString aNameN_RG1_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG2 N outflow in kgN")
    public JAMSString aNameN_RG2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG1 N outflow in kgN")
    public JAMSString aNameN_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RG2 N outflow in kgN")
    public JAMSString aNameN_RG2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU Concentration Factor in mgN/l for RG1")
    public JAMSString aNameN_concRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU Concentration Factor in mgN/l for RG2")
    public JAMSString aNameN_concRG2;
    double N_RG1_in = 0.0;
    double N_RG2_in = 0.0;
    double N_RG1_out = 0.0;
    double N_RG2_out = 0.0;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityEnumerator eEnum = this.hrus.getEntityEnumerator();
        JAMSEntity[] entities = this.hrus.getEntityArray();
        for (int i = 0; i < entities.length; ++i) {
            entities[i].setDouble(this.aNameN_concRG1.getValue(), 2.0);
            entities[i].setDouble(this.aNameN_concRG2.getValue(), 2.0);
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double RG1_out = this.entity.getDouble(this.aNameOutRG1.getValue());
        double RG2_out = this.entity.getDouble(this.aNameOutRG2.getValue());
        double N_concRG1 = this.entity.getDouble(this.aNameN_concRG1.getValue());
        double N_concRG2 = this.entity.getDouble(this.aNameN_concRG2.getValue());
        this.N_RG1_out = RG1_out * N_concRG1 / 1000000.0;
        this.N_RG2_out = RG2_out * N_concRG1 / 1000000.0;
        this.entity.setDouble(this.aNameN_RG1_in.getValue(), this.N_RG1_in);
        this.entity.setDouble(this.aNameN_RG2_in.getValue(), this.N_RG2_in);
        this.entity.setDouble(this.aNameN_RG1_out.getValue(), this.N_RG1_out);
        this.entity.setDouble(this.aNameN_RG2_out.getValue(), this.N_RG2_out);
    }

    public void cleanup() {
    }
}

