/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import org.unijena.hydronet.Neuron;

public class NONeuron
extends Neuron {
    private Neuron downstreamNeuron = null;
    private double downstreamWeight;
    private Neuron outputNeuron = null;
    private double outputWeight;

    public void setDownstreamNeuron(Neuron dsNeuron, double weight) {
        this.downstreamNeuron = dsNeuron;
        this.downstreamWeight = weight;
    }

    public double getDownstreamWeight() {
        return this.downstreamWeight;
    }

    public double getOutputWeight() {
        return this.outputWeight;
    }

    public void setOutputNeuron(Neuron dsNeuron, double weight) {
        this.outputNeuron = dsNeuron;
        this.outputWeight = weight;
    }

    public void propagate() {
        this.calc();
        this.input = 0.0;
        if (this.downstreamNeuron != null) {
            this.downstreamNeuron.addToInput(this.activation * this.downstreamWeight);
        }
        if (this.outputNeuron != null) {
            this.outputNeuron.addToInput(this.activation * this.outputWeight);
        }
    }

    public void backpropagate() {
        double dsDelta = 0.0;
        if (this.downstreamNeuron != null) {
            dsDelta = this.downstreamNeuron.getDelta() * this.downstreamWeight;
        }
        double outputDelta = this.outputNeuron.getDelta() * this.outputWeight;
        this.calcDelta(dsDelta + outputDelta);
    }

    public double calc() {
        this.lastInput = this.input;
        if (this.ActivationFunctions.size() == 0) {
            this.activation = this.input;
            return this.activation;
        }
        this.activation = this.calc(this.input);
        return this.activation;
    }

    public double calcDelta(double error) {
        return this.calcDelta(error, 1.0);
    }

    public double calcDelta(double error, double buffer) {
        if (this.ActivationFunctions.size() == 0) {
            this.delta = error;
            return this.delta;
        }
        this.delta = this.calcDelta(this.lastInput, error, buffer);
        return this.delta;
    }
}

