/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import org.unijena.hydronet.ActivationFunction;
import org.unijena.hydronet.DLinApprox;
import org.unijena.hydronet.Matrix;

public class LinApprox
implements ActivationFunction {
    private Matrix M;

    public LinApprox(Matrix M) {
        this.M = new Matrix(M.toString());
        this.order();
    }

    public Matrix getData() {
        return this.M;
    }

    protected void swap(Matrix M, int i, int j) {
        double tempx = M.element[i][0];
        double tempy = M.element[i][1];
        M.element[i][0] = M.element[j][0];
        M.element[i][1] = M.element[j][1];
        M.element[j][0] = tempx;
        M.element[j][1] = tempy;
    }

    protected void order() {
        boolean index = false;
        for (int k = 0; k < this.M.rows - 1; ++k) {
            for (int j = k + 1; j < this.M.rows; ++j) {
                if (!(this.M.element[j][0] < this.M.element[k][0])) continue;
                this.swap(this.M, k, j);
            }
        }
    }

    @Override
    public double calculate(double x) {
        double result = 0.0;
        int i = 0;
        double increase = 0.0;
        if (x <= this.M.element[0][0]) {
            result = this.M.element[0][1];
        } else if (x > this.M.element[this.M.rows - 1][0]) {
            result = this.M.element[this.M.rows - 1][1];
        } else {
            while (x > this.M.element[i][0]) {
                ++i;
            }
            result = this.M.element[--i + 1][0] == this.M.element[i][0] ? this.M.element[i][1] : this.M.element[i][1] + (this.M.element[i + 1][1] - this.M.element[i][1]) / (this.M.element[i + 1][0] - this.M.element[i][0]) * (x - this.M.element[i][0]);
        }
        return result;
    }

    @Override
    public double[] getParams() {
        double[] params = null;
        return params;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public ActivationFunction derive() {
        Matrix D = new Matrix(this.M.rows - 1, this.M.columns);
        for (int i = 0; i < this.M.rows - 1; ++i) {
            double increase = this.M.element[i + 1][0] == this.M.element[i][0] ? 0.0 : (this.M.element[i + 1][1] - this.M.element[i][1]) / (this.M.element[i + 1][0] - this.M.element[i][0]);
            D.element[i][0] = this.M.element[i][0];
            D.element[i][1] = increase;
        }
        return new DLinApprox(D);
    }

    @Override
    public int getType() {
        return 3;
    }
}

