/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import org.unijena.hydronet.DistNeuron;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

public class HydroNETCalc
extends JAMSComponent {
    @JAMSComponentDescription(title="HydroNETCalc", author="Christian Fischer", description="")
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntity NitrogenOutEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntity CostOutEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="largest accepted nitrogen value")
    public JAMSDouble nitrogen_goal;

    public void run() throws JAMSEntity.NoSuchAttributeException {
        DistNeuron NitrogenOutNeuron = (DistNeuron)this.NitrogenOutEntity.getObject("NEURON");
        DistNeuron CostOutNeuron = (DistNeuron)this.CostOutEntity.getObject("NEURON");
        NitrogenOutNeuron.calc();
        CostOutNeuron.calc();
        NitrogenOutNeuron.reset();
        CostOutNeuron.reset();
        NitrogenOutNeuron.setDelta(this.nitrogen_goal.getValue() - NitrogenOutNeuron.getActivation());
        CostOutNeuron.setDelta(-CostOutNeuron.getActivation());
    }
}

