/*
 * Decompiled with CFR 0.152.
 */
package rbis.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.unijena.jams.JAMSTools;

public class PGSQLConnector {
    private String hostname;
    private String database;
    private String username;
    private String passwd;
    private Connection con;

    public PGSQLConnector(String hostname, String database, String username, String passwd) {
        this.hostname = hostname;
        this.database = database;
        this.username = username;
        this.passwd = passwd;
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
    }

    public void connect() throws SQLException {
        this.con = DriverManager.getConnection("jdbc:postgresql://" + this.hostname + "/" + this.database, this.username, this.passwd);
    }

    public ResultSet execQuery(String sqlQuery) throws SQLException {
        if (this.con == null) {
            return null;
        }
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(sqlQuery);
        return rs;
    }

    public void close() throws SQLException {
        this.con.close();
    }

    public static void main(String[] args) {
        PGSQLConnector pgsql = new PGSQLConnector("localhost", "saaleRIS", "postgres", "admin");
        try {
            pgsql.connect();
            String query = JAMSTools.fileToString((String)"D:/jams/RBISDesk/timeseries.sql");
            ResultSet rs = pgsql.execQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            int rowCount = 1;
            while (rs.next()) {
                System.out.println("Line " + rowCount + ": ");
                for (int i = 1; i <= numberOfColumns; ++i) {
                    System.out.print("\t" + rsmd.getColumnName(i) + ": ");
                    System.out.println(rs.getString(i));
                }
                System.out.println("");
                ++rowCount;
            }
            rs.close();
            pgsql.close();
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
        }
    }
}

