/*
 * Decompiled with CFR 0.152.
 */
package rbis.datastore;

import java.util.HashMap;
import java.util.Vector;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.io.XMLIO;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.JAMSRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import rbis.datastore.DataSource;
import rbis.datastore.IndexSource;

public class DataStore
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="xml datasource description file")
    public JAMSString dataSourceXMLFile;
    JAMSRuntime rt = null;
    Vector<Store> stores = new Vector();
    private int ColumnCounter = 0;

    Column ProcessColumnSource(Element columnSourceNode, Column column, JAMSTimeInterval timeInterval) {
        Column currentColumn = new Column();
        currentColumn.id = column.id;
        currentColumn.position = column.position;
        currentColumn.type = column.type;
        if (!columnSourceNode.hasAttribute("source")) {
            this.rt.println("Error: ColumnNode has no source! Skip this column!");
            return null;
        }
        currentColumn.source = columnSourceNode.getAttribute("source");
        if (!columnSourceNode.hasAttribute("sourcecolumn")) {
            this.rt.println("Warning: ColumnNode has no source column! Set to zero");
            currentColumn.sourceColumn = 0;
        } else {
            currentColumn.sourceColumn = Integer.parseInt(columnSourceNode.getAttribute("sourcecolumn"));
        }
        if (columnSourceNode.hasAttribute("starttime")) {
            if (timeInterval == null) {
                this.rt.println("starttime was specified, but no timeinterval!\n column skipped!");
                return null;
            }
            JAMSCalendar cal = new JAMSCalendar();
            cal.setValue(columnSourceNode.getAttribute("starttime"));
            JAMSTimeInterval tv = new JAMSTimeInterval();
            tv.setStart(timeInterval.getStart());
            tv.setEnd(cal);
            tv.setTimeUnit(timeInterval.getTimeUnit());
            currentColumn.startIndex = (int)tv.getNumberOfTimesteps();
        } else {
            currentColumn.startIndex = columnSourceNode.hasAttribute("startrow") ? Integer.parseInt(columnSourceNode.getAttribute("startrow")) : 0;
        }
        return currentColumn;
    }

    Vector<Column> ProcessDataDefinition(Element tsNode, JAMSTimeInterval timeInterval) {
        NodeList columnList = tsNode.getElementsByTagName("column");
        Vector<Column> columns = new Vector<Column>();
        for (int i = 0; i < columnList.getLength(); ++i) {
            Element columnNode = (Element)columnList.item(i);
            Column currentColumn = new Column();
            if (!columnNode.hasAttribute("id")) {
                this.rt.println("Warning: ColumnNode has no id!, set to default");
                currentColumn.id = "default";
            } else {
                currentColumn.id = columnNode.getAttribute("id");
            }
            ++this.ColumnCounter;
            currentColumn.position = currentColumn.position;
            if (!columnNode.hasAttribute("type")) {
                this.rt.println("Warning: ColumnNode has no type! set to default: JAMSString");
                currentColumn.type = "JAMSString";
            } else {
                currentColumn.type = columnNode.getAttribute("type");
            }
            NodeList columnSourceList = columnNode.getElementsByTagName("columnsource");
            for (int j = 0; j < columnSourceList.getLength(); ++j) {
                Element columnSourceNode = (Element)columnSourceList.item(j);
                Column col = this.ProcessColumnSource(columnSourceNode, currentColumn, timeInterval);
                if (col == null) continue;
                this.rt.println("column-definition:" + col.toString());
                columns.add(col);
            }
        }
        return columns;
    }

    HashMap<String, DataSource> ProcessDataSourceDefinition(Element tsNode, JAMSTimeInterval timeInterval) {
        NodeList sourceList = tsNode.getElementsByTagName("datasource");
        HashMap<String, DataSource> sources = new HashMap<String, DataSource>();
        ClassLoader loader = this.rt.getClassLoader();
        for (int i = 0; i < sourceList.getLength(); ++i) {
            Element dataSourceNode = (Element)sourceList.item(i);
            if (!dataSourceNode.hasAttribute("type")) {
                this.rt.println("Error: Datasource has no type");
                continue;
            }
            DataSource source = null;
            try {
                Class<?> clazz = loader.loadClass(dataSourceNode.getAttribute("type"));
                source = (DataSource)clazz.newInstance();
            }
            catch (Exception e) {
                System.out.println("Error while loading clazz: " + dataSourceNode.getAttribute("type") + ",because:" + e.toString());
                continue;
            }
            if (!dataSourceNode.hasAttribute("id")) {
                this.rt.println("Warning: Datasource has no id, set to default");
                source.id = "default";
            } else {
                source.id = dataSourceNode.getAttribute("id");
            }
            NodeList parameterList = dataSourceNode.getElementsByTagName("parameter");
            for (int j = 0; j < parameterList.getLength(); ++j) {
                Element attrValuePair = (Element)parameterList.item(j);
                if (!attrValuePair.hasAttribute("id") || !attrValuePair.hasAttribute("value")) continue;
                source.parameter.put(new String(attrValuePair.getAttribute("id")), new String(attrValuePair.getAttribute("value")));
                this.rt.println("Key/Value - Pair:" + attrValuePair.getAttribute("id") + "/" + attrValuePair.getAttribute("value"));
            }
            source.parameter.put(new String("dirName"), this.dirName.getValue());
            source.model = this.getModel();
            sources.put(source.id, source);
        }
        return sources;
    }

    boolean ProcessDataSeriesNode(Element tsNode, Store parent, boolean isTimeserie) {
        HashMap<String, DataSource> sourceList;
        JAMSTimeInterval timeInterval = new JAMSTimeInterval();
        if (tsNode.hasAttribute("interval")) {
            if (!isTimeserie) {
                this.rt.println("found dataserie with interval attribute");
            }
            timeInterval.setValue(tsNode.getAttribute("interval"));
        } else {
            if (isTimeserie) {
                this.rt.println("found timeserie without interval attribute");
            }
            timeInterval = null;
        }
        Vector<Column> columnList = this.ProcessDataDefinition(tsNode, timeInterval);
        if (columnList == null) {
            this.rt.println("one or more column definitions are not correct");
        }
        if ((sourceList = this.ProcessDataSourceDefinition(tsNode, timeInterval)) == null) {
            this.rt.println("one or more data source definitions are not correct");
        }
        IndexSource index = new IndexSource();
        if (timeInterval != null) {
            index.parameter.put("timeInterval", timeInterval.getValue());
        } else {
            index.startIndex = 0;
        }
        index.id = "index";
        index.model = this.getModel();
        sourceList.put(index.id, index);
        DataSerie dataSerie = new DataSerie();
        dataSerie.columns = columnList;
        dataSerie.dataSources = sourceList;
        parent.series.add(dataSerie);
        return true;
    }

    void CreateDataSerie(DataSerie serie, String name) {
        int i;
        int ColumnCount = 0;
        for (int i2 = 0; i2 < serie.columns.size(); ++i2) {
            if (serie.columns.get((int)i2).position + 1 <= ColumnCount) continue;
            ColumnCount = serie.columns.get((int)i2).position + 1;
        }
        String[] header = new String[ColumnCount];
        Object[] row = new Object[ColumnCount];
        HashMap srcData = new HashMap();
        GenericDataWriter writer = new GenericDataWriter(this.dirName + "\\" + name);
        for (DataSource source : serie.dataSources.values()) {
            if (!source.init()) {
                this.rt.println("Error! Could not initialize datasource:" + source.id);
            }
            Vector<Object[]> srcColumns = new Vector<Object[]>();
            while (source.hasNext()) {
                srcColumns.add(source.getNext());
            }
            srcData.put(source.id, srcColumns);
        }
        for (i = 0; i < serie.columns.size(); ++i) {
            header[serie.columns.get((int)i).position] = serie.columns.get((int)i).id;
        }
        for (i = 0; i < header.length; ++i) {
            writer.addColumn(header[i]);
        }
        writer.writeHeader();
        boolean bFinished = false;
        int counter = 0;
        while (!bFinished) {
            int i3;
            bFinished = true;
            for (i3 = 0; i3 < ColumnCount; ++i3) {
                row[i3] = null;
            }
            for (i3 = 0; i3 < serie.columns.size(); ++i3) {
                Column col = serie.columns.get(i3);
                Vector source = (Vector)srcData.get(col.source);
                if (source == null) {
                    this.rt.println("source " + col.source + " wasn\u00b4t found!");
                    if (row[col.position] != null) continue;
                    row[col.position] = new JAMSString("");
                    continue;
                }
                if (counter - col.startIndex < 0) {
                    bFinished = false;
                }
                if (counter - col.startIndex < 0 || counter - col.startIndex >= source.size()) {
                    if (row[col.position] != null) continue;
                    row[col.position] = new JAMSString("");
                    continue;
                }
                bFinished = false;
                row[col.position] = ((Object[])source.get(counter - col.startIndex))[col.sourceColumn];
            }
            for (i3 = 0; i3 < row.length; ++i3) {
                writer.addData(row[i3]);
            }
            try {
                writer.writeData();
            }
            catch (Exception e) {
                this.rt.println("could not write data, because:" + e.toString());
                e.printStackTrace();
            }
            ++counter;
        }
        writer.close();
    }

    public void init() {
        Document datasourceDescription = null;
        this.ColumnCounter = 0;
        try {
            datasourceDescription = XMLIO.getDocument((String)(this.dirName.getValue() + "\\" + this.dataSourceXMLFile.getValue()));
        }
        catch (Exception e) {
            System.out.println("Could not read XML File, because:" + e.toString());
            e.printStackTrace();
            return;
        }
        Element root = datasourceDescription.getDocumentElement();
        String type = root.getNodeName();
        this.rt = this.getModel().getRuntime();
        do {
            Element tsNode;
            int i;
            if (type != "datastore") continue;
            Store store = new Store();
            store.id = root.getAttribute("id");
            store.author = root.getAttribute("author");
            store.date = root.getAttribute("date");
            store.description = root.getAttribute("description");
            store.series = new Vector();
            this.rt.println("Datastore:\nID:" + store.id + "\nAuthor:" + store.author + "\nDate:" + store.date + "\nDescription:" + store.description);
            NodeList timeseries = root.getElementsByTagName("timeseries");
            NodeList dataseries = root.getElementsByTagName("dataseries");
            for (i = 0; i < timeseries.getLength(); ++i) {
                tsNode = (Element)timeseries.item(i);
                this.ProcessDataSeriesNode(tsNode, store, true);
            }
            for (i = 0; i < dataseries.getLength(); ++i) {
                tsNode = (Element)dataseries.item(i);
                this.ProcessDataSeriesNode(tsNode, store, false);
            }
            this.stores.add(store);
        } while ((root = (Element)root.getNextSibling()) != null);
        this.rt.println("finished reading " + this.dataSourceXMLFile.getValue());
        for (int i = 0; i < this.stores.size(); ++i) {
            Store store = this.stores.get(i);
            for (int j = 0; j < store.series.size(); ++j) {
                String name = Integer.toString(j);
                while (name.length() < 4) {
                    name = "0" + name;
                }
                this.CreateDataSerie(store.series.get(j), store.id + "ts" + name + ".dat");
            }
        }
    }

    public void finish() {
    }

    class Column {
        public String id;
        public int position;
        public String source;
        public int sourceColumn;
        public int startIndex;
        public String type;

        Column() {
        }

        public String toString() {
            return new String("id:" + this.id + "\nposition:" + this.position + "\nsource:" + this.source + "\nstartTime:" + this.startIndex + "\ntype:" + this.type);
        }
    }

    class DataSerie {
        HashMap<String, DataSource> dataSources;
        Vector<Column> columns;

        DataSerie() {
        }
    }

    class Store {
        public String id;
        public String author;
        public String description;
        public String date;
        Vector<DataSerie> series;

        Store() {
        }
    }
}

