/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import org.geotools.metadata.iso.identification.IdentificationImpl;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.util.InternationalString;

public class DataIdentificationImpl
extends IdentificationImpl
implements DataIdentification {
    private static final long serialVersionUID = -4418520352804939785L;
    private Collection spatialRepresentationTypes;
    private Collection spatialResolutions;
    private Collection language;
    private Charset characterSet;
    private Collection topicCategories;
    private Collection geographicBox;
    private Collection geographicDescription;
    private InternationalString environmentDescription;
    private Collection extent;
    private InternationalString supplementalInformation;

    public DataIdentificationImpl() {
    }

    public DataIdentificationImpl(Citation citation, InternationalString abstracts, Collection language, Collection topicCategories) {
        super(citation, abstracts);
        this.setLanguage(language);
        this.setTopicCategories(topicCategories);
    }

    public synchronized Collection getSpatialRepresentationTypes() {
        this.spatialRepresentationTypes = this.nonNullCollection(this.spatialRepresentationTypes, SpatialRepresentationType.class);
        return this.spatialRepresentationTypes;
    }

    public synchronized void setSpatialRepresentationTypes(Collection newValues) {
        this.spatialRepresentationTypes = this.copyCollection(newValues, this.spatialRepresentationTypes, SpatialRepresentationType.class);
    }

    public synchronized Collection getSpatialResolutions() {
        this.spatialResolutions = this.nonNullCollection(this.spatialResolutions, Resolution.class);
        return this.spatialResolutions;
    }

    public synchronized void setSpatialResolutions(Collection newValues) {
        this.spatialResolutions = this.copyCollection(newValues, this.spatialResolutions, Resolution.class);
    }

    public synchronized Collection getLanguage() {
        this.language = this.nonNullCollection(this.language, Locale.class);
        return this.language;
    }

    public synchronized void setLanguage(Collection newValues) {
        this.language = this.copyCollection(newValues, this.language, Locale.class);
    }

    public Charset getCharacterSet() {
        return this.characterSet;
    }

    public synchronized void setCharacterSet(Charset newValue) {
        this.checkWritePermission();
        this.characterSet = newValue;
    }

    public synchronized Collection getTopicCategories() {
        this.topicCategories = this.nonNullCollection(this.topicCategories, TopicCategory.class);
        return this.topicCategories;
    }

    public synchronized void setTopicCategories(Collection newValues) {
        this.topicCategories = this.copyCollection(newValues, this.topicCategories, TopicCategory.class);
    }

    public synchronized Collection getGeographicBox() {
        this.geographicBox = this.nonNullCollection(this.geographicBox, GeographicBoundingBox.class);
        return this.geographicBox;
    }

    public synchronized void setGeographicBox(Collection newValues) {
        this.geographicBox = this.copyCollection(newValues, this.geographicBox, GeographicBoundingBox.class);
    }

    public synchronized Collection getGeographicDescription() {
        this.geographicDescription = this.nonNullCollection(this.geographicDescription, InternationalString.class);
        return this.geographicDescription;
    }

    public synchronized void setGeographicDescription(Collection newValues) {
        this.geographicDescription = this.copyCollection(newValues, this.geographicDescription, InternationalString.class);
    }

    public InternationalString getEnvironmentDescription() {
        return this.environmentDescription;
    }

    public synchronized void setEnvironmentDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.environmentDescription = newValue;
    }

    public synchronized Collection getExtent() {
        this.extent = this.nonNullCollection(this.extent, Extent.class);
        return this.extent;
    }

    public synchronized void setExtent(Collection newValues) {
        this.extent = this.copyCollection(newValues, this.extent, Extent.class);
    }

    public InternationalString getSupplementalInformation() {
        return this.supplementalInformation;
    }

    public synchronized void setSupplementalInformation(InternationalString newValue) {
        this.checkWritePermission();
        this.supplementalInformation = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.spatialRepresentationTypes = (Collection)DataIdentificationImpl.unmodifiable(this.spatialRepresentationTypes);
        this.spatialResolutions = (Collection)DataIdentificationImpl.unmodifiable(this.spatialResolutions);
        this.language = (Collection)DataIdentificationImpl.unmodifiable(this.language);
        this.characterSet = (Charset)DataIdentificationImpl.unmodifiable(this.characterSet);
        this.topicCategories = (Collection)DataIdentificationImpl.unmodifiable(this.topicCategories);
        this.geographicBox = (Collection)DataIdentificationImpl.unmodifiable(this.geographicBox);
        this.geographicDescription = (Collection)DataIdentificationImpl.unmodifiable(this.geographicDescription);
        this.environmentDescription = (InternationalString)DataIdentificationImpl.unmodifiable(this.environmentDescription);
        this.extent = (Collection)DataIdentificationImpl.unmodifiable(this.extent);
        this.supplementalInformation = (InternationalString)DataIdentificationImpl.unmodifiable(this.supplementalInformation);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            DataIdentificationImpl that = (DataIdentificationImpl)object;
            return Utilities.equals(this.spatialRepresentationTypes, that.spatialRepresentationTypes) && Utilities.equals(this.spatialResolutions, that.spatialResolutions) && Utilities.equals(this.language, that.language) && Utilities.equals(this.characterSet, that.characterSet) && Utilities.equals(this.topicCategories, that.topicCategories) && Utilities.equals(this.geographicBox, that.geographicBox) && Utilities.equals(this.geographicDescription, that.geographicDescription) && Utilities.equals(this.environmentDescription, that.environmentDescription) && Utilities.equals(this.extent, that.extent) && Utilities.equals(this.supplementalInformation, that.supplementalInformation);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 1111119863;
        if (this.spatialRepresentationTypes != null) {
            code ^= ((Object)this.spatialRepresentationTypes).hashCode();
        }
        if (this.spatialResolutions != null) {
            code ^= ((Object)this.spatialResolutions).hashCode();
        }
        if (this.language != null) {
            code ^= ((Object)this.language).hashCode();
        }
        if (this.characterSet != null) {
            code ^= this.characterSet.hashCode();
        }
        if (this.topicCategories != null) {
            code ^= ((Object)this.topicCategories).hashCode();
        }
        if (this.geographicBox != null) {
            code ^= ((Object)this.geographicBox).hashCode();
        }
        if (this.geographicDescription != null) {
            code ^= ((Object)this.geographicDescription).hashCode();
        }
        if (this.environmentDescription != null) {
            code ^= this.environmentDescription.hashCode();
        }
        if (this.extent != null) {
            code ^= ((Object)this.extent).hashCode();
        }
        if (this.supplementalInformation != null) {
            code ^= this.supplementalInformation.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.spatialRepresentationTypes);
    }
}

