/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.unijena.jams.JAMS;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class PredictionControl
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Precip Data")
    public JAMSString datafile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger ExampleLength;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger numOfExamples;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger trainStart;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger trainEnd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger validationStart;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger validationEnd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="TimeSerie of Temp Data")
    public JAMSInteger relevantTime;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="TimeSerie of Temp Data")
    public JAMSInteger TrainLengthForOptimizing;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="TimeSerie of Temp Data")
    public JAMSBoolean doOptimizing;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity trainData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSEntity validationData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="TimeSerie of Temp Data")
    public JAMSInteger dataShift;
    HashMap<Integer, double[]> rawData;
    HashMap<Integer, double[]> rawPredict;
    double[][] data;
    double[] predict;
    double[][] traindata;
    double[] trainpredict;
    double[][] optimizedata;
    double[] optimizepredict;
    double[][] validationdata;
    double[] validationpredict;
    int RelevantTime = 1;
    int ExamplLength;
    int numOfExampl;

    public void loadData() throws JAMSEntity.NoSuchAttributeException {
        int i;
        BufferedReader reader = null;
        HashMap<Integer, double[]> rawData = new HashMap<Integer, double[]>();
        HashMap<Integer, double[]> rawPredict = new HashMap<Integer, double[]>();
        this.ExamplLength = this.ExampleLength.getValue();
        this.numOfExampl = this.numOfExamples.getValue();
        this.RelevantTime = this.relevantTime.getValue();
        try {
            reader = new BufferedReader(new FileReader(this.datafile.getValue()));
        }
        catch (IOException ioe) {
            JAMS.handle((Exception)ioe);
        }
        String nextString = null;
        try {
            i = 0;
            while ((nextString = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(nextString, "\t");
                double[] Example = new double[this.ExamplLength];
                double[] Predict = new double[1];
                try {
                    for (int j = 0; j < this.ExamplLength; ++j) {
                        Example[j] = new Double(st.nextToken());
                    }
                    Predict[0] = new Double(st.nextToken());
                }
                catch (Exception e) {
                    System.out.println("Error in Dataset: " + i + " stop reading! (not enough tokens)");
                    break;
                }
                if (st.hasMoreTokens()) {
                    System.out.println("Error in Dataset: " + i + " stop reading! (too many tokens)");
                    break;
                }
                rawData.put(new Integer(i), Example);
                rawPredict.put(new Integer(i), Predict);
                ++i;
            }
        }
        catch (IOException ioe) {
            JAMS.handle((Exception)ioe);
        }
        this.data = new double[this.numOfExampl][this.RelevantTime * this.ExamplLength];
        this.predict = new double[this.numOfExampl];
        for (i = 0; i < this.numOfExampl; ++i) {
            for (int j = 0; j < this.RelevantTime; ++j) {
                double[] entry = (double[])rawData.get(new Integer(i + j));
                for (int k = 0; k < this.ExamplLength; ++k) {
                    this.data[i][j * this.ExamplLength + k] = entry[k];
                }
            }
            if (i + this.RelevantTime - 1 + this.dataShift.getValue() < 0) {
                System.out.println("Warning: Dataset: " + i + "contains no prediction!!");
                continue;
            }
            this.predict[i] = ((double[])rawPredict.get(new Integer(i + this.RelevantTime - 1 + this.dataShift.getValue())))[0];
        }
        this.traindata = new double[this.trainEnd.getValue() - this.trainStart.getValue()][this.RelevantTime * this.ExamplLength];
        this.trainpredict = new double[this.trainEnd.getValue() - this.trainStart.getValue()];
        for (i = this.trainStart.getValue(); i < this.trainEnd.getValue(); ++i) {
            this.traindata[i - this.trainStart.getValue()] = this.data[i];
            this.trainpredict[i - this.trainStart.getValue()] = this.predict[i];
        }
        this.validationdata = new double[this.validationEnd.getValue() - this.validationStart.getValue()][this.RelevantTime * this.ExamplLength];
        this.validationpredict = new double[this.validationEnd.getValue() - this.validationStart.getValue()];
        for (i = this.validationStart.getValue(); i < this.validationEnd.getValue(); ++i) {
            this.validationdata[i - this.validationStart.getValue()] = this.data[i];
            this.validationpredict[i - this.validationStart.getValue()] = this.predict[i];
        }
        this.validationData.setObject("data", (Object)this.validationdata);
        this.validationData.setObject("predict", (Object)this.validationpredict);
        if (this.doOptimizing.getValue()) {
            this.SelectOptimalTrainingSet(this.TrainLengthForOptimizing.getValue());
            this.trainData.setObject("data", (Object)this.optimizedata);
            this.trainData.setObject("predict", (Object)this.optimizepredict);
        } else {
            this.trainData.setObject("data", (Object)this.traindata);
            this.trainData.setObject("predict", (Object)this.trainpredict);
        }
    }

    public void SelectOptimalTrainingSet(int goal) {
        int i;
        int[] set = new int[goal];
        double[] variance = new double[this.trainEnd.getValue()];
        boolean[] inSet = new boolean[this.trainEnd.getValue()];
        for (int j = this.trainStart.getValue(); j < this.trainEnd.getValue(); ++j) {
            variance[j] = 0.0;
            inSet[j] = false;
        }
        inSet[0] = true;
        set[0] = 0;
        for (i = 1; i < goal; ++i) {
            int bestIndex = -1;
            double bestValue = -1.0;
            for (int j = this.trainStart.getValue(); j < this.trainEnd.getValue(); ++j) {
                if (inSet[j]) continue;
                for (int l = 0; l < this.ExamplLength; ++l) {
                    int n = j;
                    variance[n] = variance[n] + (this.data[j][l] - this.data[set[i - 1]][l]) * (this.data[j][l] - this.data[set[i - 1]][l]);
                }
                if (!(variance[j] > bestValue)) continue;
                bestValue = variance[j];
                bestIndex = j;
            }
            inSet[bestIndex] = true;
            set[i] = bestIndex;
            System.out.println("Take:" + set[i]);
        }
        this.optimizedata = new double[goal][this.RelevantTime * this.ExamplLength];
        this.optimizepredict = new double[goal];
        for (i = 0; i < goal; ++i) {
            this.optimizedata[i] = this.data[set[i]];
            this.optimizepredict[i] = this.predict[set[i]];
        }
    }

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.loadData();
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
    }
}

