/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import com.vividsolutions.jts.geom.MultiPolygon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.collection.CollectionDataStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeature;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.unijena.jams.data.JAMSString;

public class ShapeTool
extends JPanel {
    public JButton export;
    private File fileToSave;
    private File dbfFile;
    private ShapefileDataStore store;
    private URL baseShapeUrl;
    private String shpIdColName;
    private String addAttr;
    private Object[][] tabledata;
    private Set<String> list;
    private JTable table;
    public JTextField FileNameField;
    private CollectionDataStore f;

    public ShapeTool(CollectionDataStore features, JAMSString Shapefile, String newAttr, final JSplitPane panel, final JScrollPane tree) throws Exception {
        this.baseShapeUrl = new File(Shapefile.toString().split(";")[0]).toURI().toURL();
        this.dbfFile = new File(Shapefile.toString().split(";")[0].substring(0, Shapefile.toString().split(";")[0].length() - 4) + ".dbf");
        this.shpIdColName = Shapefile.toString().split(";")[1];
        this.addAttr = newAttr;
        this.store = new ShapefileDataStore(this.baseShapeUrl);
        this.f = features;
        this.setLayout(new BorderLayout());
        this.add((Component)new AttributeSelectList(), "Center");
        JPanel l = new JPanel();
        this.FileNameField = new JTextField("", 10);
        this.FileNameField.setEditable(false);
        l.add(this.FileNameField);
        URL url = this.getClass().getResource("resources/ordner.gif");
        ImageIcon icon = new ImageIcon(url);
        JButton open = new JButton(icon);
        open.addActionListener(new OpenFile());
        l.add(open);
        this.add((Component)l, "North");
        JPanel b = new JPanel();
        JButton cancel = new JButton("Cancel");
        this.export = new JButton("Export");
        this.export.setEnabled(false);
        b.add(cancel);
        b.add(this.export);
        this.export.addActionListener(new GenerateShape(this, panel, tree));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                panel.setDividerLocation(0.8);
                panel.setTopComponent(tree);
            }
        });
        this.add((Component)b, "South");
        this.setVisible(true);
    }

    static /* synthetic */ Object[][] access$102(ShapeTool x0, Object[][] x1) {
        x0.tabledata = x1;
        return x1;
    }

    class GenerateShape
    implements ActionListener {
        JSplitPane panel;
        JScrollPane tree;

        GenerateShape(ShapeTool s, JSplitPane p, JScrollPane t) {
            this.panel = p;
            this.tree = t;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ArrayList<String> attlist = new ArrayList<String>();
            for (int i = 0; i <= ShapeTool.this.list.size(); ++i) {
                if (!((Boolean)ShapeTool.this.table.getValueAt(i, 0)).booleanValue()) continue;
                attlist.add(ShapeTool.this.table.getValueAt(i, 1).toString());
            }
            try {
                URL saveUrl = ShapeTool.this.fileToSave.toURI().toURL();
                ShapefileDataStore newdatastore = new ShapefileDataStore(saveUrl);
                DbaseFileHeader dbfh = new DbaseFileHeader();
                dbfh.readHeader((ReadableByteChannel)new FileInputStream(ShapeTool.this.dbfFile).getChannel());
                HashMap<String, Class> types = new HashMap<String, Class>();
                for (int i = 0; i < dbfh.getNumFields(); ++i) {
                    if (!attlist.contains(dbfh.getFieldName(i))) continue;
                    types.put(dbfh.getFieldName(i), dbfh.getFieldClass(i));
                }
                FeatureTypeFactory userFType = FeatureTypeBuilder.newInstance((String)"userFType");
                GeometryAttributeType geo = (GeometryAttributeType)AttributeTypeFactory.newAttributeType((String)"geo", MultiPolygon.class);
                userFType.addType((AttributeType)geo);
                for (int i = 0; i < attlist.size(); ++i) {
                    AttributeType newAt = AttributeTypeFactory.newAttributeType((String)((String)attlist.get(i)), (Class)((Class)types.get(attlist.get(i))));
                    userFType.addType(newAt);
                }
                newdatastore.createSchema(userFType.getFeatureType());
                FeatureWriter fw = newdatastore.getFeatureWriter("userFType", Transaction.AUTO_COMMIT);
                HashMap<Long, Object> h = new HashMap<Long, Object>();
                FeatureIterator fIter = ShapeTool.this.f.getCollection().features();
                while (fIter.hasNext()) {
                    Feature q = fIter.next();
                    h.put(Long.valueOf(q.getID()), q.getAttribute("newAt"));
                }
                ShapefileDataStore store = new ShapefileDataStore(ShapeTool.this.baseShapeUrl);
                for (Feature f : store.getFeatureSource(store.getTypeNames()[0]).getFeatures()) {
                    DefaultFeature a = (DefaultFeature)fw.next();
                    a.setAttribute("geo", (Object)f.getDefaultGeometry());
                    a.setAttribute((String)attlist.get(0), h.get((Long)f.getAttribute(ShapeTool.this.shpIdColName)));
                    if (attlist.size() > 1) {
                        for (int j = 1; j < attlist.size(); ++j) {
                            a.setAttribute((String)attlist.get(j), f.getAttribute((String)attlist.get(j)));
                        }
                    }
                    fw.write();
                }
                fw.close();
                this.panel.setDividerLocation(0.8);
                this.panel.setTopComponent(this.tree);
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
            }
            catch (FactoryRegistryException e) {
            }
            catch (SchemaException e) {
            }
            catch (NoSuchElementException e) {
            }
            catch (IllegalAttributeException e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class OpenFile
    implements ActionListener {
        OpenFile() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogType(1);
            fc.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Shapefile (*.shp)";
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".shp");
                }
            });
            fc.showSaveDialog(null);
            ShapeTool.this.fileToSave = fc.getSelectedFile();
            ShapeTool.this.FileNameField.setText(ShapeTool.this.fileToSave.getName() + ".shp");
            ShapeTool.this.export.setEnabled(true);
        }
    }

    class AttributeSelectList
    extends JPanel {
        public AttributeSelectList() throws IOException {
            int i;
            Object[] columnNames = new String[]{" ", "Attribute"};
            AttributeType[] shpAtts = ShapeTool.this.store.getSchema(ShapeTool.this.store.getTypeNames()[0]).getAttributeTypes();
            ShapeTool.access$102(ShapeTool.this, new Object[shpAtts.length][2]);
            ShapeTool.this.list = new TreeSet();
            for (i = 0; i < shpAtts.length; ++i) {
                ShapeTool.this.list.add(shpAtts[i].getName());
            }
            ShapeTool.this.list.remove("the_geom");
            ((ShapeTool)ShapeTool.this).tabledata[0][0] = Boolean.TRUE;
            ((ShapeTool)ShapeTool.this).tabledata[0][1] = ShapeTool.this.addAttr.toUpperCase();
            i = 1;
            Iterator iterate = ShapeTool.this.list.iterator();
            while (iterate.hasNext()) {
                ((ShapeTool)ShapeTool.this).tabledata[i][0] = Boolean.FALSE;
                ((ShapeTool)ShapeTool.this).tabledata[i][1] = new String(iterate.next().toString());
                ++i;
            }
            ShapeTool.this.table = new JTable(ShapeTool.this.tabledata, columnNames){

                public Class getColumnClass(int column) {
                    return this.getValueAt(0, column).getClass();
                }
            };
            ColoredTableCellRenderer ren = new ColoredTableCellRenderer();
            ShapeTool.this.table.setDefaultRenderer(String.class, ren);
            TableColumn col = ShapeTool.this.table.getColumnModel().getColumn(0);
            col.setPreferredWidth(1);
            ShapeTool.this.table.setPreferredScrollableViewportSize(new Dimension(130, 250));
            JScrollPane scrollPane = new JScrollPane(ShapeTool.this.table);
            this.add(scrollPane);
        }

        class ColoredTableCellRenderer
        extends DefaultTableCellRenderer {
            ColoredTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (isSelected) {
                    this.setForeground(Color.black);
                }
                if (row == 0) {
                    this.setBackground(Color.lightGray);
                } else {
                    this.setBackground(table.getBackground());
                }
                return this;
            }
        }
    }
}

