/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.feature.Feature;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;

public class BoundsVisitor
implements FeatureCalc {
    Envelope bounds = new Envelope();

    public void visit(Feature feature) {
        Geometry geom = feature.getDefaultGeometry();
        Envelope bbox = geom.getEnvelopeInternal();
        this.bounds.expandToInclude(bbox);
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public void reset(Envelope bounds) {
        this.bounds = new Envelope();
    }

    public CalcResult getResult() {
        return new BoundsResult(this.bounds);
    }

    public static class BoundsResult
    extends AbstractCalcResult {
        private Envelope bbox;

        public BoundsResult(Envelope bbox) {
            this.bbox = bbox;
        }

        public Object getValue() {
            return new Envelope(this.bbox);
        }

        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof BoundsResult;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd instanceof BoundsResult) {
                Envelope newBounds = new Envelope(this.bbox);
                newBounds.expandToInclude((Envelope)resultsToAdd.getValue());
                return new BoundsResult(newBounds);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

