/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;

public final class DataStoreFinder {
    protected static final Logger LOGGER;
    private static FactoryRegistry registry;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DataStoreFinder() {
    }

    public static synchronized DataStore getDataStore(Map params) throws IOException {
        Iterator ps = DataStoreFinder.getAvailableDataStores();
        while (ps.hasNext()) {
            DataStoreFactorySpi fac = (DataStoreFactorySpi)ps.next();
            try {
                if (!fac.canProcess(params)) continue;
                return fac.createDataStore(params);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not acquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return null;
    }

    public static synchronized Iterator getAvailableDataStores() {
        HashSet<DataStoreFactorySpi> availableDS = new HashSet<DataStoreFactorySpi>(5);
        Iterator it = DataStoreFinder.getServiceRegistry().getServiceProviders(DataStoreFactorySpi.class);
        while (it.hasNext()) {
            DataStoreFactorySpi dsFactory = (DataStoreFactorySpi)it.next();
            if (!dsFactory.isAvailable()) continue;
            availableDS.add(dsFactory);
        }
        return availableDS.iterator();
    }

    private static FactoryRegistry getServiceRegistry() {
        if (!$assertionsDisabled && !Thread.holdsLock(DataStoreFinder.class)) {
            throw new AssertionError();
        }
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DataStoreFactorySpi.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        DataStoreFinder.getServiceRegistry().scanForPlugins();
    }

    static {
        $assertionsDisabled = !DataStoreFinder.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("org.geotools.data");
    }
}

