/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.unijena.hydronet.GenericFunction;
import org.unijena.hydronet.LinApprox;
import org.unijena.hydronet.Matrix;
import org.unijena.j2k.J2KFunctions;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSModel;
import org.unijena.jams.model.JAMSVarDescription;

public class StandardNitrogenFlowReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Soil types parameter file name")
    public JAMSString Scenario0pFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Soil types parameter file name")
    public JAMSString ScenarioFileNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Soil types parameter file name")
    public JAMSString ScenarioISTFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity[] field_fd;
        StringTokenizer tok = new StringTokenizer(this.ScenarioFileNames.getValue(), ";");
        int N = tok.countTokens();
        JAMSEntityCollection[] FlowData = new JAMSEntityCollection[N + 1];
        for (int i = 0; i < N; ++i) {
            FlowData[i] = new JAMSEntityCollection();
            FlowData[i].setEntities(J2KFunctions.readParas((String)(this.dirName.getValue() + "/" + tok.nextToken()), (JAMSModel)this.getModel()));
        }
        FlowData[N] = new JAMSEntityCollection();
        FlowData[N].setEntities(J2KFunctions.readParas((String)(this.dirName.getValue() + "/" + this.ScenarioISTFileName.getValue()), (JAMSModel)this.getModel()));
        HashMap<Double, JAMSEntity[]> fdMap = new HashMap<Double, JAMSEntity[]>();
        for (int i = 0; i < N + 1; ++i) {
            for (JAMSEntity fd : FlowData[i].getEntities()) {
                field_fd = (JAMSEntity[])fdMap.get(fd.getDouble("ID"));
                if (field_fd == null) {
                    field_fd = new JAMSEntity[N + 1];
                    fdMap.put(fd.getDouble("ID"), field_fd);
                }
                field_fd[i] = fd;
            }
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            field_fd = (JAMSEntity[])fdMap.get(e.getDouble("ID"));
            if (field_fd == null) continue;
            Matrix M = new Matrix(N, 2);
            double interflow = 0.0;
            double percolation = 0.0;
            for (int i = 0; i < N; ++i) {
                interflow += field_fd[i].getDouble("sinterflowN_2000") + field_fd[i].getDouble("SurfaceN_2000");
                percolation += field_fd[i].getDouble("PercoN_2000");
            }
            double ratio_interflow = (interflow /= (double)N) / (interflow + (percolation /= (double)N));
            double ratio_percolation = 1.0 - ratio_interflow;
            for (int j = 0; j < N; ++j) {
                M.element[j][0] = field_fd[j].getDouble("sum_Ninput_2000");
                M.element[j][1] = field_fd[j].getDouble("sinterflowN_2000") + field_fd[j].getDouble("SurfaceN_2000") + field_fd[j].getDouble("PercoN_2000");
            }
            LinApprox lin = new LinApprox(M);
            GenericFunction gen = new GenericFunction(lin);
            e.setObject("ActivationFunction", (Object)gen);
            e.setDouble("new_input", -1.0);
            e.setDouble("interflow_weight", ratio_interflow);
            e.setDouble("percolation_weight", ratio_percolation);
            e.setDouble("ist_input", field_fd[N].getDouble("sum_Ninput_2000"));
            e.setDouble("min_input", field_fd[0].getDouble("sum_Ninput_2000"));
        }
        this.getModel().getRuntime().println("NitrogenFlow parameter file processed ...", 1);
    }
}

