/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import org.unijena.hydronet.Neuron;

public class CostNeuron
extends Neuron {
    private static double costFactor = 1.0E-4;
    private Neuron outputNeuron = null;
    private double initialInput;

    public void setOutputNeuron(Neuron dsNeuron) {
        this.outputNeuron = dsNeuron;
    }

    @Override
    public void addToInput(double value) {
        this.input += value;
    }

    public static void setCostFactor(double costFactor) {
    }

    public static double getCostFactor() {
        return costFactor;
    }

    public void setInitialInput(double initialWeight) {
        this.initialInput = initialWeight;
    }

    public double getInitialInput() {
        return this.initialInput;
    }

    public void propagate() {
        this.calc();
        this.input = 0.0;
        if (this.outputNeuron != null) {
            this.outputNeuron.addToInput(this.activation);
        }
    }

    public void backpropagate() {
        this.calcDelta(this.outputNeuron.getDelta());
    }

    public double calc() {
        this.lastInput = this.input;
        if (this.ActivationFunctions.size() == 0) {
            this.activation = 0.0;
            return 0.0;
        }
        if (this.initialInput == 0.0) {
            if (this.lastInput != 0.0) {
                this.initialInput = this.input;
            } else {
                this.activation = 0.0;
                return 0.0;
            }
        }
        double adaptvalue = this.lastInput / this.initialInput;
        this.activation = this.calc(adaptvalue) * this.sizeOfArea * costFactor;
        return this.activation;
    }

    public double calcDelta(double error) {
        return this.calcDelta(error, 1.0);
    }

    public double calcDelta(double error, double buffer) {
        if (this.ActivationFunctions.size() == 0) {
            return 0.0;
        }
        if (this.initialInput == 0.0) {
            if (this.lastInput != 0.0) {
                this.initialInput = this.lastInput;
            } else {
                this.delta = 0.0;
                return 0.0;
            }
        }
        double adaptvalue = this.lastInput / this.initialInput;
        this.delta = this.calcDelta(adaptvalue, error, 1.0) * this.sizeOfArea * costFactor;
        return this.delta;
    }
}

