/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import org.unijena.j2k.statistics.IDW;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcNidwWeights", author="Peter Krause", description="Calculates weights for the regionalisation procedure")
public class CalcNidwWeights
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity x-coordinate")
    public JAMSDouble entityX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="entity y-coordinate")
    public JAMSDouble entityY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's x coordinates")
    public JAMSDoubleArray statX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's y coordinates")
    public JAMSDoubleArray statY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of IDW stations")
    public JAMSInteger nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Power of IDW function")
    public JAMSDouble pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="weights for IDW part of regionalisation")
    public JAMSDoubleArray statWeights = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Doug Boyle's famous function")
    public JAMSBoolean equalWeights;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSDoubleArray idwWeights = new JAMSDoubleArray();
        if (this.equalWeights == null || !this.equalWeights.getValue()) {
            idwWeights.setValue(IDW.calcNidwWeights(this.entityX.getValue(), this.entityY.getValue(), this.statX.getValue(), this.statY.getValue(), this.pidw.getValue(), this.nidw.getValue()));
        } else if (this.equalWeights.getValue()) {
            idwWeights.setValue(IDW.equalWeights(this.nidw.getValue()));
        }
        this.statWeights.setValue(idwWeights.getValue());
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
        int nstat = this.statWeights.getValue().length;
        double[] sw = new double[nstat];
        for (int i = 0; i < nstat; ++i) {
            sw[i] = 0.0;
        }
        this.statWeights.setValue(sw);
    }
}

