/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcDailyETP_PenmanMonteith", author="Peter Krause", description="Calculates potential ETP after Penman-Monteith")
public class RefET
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="temporal resolution [d | h | m]")
    public JAMSString tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable wind")
    public JAMSDouble wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable mean temperature")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable relative humidity")
    public JAMSDouble rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable net radiation")
    public JAMSDouble netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute elevation")
    public JAMSDouble elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="potential refET [mm/ timeUnit]")
    public JAMSDouble refET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual ET [mm/ timeUnit]")
    public JAMSDouble actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;
    private File cacheFile;
    private boolean useCache = false;
    private ObjectOutputStream writer;
    private ObjectInputStream reader;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
        this.cacheFile = new File(this.dirName.getValue() + "/$" + this.getInstanceName() + ".cache");
        if (!this.cacheFile.exists() && this.dataCaching.getValue()) {
            this.getModel().getRuntime().sendHalt(this.getInstanceName() + ": dataCaching is true but no cache file available!");
        }
        if (this.dataCaching.getValue()) {
            this.useCache = true;
            this.reader = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
        } else {
            this.useCache = false;
            this.writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException, IOException {
        if (!this.useCache) {
            double netRad = this.netRad.getValue();
            double temperature = this.tmean.getValue();
            double rhum = this.rhum.getValue();
            double wind = this.wind.getValue();
            double elevation = this.elevation.getValue();
            double area = this.area.getValue();
            double rs = 70.0;
            double ra = 208.0 / wind;
            double abs_temp = ClimatologicalVariables.calc_absTemp(temperature, "degC");
            double delta_s = ClimatologicalVariables.calc_slopeOfSaturationPressureCurve(temperature);
            double pz = ClimatologicalVariables.calc_atmosphericPressure(elevation, abs_temp);
            double est = ClimatologicalVariables.calc_saturationVapourPressure(temperature);
            double ea = ClimatologicalVariables.calc_vapourPressure(rhum, est);
            double latH = ClimatologicalVariables.calc_latentHeatOfVaporization(temperature);
            double psy = ClimatologicalVariables.calc_psyConst(pz, latH);
            double G = this.calc_groundHeatFlux(netRad);
            double tempFactor = 0.0;
            double pET = 0.0;
            double aET = 0.0;
            if (this.tempRes.getValue().equals("d")) {
                tempFactor = 891.0;
            } else if (this.tempRes.getValue().equals("h")) {
                tempFactor = 37.0;
            } else if (this.tempRes.getValue().equals("m")) {
                tempFactor = 891.0;
            }
            pET = (0.408 * delta_s * (netRad - G) + psy * (tempFactor / (temperature + 273.0)) * wind * (est - ea)) / (delta_s + psy * (1.0 + 0.34 * wind));
            pET *= area;
            if (this.time != null && this.tempRes.getValue().equals("m")) {
                int daysInMonth = this.time.getActualMaximum(5);
                pET *= (double)daysInMonth;
            }
            if (pET < 0.0) {
                pET = 0.0;
            }
            this.refET.setValue(pET);
            this.actET.setValue(aET);
            this.writer.writeDouble(pET);
        } else {
            this.refET.setValue(this.reader.readDouble());
        }
    }

    public void cleanup() throws IOException {
        if (!this.useCache) {
            this.writer.flush();
            this.writer.close();
        } else {
            this.reader.close();
        }
    }

    private double calcETAllen(double ds, double netRad, double G, double pa, double CP, double est, double ea, double ra, double rs, double psy, double tempFactor) {
        double Letp = ((ds /= 10.0) * (netRad - G) + pa * (CP /= 1000.0) * ((est /= 10.0) - (ea /= 10.0)) / ra * tempFactor) / (ds + (psy /= 10000.0) * (1.0 + rs / ra));
        return Letp;
    }

    private double calc_groundHeatFlux(double netRad) {
        double g = 0.1 * netRad;
        return g;
    }

    private static double calcRa(double eff_height, double wind_speed) {
        if (wind_speed <= 0.0) {
            wind_speed = 0.5;
        }
        double ra = eff_height < 10.0 ? 1.5 * Math.pow(Math.log(2.0 / (0.125 * eff_height)), 2.0) / (Math.pow(0.41, 2.0) * wind_speed) : 64.0 / (Math.pow(0.41, 2.0) * wind_speed);
        return ra;
    }

    private double calcRs(double LAI, double rsc, double rss) {
        double A = Math.pow(0.7, LAI);
        double rs = 1.0 / ((1.0 - A) / rsc + A / rss);
        return rs;
    }
}

