/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcDailyETP_Haude", author="Peter Krause", description="Calculates daily potential ETP after Penman-Monteith")
public class CalcDailyETP_Haude
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="state variable mean temperature")
    public JAMSString aNameTmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="state variable relative humidity")
    public JAMSString aNameRhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="state variable haude factor")
    public JAMSString aNameHaudeFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="attribute area")
    public JAMSString aNameArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="daily potential ETP [mm/d]")
    public JAMSString aNamePotETP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="daily actual ETP [mm/d]")
    public JAMSString aNameActETP;
    private File cacheFile;
    private boolean useCache = false;
    private ObjectOutputStream writer;
    private ObjectInputStream reader;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
        this.cacheFile = new File(this.dirName.getValue() + "/$" + this.getInstanceName() + ".cache");
        if (this.cacheFile.exists()) {
            // empty if block
        }
        this.useCache = false;
        this.writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
    }

    public void run() throws JAMSEntity.NoSuchAttributeException, IOException {
        if (!this.useCache) {
            int month = this.time.get(2) + 1;
            double temperature = this.entity.getDouble(this.aNameTmean.getValue());
            double rhum = this.entity.getDouble(this.aNameRhum.getValue());
            double area = this.entity.getDouble(this.aNameArea.getValue());
            String hFactStr = this.aNameHaudeFactor.getValue() + month;
            double h_factor = this.entity.getDouble(hFactStr);
            double est = ClimatologicalVariables.calc_saturationVapourPressure(temperature);
            est = 10.0 * est;
            double pETP = est * (1.0 - rhum / 100.0) * h_factor;
            double aETP = 0.0;
            if ((pETP *= area) < 0.0) {
                pETP = 0.0;
            }
            this.entity.setDouble(this.aNamePotETP.getValue(), pETP /= 24.0);
            this.writer.writeDouble(pETP);
            this.entity.setDouble(this.aNameActETP.getValue(), aETP);
        } else {
            this.entity.setDouble(this.aNamePotETP.getValue(), this.reader.readDouble());
            this.entity.setDouble(this.aNameActETP.getValue(), 0.0);
        }
    }

    public void cleanup() throws IOException {
        if (!this.useCache) {
            this.writer.flush();
            this.writer.close();
        } else {
            this.reader.close();
        }
    }
}

