/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_salt;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KsaltRoutinglayer", author="Peter Krause & Manfred Fink", description="Passes the NaCl output of the entities as NaCl input to the respective reach or unit")
public class J2KsaltRoutinglayer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of reach objects")
    public JAMSEntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RD1 NaCl inflow in kgNaCl")
    public JAMSDouble SurfaceNaCl_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RD2 NaCl inflow in kgNaCl")
    public JAMSDoubleArray InterflowNaCl_in = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG1 NaCl inflow in kgNaCl")
    public JAMSDouble NaCl_RG1_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG2 NaCl inflow in kgNaCl")
    public JAMSDouble NaCl_RG2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RD1 NaCl outflow in kgNaCl")
    public JAMSDouble SurfaceNaClabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RD2 NaCl outflow in kgNaCl")
    public JAMSDoubleArray InterflowNaClabs = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG1 N outflow in kgNaCl")
    public JAMSDouble NaCl_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG2 N outflow in kgNaCl")
    public JAMSDouble NaCl_RG2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="gwExcess")
    public JAMSDouble NaClExcess;
    double[][] fracOut;
    double[] percNOut;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity entity = this.entities.getCurrent();
        JAMSEntity toPoly = (JAMSEntity)entity.getObject("to_poly");
        JAMSEntity toReach = (JAMSEntity)entity.getObject("to_reach");
        double NRD1out = this.SurfaceNaClabs.getValue();
        double[] NRD2out_h = this.InterflowNaClabs.getValue();
        double NRG1out = this.NaCl_RG1_out.getValue();
        double NRG2out = this.NaCl_RG2_out.getValue();
        double reachNRD2in = 0.0;
        if (toPoly != null) {
            double[] srcDepth = ((JAMSDoubleArray)entity.getObject("depth_h")).getValue();
            double[] recDepth = ((JAMSDoubleArray)toPoly.getObject("depth_h")).getValue();
            int srcHors = srcDepth.length;
            int recHors = recDepth.length;
            double[] NRD2in_h = new double[recHors];
            double NRD1in = toPoly.getDouble("SurfaceNaCl_in");
            double[] rdArN = ((JAMSDoubleArray)toPoly.getObject("InterflowNaCl_in")).getValue();
            double NRG1in = toPoly.getDouble("NaCl_RG1_in");
            double NRG2in = toPoly.getDouble("NaCl_RG2_in");
            for (int j = 0; j < recHors; ++j) {
                NRD2in_h[j] = rdArN[j];
                for (int i = 0; i < srcHors; ++i) {
                    NRD2in_h[j] = NRD2in_h[j] + NRD2out_h[i] / (double)recHors;
                }
            }
            for (int i = 0; i < srcHors; ++i) {
                NRD2out_h[i] = 0.0;
            }
            int n = recHors - 1;
            NRD2in_h[n] = NRD2in_h[n] + this.NaClExcess.getValue();
            double RD1in = toPoly.getDouble("inRD1");
            double RG2in = toPoly.getDouble("inRG2");
            NRD1in += NRD1out;
            NRG1in += NRG1out;
            NRG2in += NRG2out;
            NRD1out = 0.0;
            NRG1out = 0.0;
            NRG2out = 0.0;
            this.SurfaceNaClabs.setValue(0.0);
            this.InterflowNaClabs.setValue(NRD2out_h);
            this.NaCl_RG1_out.setValue(0.0);
            this.NaCl_RG2_out.setValue(0.0);
            this.NaClExcess.setValue(0.0);
            JAMSDoubleArray rdAN = (JAMSDoubleArray)toPoly.getObject("InterflowNaCl_in");
            rdAN.setValue(NRD2in_h);
            toPoly.setDouble("SurfaceNaCl_in", NRD1in);
            toPoly.setObject("InterflowNaCl_in", (Object)rdAN);
            toPoly.setDouble("NaCl_RG1_in", NRG1in);
            toPoly.setDouble("NaCl_RG2_in", NRG2in);
        } else if (toReach != null) {
            double NRD1in = toReach.getDouble("SurfaceNaCl_in");
            reachNRD2in = toReach.getDouble("InterflowNaCl_sum");
            double NRG1in = toReach.getDouble("NaCl_RG1_in");
            double NRG2in = toReach.getDouble("NaCl_RG2_in");
            for (int h = 0; h < NRD2out_h.length; ++h) {
                reachNRD2in += NRD2out_h[h];
                NRD2out_h[h] = 0.0;
            }
            NRD1in += NRD1out;
            reachNRD2in += this.NaClExcess.getValue();
            NRG1in += NRG1out;
            NRG2in += NRG2out;
            NRD1out = 0.0;
            NRG1out = 0.0;
            NRG2out = 0.0;
            this.NaClExcess.setValue(0.0);
            this.SurfaceNaClabs.setValue(0.0);
            toReach.setDouble("SurfaceNaCl_in", NRD1in);
            this.InterflowNaClabs.setValue(NRD2out_h);
            toReach.setDouble("InterflowNaCl_sum", reachNRD2in);
            this.NaCl_RG1_out.setValue(NRG1out);
            toReach.setDouble("NaCl_RG1_in", NRG1in);
            this.NaCl_RG2_out.setValue(NRG2out);
            toReach.setDouble("NaCl_RG2_in", NRG2in);
        } else {
            System.out.println("Current entity ID: " + entity.getInt("ID") + " has no receiver.");
        }
    }

    public void cleanup() {
    }
}

