/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.init;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitJ2KGroundwaterN", author="Manfred Fink", description="intitiallizing groundwater N module with two different N-Pools")
public class InitJ2KGroundwaterN
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG1 storage")
    public JAMSDouble maxRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG2 storage")
    public JAMSDouble maxRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG1 N storage in kgN")
    public JAMSDouble NActRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG2 N storage in kgN")
    public JAMSDouble NActRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU Concentration in mgN/l for RG1")
    public JAMSDouble N_concRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU Concentration in mgN/l for RG2")
    public JAMSDouble N_concRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Relativ size of the groundwaterN damping tank RG1 0 - 10 to calibrate in -")
    public JAMSDouble N_delay_RG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Relativ size of the groundwaterN damping tank RG2 0 - 10 to calibrate in -")
    public JAMSDouble N_delay_RG2;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double iNActRG1 = this.maxRG1.getValue() * this.N_concRG1.getValue() / 1000000.0 * this.N_delay_RG1.getValue();
        double iNActRG2 = this.maxRG2.getValue() * this.N_concRG2.getValue() / 1000000.0 * this.N_delay_RG2.getValue();
        this.NActRG1.setValue(iNActRG1);
        this.NActRG2.setValue(iNActRG2);
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

