/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.crop;

import java.io.IOException;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="j2kCropGrowth", author="Ulrike Bende-Michl", description="Module for calculation of crop growth according to the algorithms of SWAT")
public class j2kCropGrowth
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT)
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU attribute name area")
    public JAMSDouble Area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU crop class")
    public JAMSDouble LClass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU daily mean temperature [\u00c2\u00b0C]")
    public JAMSDouble Tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU plant temperature [\u00c2\u00b0C]")
    public JAMSDouble Tbase;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU daily potential heat units")
    public JAMSDouble PHUact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU daily zero based heat units")
    public JAMSDouble HU0act;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU fraction daily potential heat units")
    public JAMSDouble FPHUact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU fraction daily zero based potential heat units")
    public JAMSDouble FHU0act;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU half of annual potential heat units")
    public JAMSDouble PHU_50;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Max LAI corresponding to the first point of the optimal LAI development")
    public JAMSDouble MLAI1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Max LAI corresponding to the second point of the optimal LAI development")
    public JAMSDouble MLAI2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Maximimum LAI")
    public JAMSDouble MLAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Actual LAI for a given day [-]")
    public JAMSDouble LAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Fraction of growing season corresponding to the first point of the optimal LAI development")
    public JAMSDouble FrcGrow1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Fraction of growing season corresponding to the second point of the optimal LAI development")
    public JAMSDouble FrcGrow2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Daily solar radiation [MJ/m\u00c2\u00b2]")
    public JAMSDouble SolRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Crop specific radiation use efficiency ([kg/ha] drymass per[MJm\u00c2\u00b2])")
    public JAMSDouble RadUse;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Intercepted photosynthetically active radiation [MJ/m\u00c2\u00b2]")
    public JAMSDouble Hphosyn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Biomass sum produced for a given day [kg/ha] drymass")
    public JAMSDouble BioAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Canopy Height [m]")
    public JAMSDouble CanHeight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Maximum Canopy Height [m]")
    public JAMSDouble MCanHeight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Maximum rooting depth [mm]")
    public JAMSDouble MRootD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Actual rooting depth [mm]")
    public JAMSDouble ZRootD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Normal fraction of N in the plant biomass at the emergence")
    public JAMSDouble Nuptake_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Normal fraction of N in the plant biomass at 50% of maturity")
    public JAMSDouble Nuptake_2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Normal fraction of N in the plant biomass at maturity")
    public JAMSDouble Nuptake_3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Optimal fraction of nitrogen in the plant biomass at the current growth's stage")
    public JAMSDouble FNPlant;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Optimal plant nitrogen content in the plants biomass for a given day")
    public JAMSDouble BioNopt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Plants nitrogen demand for a given day")
    public JAMSDouble BioNdem;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Actual nitrogen stored in the plants biomass for a given day")
    public JAMSDouble BioNact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Harvest Index [0-1]")
    public JAMSDouble HarvIndex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Fraction of harvest")
    public JAMSDouble FracHarv;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Lower boundary of harvest index [0-1]")
    public JAMSDouble LHarIndex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Biomass above ground on the day of harvest [kg/ha]")
    public JAMSDouble BioagAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Fraction N in Yield")
    public JAMSDouble CNyld;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Residuen pool (biomass)")
    public JAMSDouble Residue_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU actual Transpiration [mm]")
    public JAMSDouble aTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU potential Transpiration [mm]")
    public JAMSDouble pTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Light Extinct Coefficient [-0.65]")
    public JAMSDouble LExCoef;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Initial Leaf Area Index [-]")
    public JAMSDouble ILAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Optimal daily biomass development [kg/ha]")
    public JAMSDouble BioOpt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Actual daily Canopy Height [m]")
    public JAMSDouble CanHeightAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Actual N content in plants biomass [kg N/ha]")
    public JAMSDouble BioNoptAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="Actual plants N demand [kg N/ha]")
    public JAMSDouble PlantNDemAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Daily fraction of max LAI [-]")
    public JAMSDouble frLAImxAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Daily fraction of max root development [-]")
    public JAMSDouble frRootAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Actual yield [kg/ha]")
    public JAMSDouble BioYield;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Actual N content in yield [absolut]")
    public JAMSDouble NYield;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Actual N content in yield [kg N/ha]")
    public JAMSDouble NYield_ha;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="N distribution factor")
    public JAMSDouble BetaN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Actual N in Biomass (after Stress)")
    public JAMSDouble BioNAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    private double area_ha;
    private double sc1_LAI;
    private double sc2_LAI;
    private double sc3_Nbio;
    private double sc4_Nbio;
    private double frLAImx_act;
    private double lai_act;
    private double fnplant_act;
    private double residue_pool;
    private double hc_act;
    private double idc;
    private double phu_50;
    private double phu;
    private double fphu_act;
    private double aTransP;
    private double pTransP;
    private double int_lai;
    private double mlai1;
    private double mlai;
    private double mlai2;
    private double frgrw1;
    private double frgrw2;
    private double frLAImx;
    private double solrad;
    private double raduse;
    private double leco;
    private double chtmx;
    private double rdmx;
    private double frroot_act;
    private double zrootd_act;
    private double bn1;
    private double bn2;
    private double bn3;
    private double betaN;
    private double hvsti;
    private double cnyld;
    private double Ndemand_act;
    private double bioNopt_act;
    private double bioN_act;
    private double bio_act;
    private double bio_opt;
    private double bioopt_ha;
    private double hi_act;
    private double bioag_act;
    private double yldN;
    private double yldN_ha;
    private double yield;
    private double tmean;
    private double tbase;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        this.phu = this.PHUact.getValue();
        this.phu_50 = this.PHU_50.getValue();
        this.fphu_act = this.FPHUact.getValue();
        this.aTransP = this.aTP.getValue();
        this.pTransP = this.pTP.getValue();
        this.idc = this.LClass.getValue();
        this.mlai1 = this.MLAI1.getValue();
        this.mlai2 = this.MLAI2.getValue();
        this.mlai = this.MLAI.getValue();
        this.int_lai = this.ILAI.getValue();
        this.frgrw1 = this.FrcGrow1.getValue();
        this.frgrw2 = this.FrcGrow2.getValue();
        this.solrad = this.SolRad.getValue();
        this.raduse = this.RadUse.getValue();
        this.leco = this.LExCoef.getValue();
        this.chtmx = this.MCanHeight.getValue();
        this.rdmx = this.MRootD.getValue();
        this.bn1 = this.Nuptake_1.getValue();
        this.bn2 = this.Nuptake_2.getValue();
        this.bn3 = this.Nuptake_3.getValue();
        this.betaN = this.BetaN.getValue();
        this.hvsti = this.HarvIndex.getValue();
        this.cnyld = this.CNyld.getValue();
        this.bioN_act = this.BioNAct.getValue();
        this.lai_act = this.LAI.getValue();
        this.frLAImx_act = this.frLAImxAct.getValue();
        this.hc_act = this.CanHeightAct.getValue();
        this.frroot_act = this.frRootAct.getValue();
        this.zrootd_act = this.ZRootD.getValue();
        this.fnplant_act = this.FNPlant.getValue();
        this.bioNopt_act = this.BioNoptAct.getValue();
        this.Ndemand_act = this.PlantNDemAct.getValue();
        this.bioN_act = this.BioNAct.getValue();
        this.hi_act = this.HarvIndex.getValue();
        this.bioag_act = this.BioagAct.getValue();
        this.area_ha = this.Area.getValue() / 10000.0;
        this.tbase = this.Tbase.getValue();
        this.tmean = this.Tmean.getValue();
        this.calc_lai();
        this.bio_act = this.calc_biomass();
        this.hc_act = this.calc_canopy();
        this.calc_root();
        this.calc_maturity();
        this.calc_nuptake();
        this.calc_cropyield();
        this.calc_cropyield_ha();
        this.frLAImxAct.setValue(this.frLAImx_act);
        this.LAI.setValue(this.lai_act);
        this.BioOpt.setValue(this.bio_opt);
        this.BioOpt.setValue(this.bio_opt * this.area_ha);
        this.CanHeightAct.setValue(this.hc_act);
        this.frRootAct.setValue(this.frroot_act);
        this.ZRootD.setValue(this.zrootd_act);
        this.FNPlant.setValue(this.fnplant_act);
        this.BioNoptAct.setValue(this.bioNopt_act);
        this.BioAct.setValue(this.bio_act);
        this.PlantNDemAct.setValue(this.Ndemand_act);
        this.HarvIndex.setValue(this.hi_act);
        this.BioagAct.setValue(this.bioag_act);
        this.BioYield.setValue(this.yield);
        this.NYield.setValue(this.yldN);
        this.NYield_ha.setValue(this.yldN_ha);
    }

    private boolean calc_lai() throws JAMSEntity.NoSuchAttributeException {
        double frLAImx;
        this.sc2_LAI = (Math.log(this.frgrw1 / this.mlai1) - this.frgrw1 - (Math.log(this.frgrw2 / this.mlai2) - this.frgrw2)) / (this.frgrw2 - this.frgrw1);
        this.sc1_LAI = Math.log(this.frgrw1 / this.mlai1 - this.frgrw1) + this.sc2_LAI * this.frgrw1;
        double frLAImx_xi = frLAImx = this.fphu_act / (this.fphu_act + Math.exp(this.sc1_LAI - this.sc2_LAI * this.fphu_act));
        this.frLAImx_act = frLAImx + this.frLAImx_act;
        double LAI_init = this.int_lai;
        double LAI_delta1 = (this.frLAImx_act - frLAImx_xi) * this.mlai * (1.0 - Math.exp(5.0 * (LAI_init - this.mlai)));
        this.lai_act = LAI_delta1 + this.lai_act;
        double fphu_sense = 0.75;
        if (this.fphu_act > fphu_sense) {
            this.lai_act = 16.0 * this.mlai * Math.pow(1.0 - this.fphu_act, 2.0);
        }
        return true;
    }

    private double calc_biomass() throws JAMSEntity.NoSuchAttributeException {
        double bio_opt = 0.0;
        double Hphosyn = 0.5 * this.solrad * (1.0 - Math.exp(this.leco * this.lai_act));
        double bio_opt_delta = this.raduse * Hphosyn;
        bio_opt = bio_opt_delta + bio_opt;
        return bio_opt;
    }

    private double calc_canopy() throws JAMSEntity.NoSuchAttributeException {
        double hc_delta = 0.0;
        double frLAImx_act = 0.0;
        hc_delta = this.chtmx * Math.sqrt(frLAImx_act);
        double hc_act = hc_delta + this.hc_act;
        return hc_act;
    }

    private boolean calc_root() throws JAMSEntity.NoSuchAttributeException {
        double zrootd_act;
        double frroot_act = 0.0;
        double frroot = 0.4 - 0.2 * this.fphu_act;
        frroot_act = frroot + frroot_act;
        if (this.idc == 3.0 || this.idc == 6.0 || this.idc == 7.0) {
            zrootd_act = this.rdmx;
        }
        zrootd_act = 0.0;
        if (this.idc == 1.0 || this.idc == 2.0 || this.idc == 4.0 || this.idc == 5.0 && this.fphu_act <= 0.4) {
            double zrootd = 2.5 * this.fphu_act * this.rdmx;
            zrootd_act = zrootd + zrootd_act;
        }
        if (this.fphu_act > 0.4) {
            zrootd_act = this.rdmx;
        }
        return true;
    }

    private boolean calc_maturity() throws JAMSEntity.NoSuchAttributeException {
        if (this.fphu_act >= 1.0) {
            this.aTransP = 0.0;
            double Nup_act = 0.0;
            double d = 0.0;
        }
        return true;
    }

    private boolean calc_nuptake() throws JAMSEntity.NoSuchAttributeException {
        double fnplant_act = 0.0;
        double bioNopt_act = 0.0;
        double Ndemand_act = 0.0;
        double frn_sub1 = this.bn1 - this.bn3;
        double frn_sub2 = this.bn2 - this.bn3;
        double bn3_ca = this.bn3 - 1.0E-5;
        double frn_sub3 = bn3_ca - this.bn3;
        double sc4_Nbio = (Math.log(this.phu_50 / (1.0 - frn_sub2 / frn_sub1) - this.phu_50) - Math.log(this.phu / (1.0 - frn_sub3 / frn_sub1))) / this.phu - this.phu_50;
        double sc3_Nbio = Math.log(this.phu_50 / (1.0 - frn_sub2 / frn_sub1 - this.phu_50) + sc4_Nbio * this.phu_50);
        double fnplant = (this.bn1 - this.bn3) * (1.0 - (this.fphu_act / this.fphu_act + Math.exp(sc3_Nbio - sc4_Nbio * this.fphu_act))) + this.bn3;
        fnplant_act = fnplant + fnplant_act;
        double bioNopt = fnplant_act * this.bio_opt;
        bioNopt_act = bioNopt + bioNopt_act;
        double Ndemand = bioNopt_act - this.bioN_act;
        Ndemand_act = Ndemand + Ndemand_act;
        this.zrootd_act = 0.0;
        double Nup_layer = 0.0;
        if (this.betaN == 1.0) {
            Nup_layer = this.zrootd_act;
        } else if (this.betaN > 1.0) {
            Nup_layer = this.betaN / this.zrootd_act * 100.0;
        } else if (this.betaN == 0.0) {
            Nup_layer = 0.1;
            double Nup_depth = Ndemand_act / (1.0 - Math.exp(-this.betaN)) * (1.0 - Math.exp(-this.betaN * this.rdmx / this.zrootd_act));
        }
        return true;
    }

    private boolean calc_cropyield() throws JAMSEntity.NoSuchAttributeException {
        double yield;
        this.hi_act = 0.0;
        this.bioag_act = 0.0;
        this.frroot_act = 0.0;
        double hi = this.hvsti * (100.0 * this.fphu_act) / (100.0 * this.fphu_act + Math.exp(11.1 - 10.0 * this.fphu_act));
        this.hi_act = hi + this.hi_act;
        double bio_ag = (1.0 - this.frroot_act) * this.bio_opt;
        this.bioag_act = bio_ag + this.bioag_act;
        if (this.fphu_act >= 1.0) {
            double bioag_harvest = this.bioag_act;
        }
        if (this.hi_act <= 1.0 || this.fphu_act >= 1.0) {
            yield = this.bioag_act * this.hi_act;
        } else if (this.hi_act > 1.0 || this.fphu_act >= 1.0) {
            yield = this.bio_opt * (1.0 - 1.0 / (1.0 + this.hi_act));
        }
        yield = 0.0;
        double yldN = this.cnyld * yield;
        return true;
    }

    private double calc_cropyield_ha() throws JAMSEntity.NoSuchAttributeException {
        this.yldN_ha = this.yldN * this.area_ha / 10000.0;
        return this.yldN_ha;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

