/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KNSoil", author="Manfred Fink", description="Calculates Nitrogen transformation Processes in Soil. Method after SWAT2000")
public class J2KNSoil
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute name area in m\u00c2\u00b2")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in mm depth of soil layer")
    public JAMSDouble layerdepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in mm depth of soil profile")
    public JAMSDouble totaldepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="in kg/dm\u00c2\u00b3 soil bulk density")
    public JAMSDouble soil_bulk_density;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual LPS in portion of sto_LPS soil water content")
    public JAMSDouble sat_LPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual MPS in portion of sto_MPS soil water content")
    public JAMSDouble sat_MPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum MPS  in l soil water content")
    public JAMSDouble stohru_MPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum LPS  in l soil water content")
    public JAMSDouble stohru_LPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum FPS  in l soil water content")
    public JAMSDouble stohru_FPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="soil temperature in layerdepth in \u00c2\u00b0C")
    public JAMSDouble Soil_Temp_Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of state variables LAI ")
    public JAMSDoubleArray LAIArray = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" in % organic Carbon in soil")
    public JAMSDouble C_org;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NO3-Pool in kgN/ha")
    public JAMSDouble NO3_Pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NH4-Pool in kgN/ha")
    public JAMSDouble NH4_Pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic Pool with reactive organic matter in kgN/ha")
    public JAMSDouble N_activ_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic Pool with stable organic matter in kgN/ha")
    public JAMSDouble N_stabel_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Residue in Layer in kgN/ha")
    public JAMSDouble Residue_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic fresh Pool from Residue in kgN/ha")
    public JAMSDouble N_residue_pool_fresh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" actual evaporation in mm")
    public JAMSDouble aEvap;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" surface runoff in l")
    public JAMSDouble RD1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" interflow in l")
    public JAMSDouble RD2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" percolation in l")
    public JAMSDouble D_perco;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" voltalisation rate from NH4_Pool in kgN/ha")
    public JAMSDouble Volati_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NH4 fertilizer rate in kgN/ha")
    public JAMSDouble NH4inp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" plantuptake rate in kgN/ha")
    public JAMSDouble PlantupN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" nitrification rate from  NO3_Pool in kgN/ha")
    public JAMSDouble Nitri_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" denitrification rate from  NO3_Pool in kgN/ha")
    public JAMSDouble Denit_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff in  in kgN/ha")
    public JAMSDouble SurfaceN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in  in kgN/ha")
    public JAMSDouble InterflowN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in percolation in  in kgN/ha")
    public JAMSDouble PercoN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff in  in kgN")
    public JAMSDouble SurfaceNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in  in kgN")
    public JAMSDouble InterflowNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in percolation in  in kgN")
    public JAMSDouble PercoNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff added to HRU layer in in kgN")
    public JAMSDouble SurfaceN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in added to HRU layer in kgN")
    public JAMSDouble InterflowN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in percolation in added to HRU layer in kgN")
    public JAMSDouble PercoN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" rate constant between N_activ_pool and N_stabel_pool = 0.00001")
    public JAMSDouble Beta_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" rate factor between N_activ_pool and NO3_Pool to be calibrated 0.001 - 0.003")
    public JAMSDouble Beta_min;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" rate factor between Residue_pool and NO3_Pool to be calibrated 0.1 - 0.02")
    public JAMSDouble Beta_rsd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" percolation coefitient to calibrate = 0.2")
    public JAMSDouble Beta_NO3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" net precipitation in mm")
    public JAMSDouble NetPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" actual Transpiration in mm")
    public JAMSDouble aTransp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    private double gamma_temp;
    private double gamma_water;
    private double runarea;
    private double runSoil_Temp_Layer;
    private double runlayerdepth;
    private double runsoil_bulk_density;
    private double sto_MPS;
    private double sto_LPS;
    private double sto_FPS;
    private double act_LPS;
    private double act_MPS;
    private double runnetPrecip;
    private double runLAI;
    private double runC_org;
    private double runNO3_Pool;
    private double runNH4_Pool;
    private double runN_activ_pool;
    private double runN_stabel_pool;
    private double runN_residue_pool_fresh;
    private double runResidue_pool;
    private double runaEvap;
    private double RD1_out_mm;
    private double RD2_out_mm;
    private double d_perco_mm;
    private int layer;
    private double runvolati_trans;
    private double runNH4inp;
    private double runplantupN;
    private double rundenit_trans;
    private double runsurfaceN;
    private double runinterflowN;
    private double runpercoN;
    private double runsurfaceNabs;
    private double runinterflowNabs;
    private double runpercoNabs;
    private double runsurfaceN_in;
    private double runinterflowN_in;
    private double runpercoN_in;
    private double runBeta_trans;
    private double runBeta_min;
    private double runBeta_rsd;
    private double runBeta_NO3;
    private double runaTransp;
    private boolean precalc_nit_vol;
    private double theta_nit = 0.05;
    private double fr_actN = 0.02;
    private double N_nit_vol = 0.0;
    private double frac_nitr = 0.0;
    private double frac_vol = 0.0;
    private double Hum_trans;
    private double Hum_act_min;
    private double runnitri_trans = 0.0;
    private double delta_ntr = 0.0;
    private double concN_mobile = 0.0;
    private int datumjul = 0;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int day = this.time.get(6) - 1;
        int i = 1;
        this.gamma_temp = 0.0;
        this.gamma_water = 0.0;
        this.runarea = this.area.getValue();
        this.runSoil_Temp_Layer = this.Soil_Temp_Layer.getValue();
        this.runlayerdepth = this.layerdepth.getValue() * 100.0;
        this.sto_MPS = this.stohru_MPS.getValue() / this.runarea;
        this.sto_LPS = this.stohru_LPS.getValue() / this.runarea;
        this.sto_FPS = this.sto_MPS * 0.3;
        this.act_LPS = this.sat_LPS.getValue() * this.sto_LPS;
        this.act_MPS = this.sat_MPS.getValue() * this.sto_MPS;
        this.runnetPrecip = this.NetPrecip.getValue();
        this.runLAI = this.LAIArray.getValue()[day];
        this.runC_org = this.C_org.getValue();
        this.runNO3_Pool = this.NO3_Pool.getValue();
        this.runNH4_Pool = this.NH4_Pool.getValue();
        this.runN_activ_pool = this.N_activ_pool.getValue();
        this.runN_stabel_pool = this.N_stabel_pool.getValue();
        this.runN_residue_pool_fresh = this.N_residue_pool_fresh.getValue();
        this.runResidue_pool = this.Residue_pool.getValue();
        this.runaEvap = this.aEvap.getValue();
        this.RD1_out_mm = this.RD1_out.getValue() / this.runarea;
        this.RD2_out_mm = this.RD2_out.getValue() / this.runarea;
        this.d_perco_mm = this.D_perco.getValue() / this.runarea;
        this.layer = 1;
        this.runvolati_trans = 0.0;
        this.runNH4inp = this.NH4inp.getValue();
        this.runplantupN = this.PlantupN.getValue();
        this.rundenit_trans = 0.0;
        this.runsurfaceN = 0.0;
        this.runinterflowN = 0.0;
        this.runpercoN = 0.0;
        this.runsurfaceN_in = this.SurfaceN_in.getValue() * 10000.0 / this.runarea;
        this.runinterflowN_in = this.InterflowN_in.getValue() * 10000.0 / this.runarea;
        this.runpercoN_in = this.PercoN_in.getValue() * 10000.0 / this.runarea;
        this.runBeta_trans = this.Beta_trans.getValue();
        this.runBeta_min = this.Beta_min.getValue();
        this.runBeta_rsd = this.Beta_rsd.getValue();
        this.runBeta_NO3 = this.Beta_NO3.getValue();
        this.runaTransp = this.aTransp.getValue();
        this.datumjul = this.time.get(6);
        this.gamma_temp = 0.9 * (this.runSoil_Temp_Layer / (this.runSoil_Temp_Layer * Math.exp(9.93 - 0.312 * this.runSoil_Temp_Layer))) + 0.1;
        this.gamma_water = this.sto_LPS + this.sto_MPS + this.sto_FPS > 0.0 ? (this.act_LPS + this.act_MPS + this.sto_FPS) / (this.sto_LPS + this.sto_MPS + this.sto_FPS) : 0.0;
        if (this.runnetPrecip > 0.0) {
            this.runNH4inp = 0.0 * this.runnetPrecip / this.runarea;
        }
        this.precalc_nit_vol = this.calc_nit_volati();
        if (this.datumjul == 100 || this.datumjul == 180) {
            this.runResidue_pool += 6000.0;
            this.runN_residue_pool_fresh += 9.0;
            this.runNH4_Pool += 100.0;
        }
        if (this.runaTransp > 0.0) {
            this.runplantupN = this.runaTransp / this.runarea * 0.3;
        }
        this.runvolati_trans = this.calc_voltalisation();
        this.runnitri_trans = this.calc_nitrification();
        this.Hum_trans = this.calc_Hum_trans();
        this.Hum_act_min = this.calc_Hum_act_min();
        this.runNH4_Pool = this.runNH4_Pool + this.runNH4inp - (this.runvolati_trans + this.runnitri_trans);
        if (this.runNH4_Pool < 0.0) {
            this.runNH4_Pool = 0.0;
        }
        this.runN_stabel_pool += this.Hum_trans;
        if (this.runN_stabel_pool < 0.0) {
            this.runN_stabel_pool = 0.0;
        }
        this.runN_activ_pool -= this.Hum_trans;
        if (this.runN_activ_pool < 0.0) {
            this.runN_activ_pool = 0.0;
        }
        if (this.layer < 3) {
            this.delta_ntr = this.calc_Res_N_trans();
            this.runResidue_pool -= this.delta_ntr * this.runResidue_pool;
            if (this.runResidue_pool < 0.0) {
                this.runResidue_pool = 0.0;
            }
            this.runN_activ_pool += 0.2 * (this.delta_ntr * this.runN_residue_pool_fresh);
            if (this.runN_activ_pool < 0.0) {
                this.runN_activ_pool = 0.0;
            }
            this.runNO3_Pool = this.runNO3_Pool + this.runnitri_trans + this.Hum_act_min + this.runinterflowN_in + this.runsurfaceN_in + 0.8 * (this.delta_ntr * this.runN_residue_pool_fresh);
            if (this.runNO3_Pool > this.runplantupN) {
                this.runNO3_Pool -= this.runplantupN;
            } else if (this.runNO3_Pool <= this.runplantupN) {
                this.runplantupN = this.runNO3_Pool;
                this.runNO3_Pool = 0.0;
            }
            this.rundenit_trans = this.calc_denitrification();
            this.runNO3_Pool -= this.rundenit_trans;
            if (this.runNO3_Pool < 0.0) {
                this.runNO3_Pool = 0.0;
            }
            this.runN_residue_pool_fresh -= this.delta_ntr * this.runN_residue_pool_fresh;
            if (this.runN_residue_pool_fresh < 0.0) {
                this.runN_residue_pool_fresh = 0.0;
            }
        } else if (this.layer >= 3) {
            this.runNO3_Pool = this.runNO3_Pool + this.runnitri_trans + this.runinterflowN_in + this.runpercoN_in;
            if (this.runNO3_Pool > this.runplantupN) {
                this.runNO3_Pool -= this.runplantupN;
            } else {
                this.runplantupN = this.runNO3_Pool;
                this.runNO3_Pool = 0.0;
            }
            this.rundenit_trans = this.calc_denitrification();
            this.runNO3_Pool -= this.rundenit_trans;
            if (this.runNO3_Pool < 0.0) {
                this.runNO3_Pool = 0.0;
            }
        }
        this.concN_mobile = this.calc_concN_mobile();
        this.runsurfaceN = this.calc_surfaceN();
        this.runNO3_Pool -= this.runsurfaceN;
        this.runinterflowN = this.calc_interflowN();
        this.runNO3_Pool -= this.runinterflowN;
        this.runpercoN = this.calc_percoN();
        this.runNO3_Pool -= this.runpercoN;
        if (this.runNO3_Pool < 0.0) {
            this.runNO3_Pool = 0.0;
        }
        if (this.datumjul == i) {
            ++i;
        }
        this.NO3_Pool.setValue(this.runNO3_Pool);
        this.NH4_Pool.setValue(this.runNH4_Pool);
        this.N_activ_pool.setValue(this.runN_activ_pool);
        this.N_stabel_pool.setValue(this.runN_stabel_pool);
        this.N_residue_pool_fresh.setValue(this.runN_residue_pool_fresh);
        this.Residue_pool.setValue(this.runResidue_pool);
        this.Volati_trans.setValue(this.runvolati_trans);
        this.Denit_trans.setValue(this.rundenit_trans);
        this.Nitri_trans.setValue(this.runnitri_trans);
        this.SurfaceN.setValue(this.runsurfaceN);
        this.runsurfaceNabs = this.runsurfaceN * this.runarea / 10000.0;
        this.SurfaceNabs.setValue(this.runsurfaceNabs);
        this.InterflowN.setValue(this.runinterflowN);
        this.runinterflowNabs = this.runinterflowN * this.runarea / 10000.0;
        this.InterflowNabs.setValue(this.runinterflowNabs);
        this.PercoN.setValue(this.runpercoN);
        this.runpercoNabs = this.runpercoN * this.runarea / 10000.0;
        this.PercoNabs.setValue(this.runpercoNabs);
        this.PlantupN.setValue(this.runplantupN);
    }

    private boolean calc_nit_volati() {
        double eta_water = 0.0;
        double eta_temp = 0.0;
        double eta_volz = 0.0;
        double eta_nitri = 0.0;
        double eta_volati = 0.0;
        eta_temp = 0.41 * ((this.runSoil_Temp_Layer - 5.0) / 10.0);
        if (this.act_LPS + this.act_MPS - this.sto_FPS < 0.25 * (this.sto_LPS + this.sto_MPS - this.sto_FPS)) {
            eta_water = (this.act_LPS + this.act_MPS - this.sto_FPS) / (0.25 * (this.sto_LPS + this.sto_MPS - this.sto_FPS));
        } else if (this.act_LPS + this.act_MPS - this.sto_FPS >= 0.25 * (this.sto_LPS + this.sto_MPS - this.sto_FPS)) {
            eta_water = 1.0;
        }
        eta_volz = 1.0 - this.runlayerdepth / (this.runlayerdepth + Math.exp(4.706 - 0.305 * this.runlayerdepth));
        eta_nitri = eta_water * eta_temp;
        eta_volati = eta_temp * eta_volz;
        this.N_nit_vol = this.runNH4_Pool * (1.0 - Math.exp(-eta_nitri - eta_volati));
        this.frac_nitr = 1.0 - Math.exp(-eta_nitri);
        this.frac_vol = 1.0 - Math.exp(-eta_volati);
        return true;
    }

    private double calc_Hum_trans() {
        double N_Hum_trans = 0.0;
        N_Hum_trans = this.runBeta_trans * (this.runN_activ_pool * (1.0 / this.fr_actN - 1.0) - this.runN_stabel_pool);
        return N_Hum_trans;
    }

    private double calc_Hum_act_min() {
        double N_Hum_act_min = 0.0;
        N_Hum_act_min = this.runBeta_min * Math.sqrt(this.gamma_temp * this.gamma_water) * this.runN_activ_pool;
        return N_Hum_act_min;
    }

    private double calc_Res_N_trans() {
        double epsilon_C_N = 0.0;
        double gamma_ntr = 0.0;
        epsilon_C_N = this.runResidue_pool * 0.58 / (this.runN_residue_pool_fresh + this.runNO3_Pool);
        gamma_ntr = Math.min(1.0, Math.exp(-0.693 * ((epsilon_C_N - 25.0) / 25.0)));
        this.delta_ntr = this.runBeta_rsd * gamma_ntr * Math.sqrt(this.gamma_temp * this.gamma_water);
        return this.delta_ntr;
    }

    private double calc_nitrification() {
        double nitri_trans = 0.0;
        if (!this.precalc_nit_vol) {
            this.calc_nit_volati();
        }
        if (this.runSoil_Temp_Layer > 5.0) {
            nitri_trans = this.frac_nitr / (this.frac_nitr + this.frac_vol) * this.N_nit_vol;
        } else if (this.runSoil_Temp_Layer <= 5.0) {
            nitri_trans = 0.0;
        }
        return nitri_trans;
    }

    private double calc_voltalisation() {
        double volati_trans = 0.0;
        if (!this.precalc_nit_vol) {
            this.calc_nit_volati();
        }
        if (this.runSoil_Temp_Layer > 5.0) {
            volati_trans = this.frac_vol / (this.frac_nitr + this.frac_vol) * this.N_nit_vol;
        } else if (this.runSoil_Temp_Layer <= 5.0) {
            volati_trans = 0.0;
        }
        return volati_trans;
    }

    private double calc_denitrification() {
        double denit_trans = 0.0;
        if (this.gamma_water > 0.75) {
            denit_trans = this.runNO3_Pool * (1.0 - Math.exp(-1.4 * this.gamma_temp * this.runC_org));
        } else if (this.gamma_water <= 0.75) {
            denit_trans = 0.0;
        }
        return denit_trans;
    }

    private double calc_nitrateupmove() {
        double n_upmove = 0.0;
        n_upmove = 0.1 * this.runNO3_Pool * (this.runaEvap / (this.act_LPS + this.act_MPS + this.sto_FPS));
        return n_upmove;
    }

    private double calc_concN_mobile() {
        double concN_mobile = 0.0;
        double concN_temp = 0.0;
        double mobilewater = 0.0;
        double soilstorage = 0.0;
        soilstorage = this.sto_LPS + this.sto_MPS + this.sto_FPS;
        if (this.layer == 1) {
            mobilewater = this.RD1_out_mm + this.RD2_out_mm + this.d_perco_mm + 1.0E-10;
        } else if (this.layer > 1) {
            mobilewater = this.RD2_out_mm + this.d_perco_mm + 1.0E-10;
        }
        concN_temp = this.runNO3_Pool * (1.0 - Math.exp(-mobilewater / ((1.0 - this.theta_nit) * soilstorage)));
        concN_mobile = concN_temp / mobilewater;
        if (concN_mobile < 0.0) {
            concN_mobile = 0.0;
        }
        return concN_mobile;
    }

    private double calc_concN_mobile2() {
        double concN_mobile = 0.0;
        double concN_temp = 0.0;
        double mobilewater = 0.0;
        double soilstorage = 0.0;
        soilstorage = this.sto_LPS + this.sto_MPS + this.sto_FPS;
        if (this.layer == 1) {
            mobilewater = this.RD1_out_mm + this.RD2_out_mm + this.d_perco_mm + 1.0E-10;
        } else if (this.layer > 1) {
            mobilewater = this.RD2_out_mm + this.d_perco_mm + 1.0E-10;
        }
        concN_mobile = this.runNO3_Pool / (mobilewater + (1.0 - this.theta_nit) * soilstorage);
        if (concN_mobile < 0.0) {
            concN_mobile = 0.0;
        }
        return concN_mobile;
    }

    private double calc_surfaceN() {
        double surfaceN = 0.0;
        if (this.layer == 1) {
            surfaceN = this.runBeta_NO3 * this.RD1_out_mm * this.concN_mobile;
            surfaceN = Math.min(surfaceN, this.runNO3_Pool);
        } else if (this.layer > 1) {
            surfaceN = 0.0;
        }
        return surfaceN;
    }

    private double calc_interflowN() {
        double interflowN = 0.0;
        if (this.layer == 1) {
            interflowN = (1.0 - this.runBeta_NO3) * this.RD2_out_mm * this.concN_mobile;
            interflowN = Math.min(interflowN, this.runNO3_Pool);
        } else if (this.layer > 1) {
            interflowN = this.RD2_out_mm * this.concN_mobile;
            interflowN = Math.min(interflowN, this.runNO3_Pool);
        }
        return interflowN;
    }

    private double calc_percoN() {
        double percoN = 0.0;
        percoN = this.d_perco_mm * this.concN_mobile;
        percoN = Math.min(percoN, this.runNO3_Pool);
        return percoN;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

